/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.protocol.management.jar;

import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import org.jetlinks.core.ProtocolSupport;
import org.jetlinks.core.spi.ProtocolSupportProvider;
import org.jetlinks.core.spi.ServiceContext;
import org.jetlinks.supports.protocol.management.ProtocolSupportDefinition;
import org.jetlinks.supports.protocol.management.ProtocolSupportLoaderProvider;
import org.jetlinks.supports.protocol.management.jar.ProtocolClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class JarProtocolSupportLoader
implements ProtocolSupportLoaderProvider {
    private static final Logger log = LoggerFactory.getLogger(JarProtocolSupportLoader.class);
    private ServiceContext serviceContext;
    private final Map<String, ProtocolClassLoader> protocolLoaders = new ConcurrentHashMap<String, ProtocolClassLoader>();
    private final Map<String, ProtocolSupportProvider> loaded = new ConcurrentHashMap<String, ProtocolSupportProvider>();

    @Override
    public String getProvider() {
        return "jar";
    }

    @Override
    public Mono<? extends ProtocolSupport> load(ProtocolSupportDefinition definition) {
        return Mono.defer(() -> {
            try {
                Map<String, Object> config = definition.getConfiguration();
                String location = Optional.ofNullable(config.get("location")).map(String::valueOf).orElseThrow(() -> new IllegalArgumentException("location"));
                String provider = Optional.ofNullable(config.get("provider")).map(String::valueOf).orElse(null);
                if (!location.contains("://")) {
                    location = "file://" + location;
                }
                location = "jar:" + location + "!/";
                log.debug("load protocol support from : {}", (Object)location);
                ProtocolClassLoader loader = new ProtocolClassLoader(location, this.getClass().getClassLoader());
                ProtocolClassLoader old = this.protocolLoaders.put(definition.getId(), loader);
                if (null != old) {
                    old.close();
                }
                ProtocolSupportProvider supportProvider = provider != null ? (ProtocolSupportProvider)loader.loadClass(provider).newInstance() : ServiceLoader.load(ProtocolSupportProvider.class, loader).iterator().next();
                ProtocolSupportProvider oldProvider = this.loaded.put(provider, supportProvider);
                try {
                    if (null != oldProvider) {
                        oldProvider.close();
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                return supportProvider.create(this.serviceContext);
            }
            catch (Exception e) {
                return Mono.error((Throwable)e);
            }
        }).subscribeOn(Schedulers.elastic()).timeout(Duration.ofSeconds(10L), Mono.error(TimeoutException::new));
    }

    public void setServiceContext(ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
    }
}

