/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.protocol.management;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetlinks.core.ProtocolSupport;
import org.jetlinks.supports.protocol.management.ProtocolSupportDefinition;
import org.jetlinks.supports.protocol.management.ProtocolSupportLoader;
import org.jetlinks.supports.protocol.management.ProtocolSupportLoaderProvider;
import reactor.core.publisher.Mono;

public class MuiltiProtocolSupportLoader
implements ProtocolSupportLoader {
    private Map<String, ProtocolSupportLoaderProvider> providers = new ConcurrentHashMap<String, ProtocolSupportLoaderProvider>();

    @Override
    public Mono<? extends ProtocolSupport> load(ProtocolSupportDefinition definition) {
        return Mono.justOrEmpty((Object)this.providers.get(definition.getProvider())).switchIfEmpty(Mono.error(() -> new UnsupportedOperationException("unsupported provider:" + definition.getProvider()))).flatMap(provider -> provider.load(definition));
    }

    public void register(ProtocolSupportLoaderProvider provider) {
        this.providers.put(provider.getProvider(), provider);
    }
}

