/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.protocol;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetlinks.core.ProtocolSupport;
import org.jetlinks.core.ProtocolSupports;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class StaticProtocolSupports
implements ProtocolSupports {
    protected Map<String, ProtocolSupport> supports = new ConcurrentHashMap<String, ProtocolSupport>();

    public boolean isSupport(String protocol) {
        return this.supports.containsKey(protocol);
    }

    public Mono<ProtocolSupport> getProtocol(String protocol) {
        ProtocolSupport support = this.supports.get(protocol);
        if (support == null) {
            return Mono.error((Throwable)new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u534f\u8bae:" + protocol));
        }
        return Mono.just((Object)support);
    }

    public Flux<ProtocolSupport> getProtocols() {
        return Flux.fromIterable(this.supports.values());
    }

    public void register(ProtocolSupport support) {
        this.supports.put(support.getId(), support);
    }

    public void unRegister(ProtocolSupport support) {
        this.unRegister(support.getId());
    }

    public void unRegister(String id) {
        this.supports.remove(id);
    }
}

