/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.official.types;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import java.util.Optional;
import org.jetlinks.core.metadata.types.DoubleType;
import org.jetlinks.core.metadata.unit.ValueUnits;
import org.jetlinks.supports.official.types.AbstractDataTypeCodec;

public class JetLinksDoubleCodec
extends AbstractDataTypeCodec<DoubleType> {
    public String getTypeId() {
        return "double";
    }

    @Override
    public DoubleType decode(DoubleType type, Map<String, Object> config) {
        super.decode(type, config);
        JSONObject jsonObject = new JSONObject(config);
        Optional.ofNullable(jsonObject.getDouble("max")).ifPresent(arg_0 -> ((DoubleType)type).setMax(arg_0));
        Optional.ofNullable(jsonObject.getDouble("min")).ifPresent(arg_0 -> ((DoubleType)type).setMin(arg_0));
        Optional.ofNullable(jsonObject.getInteger("scale")).ifPresent(arg_0 -> ((DoubleType)type).setScale(arg_0));
        Optional.ofNullable(jsonObject.getString("unit")).flatMap(ValueUnits::lookup).ifPresent(arg_0 -> ((DoubleType)type).setUnit(arg_0));
        return type;
    }

    @Override
    public Map<String, Object> encode(DoubleType type) {
        JSONObject json = new JSONObject();
        json.put("max", (Object)type.getMax());
        json.put("min", (Object)type.getMin());
        json.put("scale", (Object)type.getScale());
        if (type.getUnit() != null) {
            json.put("unit", (Object)type.getUnit().getId());
        }
        return json;
    }
}

