/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.official;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.DataTypeCodec;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.core.metadata.types.DataTypes;
import org.jetlinks.core.metadata.types.UnknownType;
import org.jetlinks.supports.official.JetLinksDataTypeCodecs;

public class JetLinksPropertyMetadata
implements PropertyMetadata {
    private JSONObject json;
    private transient DataType dataType;
    private String id;
    private String name;
    private String description;
    private Map<String, Object> expands;

    public JetLinksPropertyMetadata() {
    }

    public JetLinksPropertyMetadata(JSONObject json) {
        this.fromJson(json);
    }

    public JetLinksPropertyMetadata(PropertyMetadata another) {
        this.id = another.getId();
        this.name = another.getName();
        this.description = another.getDescription();
        this.dataType = another.getValueType();
    }

    protected Optional<DataTypeCodec<DataType>> getDataTypeCodec(DataType dataType) {
        return JetLinksDataTypeCodecs.getCodec(dataType.getId());
    }

    protected DataType parseDataType() {
        JSONObject dataTypeJson = this.json.getJSONObject("valueType");
        if (dataTypeJson == null) {
            throw new IllegalArgumentException("\u5c5e\u6027" + this.getId() + "\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DataType dataType = Optional.ofNullable(dataTypeJson.getString("type")).map(DataTypes::lookup).map(Supplier::get).orElseGet(UnknownType::new);
        this.getDataTypeCodec(dataType).ifPresent(codec -> codec.decode(dataType, (Map)dataTypeJson));
        return dataType;
    }

    public DataType getValueType() {
        if (this.dataType == null && this.json != null) {
            this.dataType = this.parseDataType();
        }
        return this.dataType;
    }

    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        json.put("id", (Object)this.id);
        json.put("name", (Object)this.name);
        json.put("description", (Object)this.description);
        json.put("valueType", JetLinksDataTypeCodecs.encode(this.getValueType()).orElse(null));
        return json;
    }

    public void fromJson(JSONObject jsonObject) {
        Objects.requireNonNull(jsonObject);
        this.json = jsonObject;
        this.id = this.json.getString("id");
        this.name = this.json.getString("name");
        this.description = this.json.getString("description");
        this.dataType = null;
        this.expands = this.json.getJSONObject("expands");
    }

    public String toString() {
        return String.join((CharSequence)"", this.getValueType().getId(), " ", this.getId(), " /* ", this.getName(), " */ ");
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<String, Object> getExpands() {
        return this.expands;
    }

    public void setExpands(Map<String, Object> expands) {
        this.expands = expands;
    }
}

