/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.official;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import org.jetlinks.core.config.ConfigKey;
import org.jetlinks.core.device.DeviceConfigKey;
import org.jetlinks.core.message.DeviceMessage;
import org.jetlinks.core.message.Message;
import org.jetlinks.core.message.codec.DefaultTransport;
import org.jetlinks.core.message.codec.DeviceMessageCodec;
import org.jetlinks.core.message.codec.MessageDecodeContext;
import org.jetlinks.core.message.codec.MessageEncodeContext;
import org.jetlinks.core.message.codec.MessagePayloadType;
import org.jetlinks.core.message.codec.MqttMessage;
import org.jetlinks.core.message.codec.SimpleMqttMessage;
import org.jetlinks.core.message.codec.Transport;
import org.jetlinks.supports.official.JetlinksTopicMessageCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class JetLinksMqttDeviceMessageCodec
extends JetlinksTopicMessageCodec
implements DeviceMessageCodec {
    private static final Logger log = LoggerFactory.getLogger(JetLinksMqttDeviceMessageCodec.class);
    private Transport transport;

    public JetLinksMqttDeviceMessageCodec(Transport transport) {
        this.transport = transport;
    }

    public JetLinksMqttDeviceMessageCodec() {
        this((Transport)DefaultTransport.MQTT);
    }

    public Transport getSupportTransport() {
        return this.transport;
    }

    @Nonnull
    public Mono<MqttMessage> encode(@Nonnull MessageEncodeContext context) {
        return Mono.defer(() -> {
            Message message = context.getMessage();
            if (message instanceof DeviceMessage) {
                DeviceMessage deviceMessage = (DeviceMessage)message;
                JetlinksTopicMessageCodec.EncodedTopic convertResult = this.encode(deviceMessage.getDeviceId(), (Message)deviceMessage);
                if (convertResult == null) {
                    return Mono.empty();
                }
                return context.getDevice().getConfig((ConfigKey)DeviceConfigKey.productId).defaultIfEmpty((Object)"null").map(productId -> SimpleMqttMessage.builder().clientId(deviceMessage.getDeviceId()).topic("/".concat((String)productId).concat(convertResult.topic)).payloadType(MessagePayloadType.JSON).payload(Unpooled.wrappedBuffer((byte[])JSON.toJSONBytes((Object)convertResult.payload, (SerializerFeature[])new SerializerFeature[0]))).build());
            }
            return Mono.empty();
        });
    }

    @Nonnull
    public Mono<Message> decode(@Nonnull MessageDecodeContext context) {
        return Mono.fromSupplier(() -> {
            MqttMessage message = (MqttMessage)context.getMessage();
            String topic = message.getTopic();
            String jsonData = message.getPayload().toString(StandardCharsets.UTF_8);
            JSONObject object = (JSONObject)JSON.parseObject((String)jsonData, JSONObject.class);
            if (object == null) {
                throw new UnsupportedOperationException("cannot parse payload:{}" + jsonData);
            }
            return this.decode(topic, object).getMessage();
        });
    }
}

