/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.official;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetlinks.core.metadata.DeviceMetadata;
import org.jetlinks.core.metadata.EventMetadata;
import org.jetlinks.core.metadata.FunctionMetadata;
import org.jetlinks.core.metadata.Jsonable;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.supports.official.JetLinksDeviceFunctionMetadata;
import org.jetlinks.supports.official.JetLinksEventMetadata;
import org.jetlinks.supports.official.JetLinksPropertyMetadata;

public class JetLinksDeviceMetadata
implements DeviceMetadata {
    private JSONObject jsonObject;
    private volatile List<PropertyMetadata> properties;
    private volatile List<FunctionMetadata> functions;
    private volatile List<EventMetadata> events;
    private volatile List<PropertyMetadata> tags;
    private String id;
    private String name;
    private String description;
    private Map<String, Object> expands;

    public JetLinksDeviceMetadata(JSONObject jsonObject) {
        this.jsonObject = jsonObject;
    }

    public JetLinksDeviceMetadata(DeviceMetadata another) {
        this.properties = another.getProperties().stream().map(JetLinksPropertyMetadata::new).collect(Collectors.toList());
        this.functions = another.getFunctions().stream().map(JetLinksDeviceFunctionMetadata::new).collect(Collectors.toList());
        this.events = another.getEvents().stream().map(JetLinksEventMetadata::new).collect(Collectors.toList());
    }

    public List<PropertyMetadata> getProperties() {
        if (this.properties == null && this.jsonObject != null) {
            this.properties = Optional.ofNullable(this.jsonObject.getJSONArray("properties")).map(Collection::stream).map(stream -> stream.map(JSONObject.class::cast).map(JetLinksPropertyMetadata::new).map(PropertyMetadata.class::cast).collect(Collectors.toList())).orElse(Collections.emptyList());
        }
        if (this.properties == null) {
            this.properties = new ArrayList<PropertyMetadata>();
        }
        return this.properties;
    }

    public List<FunctionMetadata> getFunctions() {
        if (this.functions == null && this.jsonObject != null) {
            this.functions = Optional.ofNullable(this.jsonObject.getJSONArray("functions")).map(Collection::stream).map(stream -> stream.map(JSONObject.class::cast).map(JetLinksDeviceFunctionMetadata::new).map(FunctionMetadata.class::cast).collect(Collectors.toList())).orElse(Collections.emptyList());
        }
        if (this.functions == null) {
            this.functions = new ArrayList<FunctionMetadata>();
        }
        return this.functions;
    }

    public List<PropertyMetadata> getTags() {
        if (this.tags == null && this.jsonObject != null) {
            this.tags = Optional.ofNullable(this.jsonObject.getJSONArray("tags")).map(Collection::stream).map(stream -> stream.map(JSONObject.class::cast).map(JetLinksPropertyMetadata::new).map(PropertyMetadata.class::cast).collect(Collectors.toList())).orElse(Collections.emptyList());
        }
        if (this.tags == null) {
            this.tags = new ArrayList<PropertyMetadata>();
        }
        return this.tags;
    }

    public List<EventMetadata> getEvents() {
        if (this.events == null && this.jsonObject != null) {
            this.events = Optional.ofNullable(this.jsonObject.getJSONArray("events")).map(Collection::stream).map(stream -> stream.map(JSONObject.class::cast).map(JetLinksEventMetadata::new).map(EventMetadata.class::cast).collect(Collectors.toList())).orElse(Collections.emptyList());
        }
        if (this.events == null) {
            this.events = new ArrayList<EventMetadata>();
        }
        return this.events;
    }

    public Optional<EventMetadata> getEvent(String id) {
        return this.getEvents().stream().filter(property -> property.getId().equals(id)).findFirst();
    }

    public Optional<PropertyMetadata> getProperty(String id) {
        return this.getProperties().stream().filter(property -> property.getId().equals(id)).findFirst();
    }

    public Optional<FunctionMetadata> getFunction(String id) {
        return this.getFunctions().stream().filter(function -> function.getId().equals(id)).findFirst();
    }

    public Optional<PropertyMetadata> getTag(String id) {
        return this.getTags().stream().filter(tag -> tag.getId().equals(id)).findFirst();
    }

    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        json.put("id", (Object)this.id);
        json.put("name", (Object)this.name);
        json.put("description", (Object)this.description);
        json.put("properties", this.getProperties().stream().map(Jsonable::toJson).collect(Collectors.toList()));
        json.put("functions", this.getFunctions().stream().map(Jsonable::toJson).collect(Collectors.toList()));
        json.put("events", this.getEvents().stream().map(Jsonable::toJson).collect(Collectors.toList()));
        json.put("expands", this.expands);
        return json;
    }

    public void fromJson(JSONObject json) {
        this.jsonObject = json;
        this.properties = null;
        this.events = null;
        this.functions = null;
        this.id = json.getString("id");
        this.name = json.getString("name");
        this.description = json.getString("description");
        this.expands = json.getJSONObject("expands");
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<String, Object> getExpands() {
        return this.expands;
    }

    public void setExpands(Map<String, Object> expands) {
        this.expands = expands;
    }
}

