/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.official;

import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.FunctionMetadata;
import org.jetlinks.core.metadata.Jsonable;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.core.metadata.types.DataTypes;
import org.jetlinks.core.metadata.types.UnknownType;
import org.jetlinks.supports.official.JetLinksDataTypeCodecs;
import org.jetlinks.supports.official.JetLinksPropertyMetadata;

public class JetLinksDeviceFunctionMetadata
implements FunctionMetadata {
    private transient JSONObject jsonObject;
    private transient FunctionMetadata another;
    private List<PropertyMetadata> inputs;
    private DataType output;
    private String id;
    private String name;
    private String description;
    private boolean async;
    private Map<String, Object> expands;

    public JetLinksDeviceFunctionMetadata(JSONObject jsonObject) {
        this.fromJson(jsonObject);
    }

    public JetLinksDeviceFunctionMetadata(FunctionMetadata another) {
        this.another = another;
    }

    public List<PropertyMetadata> getInputs() {
        if (this.inputs == null && this.jsonObject != null) {
            this.inputs = Optional.ofNullable(this.jsonObject.getJSONArray("inputs")).map(Collection::stream).map(stream -> stream.map(JSONObject.class::cast).map(JetLinksPropertyMetadata::new).map(PropertyMetadata.class::cast).collect(Collectors.toList())).orElse(Collections.emptyList());
        }
        if (this.inputs == null && this.another != null) {
            this.inputs = this.another.getInputs().stream().map(JetLinksPropertyMetadata::new).collect(Collectors.toList());
        }
        return this.inputs;
    }

    public DataType getOutput() {
        if (this.output == null && this.jsonObject != null) {
            this.output = Optional.ofNullable(this.jsonObject.getJSONObject("output")).flatMap(conf -> Optional.ofNullable(DataTypes.lookup((String)conf.getString("type"))).map(Supplier::get).map(type -> JetLinksDataTypeCodecs.decode(type, (Map<String, Object>)conf))).orElseGet(UnknownType::new);
        }
        if (this.output == null && this.another != null) {
            this.output = this.another.getOutput();
        }
        return this.output;
    }

    public String toString() {
        return String.join((CharSequence)"", "/* ", this.getName(), " */", this.getId(), "(", String.join((CharSequence)",", (CharSequence[])this.getInputs().stream().map(Object::toString).toArray(String[]::new)), ")");
    }

    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        json.put("id", (Object)this.id);
        json.put("name", (Object)this.name);
        json.put("description", (Object)this.description);
        json.put("async", (Object)this.async);
        json.put("inputs", this.getInputs().stream().map(Jsonable::toJson).collect(Collectors.toList()));
        JetLinksDataTypeCodecs.encode(this.getOutput()).ifPresent(ot -> json.put("output", ot));
        json.put("expands", this.expands);
        return json;
    }

    public void fromJson(JSONObject json) {
        this.jsonObject = json;
        this.inputs = null;
        this.output = null;
        this.id = json.getString("id");
        this.name = json.getString("name");
        this.description = json.getString("description");
        this.async = json.getBooleanValue("async");
        this.expands = json.getJSONObject("expands");
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public Map<String, Object> getExpands() {
        return this.expands;
    }

    public void setExpands(Map<String, Object> expands) {
        this.expands = expands;
    }
}

