/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.official;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.apache.commons.codec.digest.DigestUtils;
import org.eclipse.californium.core.coap.CoAP;
import org.hswebframework.web.id.IDGenerator;
import org.jetlinks.core.message.Message;
import org.jetlinks.core.message.codec.CoapExchangeMessage;
import org.jetlinks.core.message.codec.CoapMessage;
import org.jetlinks.core.message.codec.DefaultTransport;
import org.jetlinks.core.message.codec.DeviceMessageCodec;
import org.jetlinks.core.message.codec.EncodedMessage;
import org.jetlinks.core.message.codec.MessageDecodeContext;
import org.jetlinks.core.message.codec.MessageEncodeContext;
import org.jetlinks.core.message.codec.Transport;
import org.jetlinks.supports.official.JetlinksTopicMessageCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

public class JetLinksCoapDTLSDeviceMessageCodec
extends JetlinksTopicMessageCodec
implements DeviceMessageCodec {
    private static final Logger log = LoggerFactory.getLogger(JetLinksCoapDTLSDeviceMessageCodec.class);

    public Transport getSupportTransport() {
        return DefaultTransport.CoAP_DTLS;
    }

    public Mono<? extends Message> decode(CoapMessage message, MessageDecodeContext context, Consumer<Object> response) {
        return Mono.defer(() -> {
            String path = message.getPath();
            String sign = message.getStringOption(2110).orElse(null);
            String token = message.getStringOption(2111).orElse(null);
            String payload = message.getPayload().toString(StandardCharsets.UTF_8);
            if ("/auth".equals(path)) {
                return context.getDevice().getConfig("secureKey").flatMap(sk -> {
                    String secureKey = sk.asString();
                    if (!this.verifySign(secureKey, context.getDevice().getDeviceId(), payload, sign)) {
                        response.accept(CoAP.ResponseCode.BAD_REQUEST);
                        return Mono.empty();
                    }
                    String newToken = (String)IDGenerator.MD5.generate();
                    return context.getDevice().setConfig("coap-token", (Object)newToken).doOnSuccess(success -> {
                        JSONObject json = new JSONObject();
                        json.put("token", (Object)newToken);
                        response.accept(json.toJSONString());
                    });
                }).then(Mono.empty());
            }
            if (StringUtils.isEmpty((Object)token)) {
                response.accept(CoAP.ResponseCode.UNAUTHORIZED);
                return Mono.empty();
            }
            return context.getDevice().getConfig("coap-token").switchIfEmpty(Mono.fromRunnable(() -> response.accept(CoAP.ResponseCode.UNAUTHORIZED))).flatMap(value -> {
                String tk = value.asString();
                if (!token.equals(tk)) {
                    response.accept(CoAP.ResponseCode.UNAUTHORIZED);
                    return Mono.empty();
                }
                return Mono.just((Object)this.decode(path, JSON.parseObject((String)payload)).getMessage()).switchIfEmpty(Mono.fromRunnable(() -> response.accept(CoAP.ResponseCode.BAD_REQUEST)));
            }).doOnSuccess(msg -> response.accept(CoAP.ResponseCode.CREATED)).doOnError(error -> {
                log.error("decode coap message error", error);
                response.accept(CoAP.ResponseCode.BAD_REQUEST);
            });
        });
    }

    @Nonnull
    public Mono<? extends Message> decode(@Nonnull MessageDecodeContext context) {
        if (context.getMessage() instanceof CoapExchangeMessage) {
            CoapExchangeMessage exchangeMessage = (CoapExchangeMessage)context.getMessage();
            return this.decode((CoapMessage)exchangeMessage, context, resp -> {
                if (resp instanceof CoAP.ResponseCode) {
                    exchangeMessage.getExchange().respond((CoAP.ResponseCode)resp);
                }
                if (resp instanceof String) {
                    exchangeMessage.getExchange().respond((String)resp);
                }
            });
        }
        if (context.getMessage() instanceof CoapMessage) {
            return this.decode((CoapMessage)context.getMessage(), context, resp -> log.info("skip response coap request:{}", resp));
        }
        return Mono.empty();
    }

    protected boolean verifySign(String secureKey, String deviceId, String payload, String sign) {
        if (StringUtils.isEmpty((Object)secureKey) || !DigestUtils.md5Hex((String)payload.concat(secureKey)).equalsIgnoreCase(sign)) {
            log.info("device [{}] coap sign [{}] error, payload:{}", new Object[]{deviceId, sign, payload});
            return false;
        }
        return true;
    }

    @Nonnull
    public Mono<? extends EncodedMessage> encode(@Nonnull MessageEncodeContext context) {
        return Mono.empty();
    }
}

