/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.cluster.redis;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetlinks.core.cluster.ClusterCache;
import org.jetlinks.core.cluster.ClusterManager;
import org.jetlinks.core.cluster.ClusterNotifier;
import org.jetlinks.core.cluster.ClusterQueue;
import org.jetlinks.core.cluster.ClusterSet;
import org.jetlinks.core.cluster.ClusterTopic;
import org.jetlinks.core.cluster.HaManager;
import org.jetlinks.core.cluster.ServerNode;
import org.jetlinks.supports.cluster.redis.RedisClusterCache;
import org.jetlinks.supports.cluster.redis.RedisClusterNotifier;
import org.jetlinks.supports.cluster.redis.RedisClusterQueue;
import org.jetlinks.supports.cluster.redis.RedisClusterSet;
import org.jetlinks.supports.cluster.redis.RedisClusterTopic;
import org.jetlinks.supports.cluster.redis.RedisHaManager;
import org.springframework.data.redis.core.ReactiveRedisOperations;

public class RedisClusterManager
implements ClusterManager {
    private String clusterName;
    private String serverId;
    private Map<String, ClusterQueue> queues = new ConcurrentHashMap<String, ClusterQueue>();
    private Map<String, ClusterTopic> topics = new ConcurrentHashMap<String, ClusterTopic>();
    private Map<String, ClusterCache> caches = new ConcurrentHashMap<String, ClusterCache>();
    private Map<String, ClusterSet> sets = new ConcurrentHashMap<String, ClusterSet>();
    private ReactiveRedisOperations<?, ?> commonOperations;
    private RedisHaManager haManager;
    private RedisClusterNotifier notifier;

    public RedisClusterManager(String name, ServerNode serverNode, ReactiveRedisOperations<?, ?> operations) {
        this.clusterName = name;
        this.commonOperations = operations;
        this.notifier = new RedisClusterNotifier(name, serverNode.getId(), this);
        this.serverId = serverNode.getId();
        this.haManager = new RedisHaManager(name, serverNode, this, operations);
    }

    public RedisClusterManager(String name, String serverId, ReactiveRedisOperations<?, ?> operations) {
        this(name, ServerNode.builder().id(serverId).build(), operations);
    }

    public String getCurrentServerId() {
        return this.serverId;
    }

    public void startup() {
        this.notifier.startup();
        this.haManager.startup();
    }

    public void shutdown() {
        this.haManager.shutdown();
    }

    public HaManager getHaManager() {
        return this.haManager;
    }

    protected <K, V> ReactiveRedisOperations<K, V> getRedis() {
        return this.commonOperations;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public ClusterNotifier getNotifier() {
        return this.notifier;
    }

    public <T> ClusterQueue<T> getQueue(String queueId) {
        return this.queues.computeIfAbsent(queueId, id -> new RedisClusterQueue(queueId, this.getRedis()));
    }

    public <T> ClusterTopic<T> getTopic(String topic) {
        return this.topics.computeIfAbsent(topic, id -> new RedisClusterTopic(topic, this.getRedis()));
    }

    public <K, V> ClusterCache<K, V> getCache(String cache) {
        return this.caches.computeIfAbsent(cache, id -> new RedisClusterCache(cache, this.getRedis()));
    }

    public <V> ClusterSet<V> getSet(String name) {
        return this.sets.computeIfAbsent(name, id -> new RedisClusterSet(name, this.getRedis()));
    }
}

