/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.misc;

import com.alibaba.nacos.common.executor.ExecutorFactory;
import com.alibaba.nacos.common.executor.NameThreadFactory;
import com.alibaba.nacos.core.utils.ClassUtils;
import com.alibaba.nacos.naming.NamingApp;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class GlobalExecutor {
    private static final long SERVER_STATUS_UPDATE_PERIOD = TimeUnit.SECONDS.toMillis(5L);
    public static final int DEFAULT_THREAD_COUNT = EnvUtil.getAvailableProcessors((double)0.5);
    private static final ScheduledExecutorService NAMING_TIMER_EXECUTOR = ExecutorFactory.Managed.newScheduledExecutorService((String)ClassUtils.getCanonicalName(NamingApp.class), (int)EnvUtil.getAvailableProcessors((int)2), (ThreadFactory)new NameThreadFactory("com.alibaba.nacos.naming.timer"));
    private static final ExecutorService MYSQL_CHECK_EXECUTOR = ExecutorFactory.Managed.newFixedExecutorService((String)ClassUtils.getCanonicalName(NamingApp.class), (int)DEFAULT_THREAD_COUNT, (ThreadFactory)new NameThreadFactory("com.alibaba.nacos.naming.mysql.checker"));
    private static final ScheduledExecutorService TCP_SUPER_SENSE_EXECUTOR = ExecutorFactory.Managed.newScheduledExecutorService((String)ClassUtils.getCanonicalName(NamingApp.class), (int)DEFAULT_THREAD_COUNT, (ThreadFactory)new NameThreadFactory("com.alibaba.nacos.naming.supersense.checker"));
    private static final ExecutorService TCP_CHECK_EXECUTOR = ExecutorFactory.Managed.newFixedExecutorService((String)ClassUtils.getCanonicalName(NamingApp.class), (int)2, (ThreadFactory)new NameThreadFactory("com.alibaba.nacos.naming.tcp.check.worker"));
    private static final ScheduledExecutorService NAMING_HEALTH_EXECUTOR = ExecutorFactory.Managed.newScheduledExecutorService((String)ClassUtils.getCanonicalName(NamingApp.class), (int)Integer.max(Integer.getInteger("com.alibaba.nacos.naming.health.thread.num", DEFAULT_THREAD_COUNT), 1), (ThreadFactory)new NameThreadFactory("com.alibaba.nacos.naming.health"));
    private static final ScheduledExecutorService RETRANSMITTER_EXECUTOR = ExecutorFactory.Managed.newSingleScheduledExecutorService((String)ClassUtils.getCanonicalName(NamingApp.class), (ThreadFactory)new NameThreadFactory("com.alibaba.nacos.naming.push.retransmitter"));
    private static final ScheduledExecutorService UDP_SENDER_EXECUTOR = ExecutorFactory.Managed.newSingleScheduledExecutorService((String)ClassUtils.getCanonicalName(NamingApp.class), (ThreadFactory)new NameThreadFactory("com.alibaba.nacos.naming.push.udpSender"));
    private static final ScheduledExecutorService SERVER_PERFORMANCE_EXECUTOR = ExecutorFactory.Managed.newSingleScheduledExecutorService((String)ClassUtils.getCanonicalName(NamingApp.class), (ThreadFactory)new NameThreadFactory("com.alibaba.nacos.naming.nacos-server-performance"));
    private static final ScheduledExecutorService EXPIRED_CLIENT_CLEANER_EXECUTOR = ExecutorFactory.Managed.newSingleScheduledExecutorService((String)ClassUtils.getCanonicalName(NamingApp.class), (ThreadFactory)new NameThreadFactory("com.alibaba.nacos.naming.remote-connection-manager"));
    private static final ExecutorService PUSH_CALLBACK_EXECUTOR = ExecutorFactory.Managed.newSingleExecutorService((String)"Push", (ThreadFactory)new NameThreadFactory("com.alibaba.nacos.naming.push.callback"));
    private static final ScheduledExecutorService MONITOR_HEALTH_CHECK_POOL_EXECUTOR = ExecutorFactory.Managed.newScheduledExecutorService((String)ClassUtils.getCanonicalName(NamingApp.class), (int)1, (ThreadFactory)new NameThreadFactory("com.alibaba.nacos.naming.health-check-pool"));

    public static void registerServerStatusUpdater(Runnable runnable) {
        NAMING_TIMER_EXECUTOR.scheduleAtFixedRate(runnable, 0L, SERVER_STATUS_UPDATE_PERIOD, TimeUnit.MILLISECONDS);
    }

    public static void executeMysqlCheckTask(Runnable runnable) {
        MYSQL_CHECK_EXECUTOR.execute(runnable);
    }

    public static void submitTcpCheck(Runnable runnable) {
        TCP_CHECK_EXECUTOR.submit(runnable);
    }

    public static <T> List<Future<T>> invokeAllTcpSuperSenseTask(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return TCP_SUPER_SENSE_EXECUTOR.invokeAll(tasks);
    }

    public static void executeTcpSuperSense(Runnable runnable) {
        TCP_SUPER_SENSE_EXECUTOR.execute(runnable);
    }

    public static void scheduleTcpSuperSenseTask(Runnable runnable, long delay, TimeUnit unit) {
        TCP_SUPER_SENSE_EXECUTOR.schedule(runnable, delay, unit);
    }

    public static ScheduledFuture<?> scheduleNamingHealth(Runnable command, long delay, TimeUnit unit) {
        return NAMING_HEALTH_EXECUTOR.schedule(command, delay, unit);
    }

    public static ScheduledFuture<?> scheduleNamingHealth(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return NAMING_HEALTH_EXECUTOR.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    public static void scheduleRetransmitter(Runnable runnable, long delay, TimeUnit unit) {
        RETRANSMITTER_EXECUTOR.schedule(runnable, delay, unit);
    }

    public static ScheduledFuture<?> scheduleUdpSender(Runnable runnable, long delay, TimeUnit unit) {
        return UDP_SENDER_EXECUTOR.schedule(runnable, delay, unit);
    }

    public static void scheduleUdpReceiver(Runnable runnable) {
        NAMING_TIMER_EXECUTOR.submit(runnable);
    }

    public static void schedulePerformanceLogger(Runnable runnable, long initialDelay, long delay, TimeUnit unit) {
        SERVER_PERFORMANCE_EXECUTOR.scheduleWithFixedDelay(runnable, initialDelay, delay, unit);
    }

    public static void scheduleExpiredClientCleaner(Runnable runnable, long initialDelay, long delay, TimeUnit unit) {
        EXPIRED_CLIENT_CLEANER_EXECUTOR.scheduleWithFixedDelay(runnable, initialDelay, delay, unit);
    }

    public static ExecutorService getCallbackExecutor() {
        return PUSH_CALLBACK_EXECUTOR;
    }

    public static ScheduledFuture<?> scheduleMonitorHealthCheckPool(Runnable runnable, long initialDelay, long delay, TimeUnit unit) {
        return MONITOR_HEALTH_CHECK_POOL_EXECUTOR.scheduleWithFixedDelay(runnable, initialDelay, delay, unit);
    }
}

