/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.controllers.v2;

import com.alibaba.nacos.api.annotation.NacosApi;
import com.alibaba.nacos.api.exception.api.NacosApiException;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.api.selector.Selector;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.trace.event.naming.DeregisterServiceTraceEvent;
import com.alibaba.nacos.common.trace.event.naming.RegisterServiceTraceEvent;
import com.alibaba.nacos.common.trace.event.naming.UpdateServiceTraceEvent;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.control.TpsControl;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.naming.core.ServiceOperatorV2Impl;
import com.alibaba.nacos.naming.core.v2.metadata.ServiceMetadata;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.alibaba.nacos.naming.misc.UtilsAndCommons;
import com.alibaba.nacos.naming.model.form.ServiceForm;
import com.alibaba.nacos.naming.paramcheck.NamingDefaultHttpParamExtractor;
import com.alibaba.nacos.naming.pojo.ServiceDetailInfo;
import com.alibaba.nacos.naming.pojo.ServiceNameView;
import com.alibaba.nacos.naming.selector.NoneSelector;
import com.alibaba.nacos.naming.selector.SelectorManager;
import com.alibaba.nacos.naming.utils.ServiceUtil;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.fasterxml.jackson.databind.JsonNode;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@NacosApi
@RestController
@RequestMapping(value={"/v2/ns/service"})
@ExtractorManager.Extractor(httpExtractor=NamingDefaultHttpParamExtractor.class)
public class ServiceControllerV2 {
    private final ServiceOperatorV2Impl serviceOperatorV2;
    private final SelectorManager selectorManager;

    public ServiceControllerV2(ServiceOperatorV2Impl serviceOperatorV2, SelectorManager selectorManager) {
        this.serviceOperatorV2 = serviceOperatorV2;
        this.selectorManager = selectorManager;
    }

    @PostMapping
    @TpsControl(pointName="NamingServiceRegister", name="HttpNamingServiceRegister")
    @Secured(action=ActionTypes.WRITE)
    public Result<String> create(ServiceForm serviceForm) throws Exception {
        serviceForm.validate();
        ServiceMetadata serviceMetadata = new ServiceMetadata();
        serviceMetadata.setProtectThreshold(serviceForm.getProtectThreshold().floatValue());
        serviceMetadata.setSelector(this.parseSelector(serviceForm.getSelector()));
        serviceMetadata.setExtendData(UtilsAndCommons.parseMetadata(serviceForm.getMetadata()));
        serviceMetadata.setEphemeral(serviceForm.getEphemeral());
        this.serviceOperatorV2.create(Service.newService(serviceForm.getNamespaceId(), serviceForm.getGroupName(), serviceForm.getServiceName(), serviceForm.getEphemeral()), serviceMetadata);
        NotifyCenter.publishEvent((Event)new RegisterServiceTraceEvent(System.currentTimeMillis(), serviceForm.getNamespaceId(), serviceForm.getGroupName(), serviceForm.getServiceName()));
        return Result.success((Object)"ok");
    }

    @DeleteMapping
    @TpsControl(pointName="NamingServiceDeregister", name="HttpNamingServiceDeregister")
    @Secured(action=ActionTypes.WRITE)
    public Result<String> remove(@RequestParam(value="namespaceId", defaultValue="public") String namespaceId, @RequestParam(value="serviceName") String serviceName, @RequestParam(value="groupName", defaultValue="DEFAULT_GROUP") String groupName) throws Exception {
        this.serviceOperatorV2.delete(Service.newService(namespaceId, groupName, serviceName));
        NotifyCenter.publishEvent((Event)new DeregisterServiceTraceEvent(System.currentTimeMillis(), namespaceId, groupName, serviceName));
        return Result.success((Object)"ok");
    }

    @GetMapping
    @TpsControl(pointName="NamingServiceQuery", name="HttpNamingServiceQuery")
    @Secured(action=ActionTypes.READ)
    public Result<ServiceDetailInfo> detail(@RequestParam(value="namespaceId", defaultValue="public") String namespaceId, @RequestParam(value="serviceName") String serviceName, @RequestParam(value="groupName", defaultValue="DEFAULT_GROUP") String groupName) throws Exception {
        ServiceDetailInfo result = this.serviceOperatorV2.queryService(Service.newService(namespaceId, groupName, serviceName));
        return Result.success((Object)result);
    }

    @GetMapping(value={"/list"})
    @TpsControl(pointName="NamingServiceListQuery", name="HttpNamingServiceListQuery")
    @Secured(action=ActionTypes.READ)
    public Result<ServiceNameView> list(@RequestParam(value="namespaceId", required=false, defaultValue="public") String namespaceId, @RequestParam(value="groupName", required=false, defaultValue="DEFAULT_GROUP") String groupName, @RequestParam(value="selector", required=false, defaultValue="") String selector, @RequestParam(value="pageNo", required=false, defaultValue="1") Integer pageNo, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize) throws Exception {
        pageSize = Math.min(500, pageSize);
        ServiceNameView result = new ServiceNameView();
        Collection<String> serviceNameList = this.serviceOperatorV2.listService(namespaceId, groupName, selector);
        result.setCount(serviceNameList.size());
        result.setServices(ServiceUtil.pageServiceName(pageNo, pageSize, serviceNameList));
        return Result.success((Object)result);
    }

    @PutMapping
    @TpsControl(pointName="NamingServiceUpdate", name="HttpNamingServiceUpdate")
    @Secured(action=ActionTypes.WRITE)
    public Result<String> update(ServiceForm serviceForm) throws Exception {
        serviceForm.validate();
        Map<String, String> metadata = UtilsAndCommons.parseMetadata(serviceForm.getMetadata());
        ServiceMetadata serviceMetadata = new ServiceMetadata();
        serviceMetadata.setProtectThreshold(serviceForm.getProtectThreshold().floatValue());
        serviceMetadata.setExtendData(metadata);
        serviceMetadata.setSelector(this.parseSelector(serviceForm.getSelector()));
        Service service = Service.newService(serviceForm.getNamespaceId(), serviceForm.getGroupName(), serviceForm.getServiceName());
        this.serviceOperatorV2.update(service, serviceMetadata);
        NotifyCenter.publishEvent((Event)new UpdateServiceTraceEvent(System.currentTimeMillis(), serviceForm.getNamespaceId(), serviceForm.getGroupName(), serviceForm.getServiceName(), metadata));
        return Result.success((Object)"ok");
    }

    private Selector parseSelector(String selectorJsonString) throws Exception {
        String expression;
        if (StringUtils.isBlank((CharSequence)selectorJsonString)) {
            return new NoneSelector();
        }
        JsonNode selectorJson = JacksonUtils.toObj((String)URLDecoder.decode(selectorJsonString, "UTF-8"));
        String type = Optional.ofNullable(selectorJson.get("type")).orElseThrow(() -> new NacosApiException(400, ErrorCode.SELECTOR_ERROR, "not match any type of selector!")).asText();
        Selector selector = this.selectorManager.parseSelector(type, expression = (String)Optional.ofNullable(selectorJson.get("expression")).map(JsonNode::asText).orElse(null));
        if (Objects.isNull(selector)) {
            throw new NacosApiException(400, ErrorCode.SELECTOR_ERROR, "not match any type of selector!");
        }
        return selector;
    }
}

