/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.consistency.persistent;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.core.distributed.ProtocolManager;
import com.alibaba.nacos.naming.consistency.Datum;
import com.alibaba.nacos.naming.consistency.RecordListener;
import com.alibaba.nacos.naming.consistency.persistent.PersistentConsistencyService;
import com.alibaba.nacos.naming.consistency.persistent.impl.BasePersistentServiceProcessor;
import com.alibaba.nacos.naming.consistency.persistent.impl.PersistentServiceProcessor;
import com.alibaba.nacos.naming.consistency.persistent.impl.StandalonePersistentServiceProcessor;
import com.alibaba.nacos.naming.pojo.Record;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.util.Optional;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

@DependsOn(value={"ProtocolManager"})
@Component(value="persistentConsistencyServiceDelegate")
public class PersistentConsistencyServiceDelegateImpl
implements PersistentConsistencyService {
    private final BasePersistentServiceProcessor persistentServiceProcessor;

    public PersistentConsistencyServiceDelegateImpl(ProtocolManager protocolManager) throws Exception {
        this.persistentServiceProcessor = this.createPersistentServiceProcessor(protocolManager);
    }

    @Override
    public void put(String key, Record value) throws NacosException {
        this.persistentServiceProcessor.put(key, value);
    }

    @Override
    public void remove(String key) throws NacosException {
        this.persistentServiceProcessor.remove(key);
    }

    @Override
    public Datum get(String key) throws NacosException {
        return this.persistentServiceProcessor.get(key);
    }

    @Override
    public void listen(String key, RecordListener listener) throws NacosException {
        this.persistentServiceProcessor.listen(key, listener);
    }

    @Override
    public void unListen(String key, RecordListener listener) throws NacosException {
        this.persistentServiceProcessor.unListen(key, listener);
    }

    @Override
    public boolean isAvailable() {
        return this.persistentServiceProcessor.isAvailable();
    }

    @Override
    public Optional<String> getErrorMsg() {
        return this.persistentServiceProcessor.getErrorMsg();
    }

    private BasePersistentServiceProcessor createPersistentServiceProcessor(ProtocolManager protocolManager) throws Exception {
        BasePersistentServiceProcessor processor = EnvUtil.getStandaloneMode() ? new StandalonePersistentServiceProcessor() : new PersistentServiceProcessor(protocolManager);
        processor.afterConstruct();
        return processor;
    }
}

