/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.datasource.mapper;

import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.plugin.datasource.mapper.Mapper;
import com.alibaba.nacos.plugin.datasource.model.MapperContext;
import com.alibaba.nacos.plugin.datasource.model.MapperResult;
import java.util.ArrayList;
import java.util.List;

public interface ConfigInfoAggrMapper
extends Mapper {
    default public MapperResult batchRemoveAggr(MapperContext context) {
        List datumList = (List)context.getWhereParameter("datumId");
        String dataId = (String)context.getWhereParameter("dataId");
        String group = (String)context.getWhereParameter("groupId");
        String tenantTmp = (String)context.getWhereParameter("tenantId");
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(dataId);
        paramList.add(group);
        paramList.add(tenantTmp);
        StringBuilder placeholderString = new StringBuilder();
        for (int i = 0; i < datumList.size(); ++i) {
            if (i != 0) {
                placeholderString.append(", ");
            }
            placeholderString.append('?');
            paramList.add(datumList.get(i));
        }
        String sql = "DELETE FROM config_info_aggr WHERE data_id = ? AND group_id = ? AND tenant_id = ? AND datum_id IN (" + placeholderString + ")";
        return new MapperResult(sql, paramList);
    }

    default public MapperResult aggrConfigInfoCount(MapperContext context) {
        List datumIds = (List)context.getWhereParameter("datumId");
        Boolean isIn = (Boolean)context.getWhereParameter("isIn");
        String dataId = (String)context.getWhereParameter("dataId");
        String group = (String)context.getWhereParameter("groupId");
        String tenantTmp = (String)context.getWhereParameter("tenantId");
        List paramList = CollectionUtils.list((Object[])new Object[]{dataId, group, tenantTmp});
        StringBuilder sql = new StringBuilder("SELECT count(*) FROM config_info_aggr WHERE data_id = ? AND group_id = ? AND tenant_id = ? AND datum_id");
        if (isIn.booleanValue()) {
            sql.append(" IN (");
        } else {
            sql.append(" NOT IN (");
        }
        for (int i = 0; i < datumIds.size(); ++i) {
            if (i > 0) {
                sql.append(", ");
            }
            sql.append('?');
            paramList.add(datumIds.get(i));
        }
        sql.append(')');
        return new MapperResult(sql.toString(), paramList);
    }

    default public MapperResult findConfigInfoAggrIsOrdered(MapperContext context) {
        String dataId = (String)context.getWhereParameter("dataId");
        String groupId = (String)context.getWhereParameter("groupId");
        String tenantId = (String)context.getWhereParameter("tenantId");
        String sql = "SELECT data_id,group_id,tenant_id,datum_id,app_name,content FROM config_info_aggr WHERE data_id = ? AND group_id = ? AND tenant_id = ? ORDER BY datum_id";
        List paramList = CollectionUtils.list((Object[])new Object[]{dataId, groupId, tenantId});
        return new MapperResult(sql, paramList);
    }

    public MapperResult findConfigInfoAggrByPageFetchRows(MapperContext var1);

    default public MapperResult findAllAggrGroupByDistinct(MapperContext context) {
        return new MapperResult("SELECT DISTINCT data_id, group_id, tenant_id FROM config_info_aggr", CollectionUtils.list((Object[])new Object[0]));
    }

    @Override
    default public String getTableName() {
        return "config_info_aggr";
    }
}

