/*
 * Copyright 1999-2018 Alibaba Group Holding Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.alibaba.nacos.config.server.service.dump.task;

import com.alibaba.nacos.common.task.AbstractDelayTask;

/**
 * Dump all task.
 *
 * @author Nacos
 * @date 2020/7/5 12:17 PM
 */
public class DumpAllTask extends AbstractDelayTask {
    
    private boolean startUp;
    
    public DumpAllTask() {
    }
    
    public DumpAllTask(boolean startUp) {
        this.startUp = startUp;
    }
    
    public boolean isStartUp() {
        return startUp;
    }
    
    @Override
    public void merge(AbstractDelayTask task) {
    }
    
    public static final String TASK_ID = "dumpAllConfigTask";
}
