/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.logging.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.LoggerContextListener;
import com.alibaba.nacos.client.logging.AbstractNacosLogging;
import com.alibaba.nacos.common.log.NacosLogbackConfigurator;
import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.alibaba.nacos.common.utils.ResourceUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import java.util.Collection;
import org.slf4j.LoggerFactory;

public class LogbackNacosLogging
extends AbstractNacosLogging {
    private static final String NACOS_LOGBACK_LOCATION = "classpath:nacos-logback.xml";
    private Integer userVersion = 2;

    public LogbackNacosLogging() {
        try {
            Class.forName("ch.qos.logback.core.model.Model");
        }
        catch (ClassNotFoundException e) {
            this.userVersion = 1;
        }
    }

    @Override
    public void loadConfiguration() {
        LoggerContext loggerContext = this.loadConfigurationOnStart();
        if (loggerContext.getObject("RECONFIGURE_ON_CHANGE_TASK") != null && !this.hasListener(loggerContext)) {
            this.addListener(loggerContext);
        }
    }

    private boolean hasListener(LoggerContext loggerContext) {
        for (LoggerContextListener loggerContextListener : loggerContext.getCopyOfListenerList()) {
            if (!(loggerContextListener instanceof NacosLoggerContextListener)) continue;
            return true;
        }
        return false;
    }

    private LoggerContext loadConfigurationOnStart() {
        String location = this.getLocation(NACOS_LOGBACK_LOCATION);
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        Collection nacosLogbackConfigurators = NacosServiceLoader.load(NacosLogbackConfigurator.class);
        nacosLogbackConfigurators.stream().filter(c -> c.getVersion() == this.userVersion.intValue()).findFirst().ifPresent(nacosLogbackConfigurator -> {
            nacosLogbackConfigurator.setContext((Object)loggerContext);
            if (StringUtils.isNotBlank((String)location)) {
                try {
                    nacosLogbackConfigurator.configure(ResourceUtils.getResourceUrl((String)location));
                }
                catch (Exception e) {
                    throw new IllegalStateException("Could not initialize Logback Nacos logging from " + location, e);
                }
            }
        });
        return loggerContext;
    }

    private void addListener(LoggerContext loggerContext) {
        loggerContext.addListener((LoggerContextListener)new NacosLoggerContextListener());
    }

    class NacosLoggerContextListener
    implements LoggerContextListener {
        NacosLoggerContextListener() {
        }

        public boolean isResetResistant() {
            return true;
        }

        public void onReset(LoggerContext context) {
            LogbackNacosLogging.this.loadConfigurationOnStart();
        }

        public void onStart(LoggerContext context) {
        }

        public void onStop(LoggerContext context) {
        }

        public void onLevelChange(Logger logger, Level level) {
        }
    }
}

