/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.logging;

import com.alibaba.nacos.client.logging.AbstractNacosLogging;
import com.alibaba.nacos.client.logging.log4j2.Log4J2NacosLogging;
import com.alibaba.nacos.client.logging.logback.LogbackNacosLogging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosLogging {
    private static final Logger LOGGER = LoggerFactory.getLogger(NacosLogging.class);
    private AbstractNacosLogging nacosLogging;
    private boolean isLogback = false;

    private NacosLogging() {
        try {
            Class.forName("ch.qos.logback.classic.Logger");
            this.nacosLogging = new LogbackNacosLogging();
            this.isLogback = true;
        }
        catch (ClassNotFoundException e) {
            this.nacosLogging = new Log4J2NacosLogging();
        }
    }

    public static NacosLogging getInstance() {
        return NacosLoggingInstance.INSTANCE;
    }

    public void loadConfiguration() {
        try {
            this.nacosLogging.loadConfiguration();
        }
        catch (Throwable t) {
            String loggerName = this.isLogback ? "Logback" : "Log4j";
            LOGGER.warn("Load {} Configuration of Nacos fail, message: {}", (Object)loggerName, (Object)t.getMessage());
        }
    }

    private static class NacosLoggingInstance {
        private static final NacosLogging INSTANCE = new NacosLogging();

        private NacosLoggingInstance() {
        }
    }
}

