/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.auth.ram.identify;

import com.alibaba.nacos.client.auth.ram.identify.CredentialListener;
import com.alibaba.nacos.client.auth.ram.identify.CredentialWatcher;
import com.alibaba.nacos.client.auth.ram.identify.Credentials;
import com.alibaba.nacos.client.auth.ram.identify.SpasCredentialLoader;
import com.alibaba.nacos.client.env.NacosClientProperties;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;

public final class CredentialService
implements SpasCredentialLoader {
    private static final Logger LOGGER = LogUtils.logger(CredentialService.class);
    private static final ConcurrentHashMap<String, CredentialService> INSTANCES = new ConcurrentHashMap();
    private final String appName;
    private Credentials credentials = new Credentials();
    private final CredentialWatcher watcher;
    private CredentialListener listener;

    private CredentialService(String appName) {
        String value;
        if (appName == null && StringUtils.isNotEmpty((String)(value = NacosClientProperties.PROTOTYPE.getProperty("project.name")))) {
            appName = value;
        }
        this.appName = appName;
        this.watcher = new CredentialWatcher(appName, this);
    }

    public static CredentialService getInstance() {
        return CredentialService.getInstance(null);
    }

    public static CredentialService getInstance(String appName) {
        String key = appName != null ? appName : "";
        return INSTANCES.computeIfAbsent(key, k -> new CredentialService(appName));
    }

    public static CredentialService freeInstance() {
        return CredentialService.freeInstance(null);
    }

    public static CredentialService freeInstance(String appName) {
        String key = appName != null ? appName : "";
        CredentialService instance = INSTANCES.remove(key);
        if (instance != null) {
            instance.free();
        }
        return instance;
    }

    public void free() {
        if (this.watcher != null) {
            this.watcher.stop();
        }
        LOGGER.info("[{}] {} is freed", (Object)this.appName, (Object)this.getClass().getSimpleName());
    }

    @Override
    public Credentials getCredential() {
        return this.credentials;
    }

    public void setCredential(Credentials credential) {
        boolean changed = this.credentials != credential && (this.credentials == null || !this.credentials.identical(credential));
        this.credentials = credential;
        if (changed && this.listener != null) {
            this.listener.onUpdateCredential();
        }
    }

    public void setStaticCredential(Credentials credential) {
        if (this.watcher != null) {
            this.watcher.stop();
        }
        this.setCredential(credential);
    }

    public void registerCredentialListener(CredentialListener listener) {
        this.listener = listener;
    }
}

