/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.control.impl;

import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.plugin.control.Loggers;
import com.alibaba.nacos.plugin.control.connection.ConnectionControlManager;
import com.alibaba.nacos.plugin.control.connection.ConnectionMetricsCollector;
import com.alibaba.nacos.plugin.control.connection.request.ConnectionCheckRequest;
import com.alibaba.nacos.plugin.control.connection.response.ConnectionCheckResponse;
import com.alibaba.nacos.plugin.control.connection.rule.ConnectionControlRule;
import java.util.Map;
import java.util.stream.Collectors;

public class NacosConnectionControlManager
extends ConnectionControlManager {
    public String getName() {
        return "nacos";
    }

    public void applyConnectionLimitRule(ConnectionControlRule connectionControlRule) {
        this.connectionControlRule = connectionControlRule;
        Loggers.CONTROL.info("Connection control rule updated to ->" + (this.connectionControlRule == null ? null : JacksonUtils.toJson((Object)this.connectionControlRule)));
        Loggers.CONTROL.warn("Connection control updated, But connection control manager is no limit implementation.");
    }

    public ConnectionCheckResponse check(ConnectionCheckRequest connectionCheckRequest) {
        ConnectionCheckResponse connectionCheckResponse = new ConnectionCheckResponse();
        connectionCheckResponse.setSuccess(true);
        connectionCheckResponse.setCode(200);
        int totalCountLimit = this.connectionControlRule.getCountLimit();
        Map<String, Integer> metricsTotalCount = this.metricsCollectorList.stream().collect(Collectors.toMap(ConnectionMetricsCollector::getName, ConnectionMetricsCollector::getTotalCount));
        int totalCount = metricsTotalCount.values().stream().mapToInt(Integer::intValue).sum();
        if (totalCount >= totalCountLimit) {
            connectionCheckResponse.setSuccess(false);
            connectionCheckResponse.setCode(300);
        }
        return connectionCheckResponse;
    }
}

