/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.impl.persistence.handler;

import com.alibaba.nacos.plugin.auth.impl.persistence.handler.PageHandlerAdapter;
import com.alibaba.nacos.plugin.auth.impl.persistence.handler.support.DefaultPageHandlerAdapter;
import com.alibaba.nacos.plugin.auth.impl.persistence.handler.support.DerbyPageHandlerAdapter;
import com.alibaba.nacos.plugin.auth.impl.persistence.handler.support.MysqlPageHandlerAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class PageHandlerAdapterFactory {
    private final List<PageHandlerAdapter> handlerAdapters;
    private final Map<String, PageHandlerAdapter> handlerAdapterMap;

    public List<PageHandlerAdapter> getHandlerAdapters() {
        return this.handlerAdapters;
    }

    public Map<String, PageHandlerAdapter> getHandlerAdapterMap() {
        return this.handlerAdapterMap;
    }

    private PageHandlerAdapterFactory() {
        ArrayList handlerAdapters = new ArrayList(3);
        HashMap handlerAdapterMap = new HashMap(3);
        Consumer<PageHandlerAdapter> addHandlerAdapter = handlerAdapter -> {
            handlerAdapters.add(handlerAdapter);
            handlerAdapterMap.put(handlerAdapter.getClass().getName(), handlerAdapter);
        };
        addHandlerAdapter.accept(new MysqlPageHandlerAdapter());
        addHandlerAdapter.accept(new DerbyPageHandlerAdapter());
        addHandlerAdapter.accept(new DefaultPageHandlerAdapter());
        this.handlerAdapters = Collections.unmodifiableList(handlerAdapters);
        this.handlerAdapterMap = Collections.unmodifiableMap(handlerAdapterMap);
    }

    public static PageHandlerAdapterFactory getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private static final class InstanceHolder {
        static final PageHandlerAdapterFactory INSTANCE = new PageHandlerAdapterFactory();

        private InstanceHolder() {
        }
    }
}

