package org.immutables.value.processor.meta;

import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link AttributeBuilderReflection}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code ImmutableAttributeBuilderReflection.of()}.
 */
@Generated(from = "AttributeBuilderReflection", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
final class ImmutableAttributeBuilderReflection
    extends AttributeBuilderReflection {
  private final ValueAttribute valueAttribute;

  private ImmutableAttributeBuilderReflection(ValueAttribute valueAttribute) {
    this.valueAttribute = Objects.requireNonNull(valueAttribute, "valueAttribute");
  }

  private ImmutableAttributeBuilderReflection(
      ImmutableAttributeBuilderReflection original,
      ValueAttribute valueAttribute) {
    this.valueAttribute = valueAttribute;
  }

  /**
   * @return The value of the {@code valueAttribute} attribute
   */
  @Override
  ValueAttribute valueAttribute() {
    return valueAttribute;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AttributeBuilderReflection#valueAttribute() valueAttribute} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for valueAttribute
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAttributeBuilderReflection withValueAttribute(ValueAttribute value) {
    if (this.valueAttribute == value) return this;
    ValueAttribute newValue = Objects.requireNonNull(value, "valueAttribute");
    return new ImmutableAttributeBuilderReflection(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAttributeBuilderReflection} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAttributeBuilderReflection
        && equalTo((ImmutableAttributeBuilderReflection) another);
  }

  private boolean equalTo(ImmutableAttributeBuilderReflection another) {
    return valueAttribute.equals(another.valueAttribute);
  }

  /**
   * Computes a hash code from attributes: {@code valueAttribute}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + valueAttribute.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AttributeBuilderReflection} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("AttributeBuilderReflection")
        .omitNullValues()
        .add("valueAttribute", valueAttribute)
        .toString();
  }

  private transient volatile long lazyInitBitmap;

  private static final long STRATEGIES_LAZY_INIT_BIT = 0x1L;

  private transient List<AttributeBuilderReflection.Strategy> strategies;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link AttributeBuilderReflection#getStrategies() strategies} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code strategies} attribute
   */
  @Override
  protected List<AttributeBuilderReflection.Strategy> getStrategies() {
    if ((lazyInitBitmap & STRATEGIES_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & STRATEGIES_LAZY_INIT_BIT) == 0) {
          this.strategies = Objects.requireNonNull(super.getStrategies(), "strategies");
          lazyInitBitmap |= STRATEGIES_LAZY_INIT_BIT;
        }
      }
    }
    return strategies;
  }

  private static final long IS_ATTRIBUTE_BUILDER_LAZY_INIT_BIT = 0x2L;

  private transient boolean isAttributeBuilder;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link AttributeBuilderReflection#isAttributeBuilder() isAttributeBuilder} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code isAttributeBuilder} attribute
   */
  @Override
  boolean isAttributeBuilder() {
    if ((lazyInitBitmap & IS_ATTRIBUTE_BUILDER_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & IS_ATTRIBUTE_BUILDER_LAZY_INIT_BIT) == 0) {
          this.isAttributeBuilder = super.isAttributeBuilder();
          lazyInitBitmap |= IS_ATTRIBUTE_BUILDER_LAZY_INIT_BIT;
        }
      }
    }
    return isAttributeBuilder;
  }

  private static final long ATTRIBUTE_BUILDER_DESCRIPTOR_LAZY_INIT_BIT = 0x4L;

  private transient AttributeBuilderDescriptor attributeBuilderDescriptor;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link AttributeBuilderReflection#getAttributeBuilderDescriptor() attributeBuilderDescriptor} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code attributeBuilderDescriptor} attribute
   */
  @Override
  AttributeBuilderDescriptor getAttributeBuilderDescriptor() {
    if ((lazyInitBitmap & ATTRIBUTE_BUILDER_DESCRIPTOR_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & ATTRIBUTE_BUILDER_DESCRIPTOR_LAZY_INIT_BIT) == 0) {
          this.attributeBuilderDescriptor = Objects.requireNonNull(super.getAttributeBuilderDescriptor(), "attributeBuilderDescriptor");
          lazyInitBitmap |= ATTRIBUTE_BUILDER_DESCRIPTOR_LAZY_INIT_BIT;
        }
      }
    }
    return attributeBuilderDescriptor;
  }

  private static final long REFLECTION_STRATEGY_LAZY_INIT_BIT = 0x8L;

  private transient AttributeBuilderReflection.Strategy reflectionStrategy;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link AttributeBuilderReflection#getReflectionStrategy() reflectionStrategy} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code reflectionStrategy} attribute
   */
  @Override
  protected AttributeBuilderReflection.Strategy getReflectionStrategy() {
    if ((lazyInitBitmap & REFLECTION_STRATEGY_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & REFLECTION_STRATEGY_LAZY_INIT_BIT) == 0) {
          this.reflectionStrategy = Objects.requireNonNull(super.getReflectionStrategy(), "reflectionStrategy");
          lazyInitBitmap |= REFLECTION_STRATEGY_LAZY_INIT_BIT;
        }
      }
    }
    return reflectionStrategy;
  }

  /**
   * Construct a new immutable {@code AttributeBuilderReflection} instance.
   * @param valueAttribute The value for the {@code valueAttribute} attribute
   * @return An immutable AttributeBuilderReflection instance
   */
  public static ImmutableAttributeBuilderReflection of(ValueAttribute valueAttribute) {
    return new ImmutableAttributeBuilderReflection(valueAttribute);
  }

  /**
   * Creates an immutable copy of a {@link AttributeBuilderReflection} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable AttributeBuilderReflection instance
   */
  public static ImmutableAttributeBuilderReflection copyOf(AttributeBuilderReflection instance) {
    if (instance instanceof ImmutableAttributeBuilderReflection) {
      return (ImmutableAttributeBuilderReflection) instance;
    }
    return ImmutableAttributeBuilderReflection.of(instance.valueAttribute());
  }
}
