/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.bosh;

import java.io.Reader;
import java.io.StringReader;
import org.igniterealtime.jbosh.AbstractBody;
import org.igniterealtime.jbosh.BOSHClientResponseListener;
import org.igniterealtime.jbosh.BOSHMessageEvent;
import org.igniterealtime.jbosh.BodyQName;
import org.igniterealtime.jbosh.ComposableBody;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.bosh.XMPPBOSHConnection;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.sasl.SASLMechanism;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;

public class BOSHPacketReader
implements BOSHClientResponseListener {
    private XMPPBOSHConnection connection;

    public BOSHPacketReader(XMPPBOSHConnection connection) {
        this.connection = connection;
    }

    public void responseReceived(BOSHMessageEvent event) {
        block13: {
            AbstractBody body = event.getBody();
            if (body != null) {
                try {
                    if (this.connection.sessionID == null) {
                        this.connection.sessionID = body.getAttribute(BodyQName.create((String)"http://jabber.org/protocol/httpbind", (String)"sid"));
                    }
                    if (this.connection.authID == null) {
                        this.connection.authID = body.getAttribute(BodyQName.create((String)"http://jabber.org/protocol/httpbind", (String)"authid"));
                    }
                    XmlPullParser parser = XmlPullParserFactory.newInstance().newPullParser();
                    parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
                    parser.setInput((Reader)new StringReader(body.toXML()));
                    int eventType = parser.getEventType();
                    do {
                        if ((eventType = parser.next()) != 2 || parser.getName().equals("body")) continue;
                        if (parser.getName().equals("message")) {
                            this.connection.processPacket((Packet)PacketParserUtils.parseMessage((XmlPullParser)parser));
                            continue;
                        }
                        if (parser.getName().equals("iq")) {
                            this.connection.processPacket((Packet)PacketParserUtils.parseIQ((XmlPullParser)parser, (XMPPConnection)this.connection));
                            continue;
                        }
                        if (parser.getName().equals("presence")) {
                            this.connection.processPacket((Packet)PacketParserUtils.parsePresence((XmlPullParser)parser));
                            continue;
                        }
                        if (parser.getName().equals("challenge")) {
                            String challengeData = parser.nextText();
                            this.connection.getSASLAuthentication().challengeReceived(challengeData);
                            this.connection.processPacket((Packet)new SASLMechanism.Challenge(challengeData));
                            continue;
                        }
                        if (parser.getName().equals("success")) {
                            this.connection.send(ComposableBody.builder().setNamespaceDefinition("xmpp", "urn:xmpp:xbosh").setAttribute(BodyQName.createWithPrefix((String)"urn:xmpp:xbosh", (String)"restart", (String)"xmpp"), "true").setAttribute(BodyQName.create((String)"http://jabber.org/protocol/httpbind", (String)"to"), this.connection.getServiceName()).build());
                            this.connection.getSASLAuthentication().authenticated();
                            this.connection.processPacket((Packet)new SASLMechanism.Success(parser.nextText()));
                            continue;
                        }
                        if (parser.getName().equals("features")) {
                            this.parseFeatures(parser);
                            continue;
                        }
                        if (parser.getName().equals("failure")) {
                            if (!"urn:ietf:params:xml:ns:xmpp-sasl".equals(parser.getNamespace(null))) continue;
                            SASLMechanism.SASLFailure failure = PacketParserUtils.parseSASLFailure((XmlPullParser)parser);
                            this.connection.getSASLAuthentication().authenticationFailed(failure);
                            this.connection.processPacket((Packet)failure);
                            continue;
                        }
                        if (!parser.getName().equals("error")) continue;
                        throw new XMPPException.StreamErrorException(PacketParserUtils.parseStreamError((XmlPullParser)parser));
                    } while (eventType != 1);
                }
                catch (Exception e) {
                    if (!this.connection.isConnected()) break block13;
                    this.connection.notifyConnectionError(e);
                }
            }
        }
    }

    private void parseFeatures(XmlPullParser parser) throws Exception {
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                if (parser.getName().equals("mechanisms")) {
                    this.connection.getSASLAuthentication().setAvailableSASLMethods(PacketParserUtils.parseMechanisms((XmlPullParser)parser));
                    continue;
                }
                if (parser.getName().equals("bind")) {
                    this.connection.serverRequiresBinding();
                    continue;
                }
                if (parser.getName().equals("session")) {
                    this.connection.serverSupportsSession();
                    continue;
                }
                if (!parser.getName().equals("register")) continue;
                this.connection.serverSupportsAccountCreation();
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("features")) continue;
            done = true;
        }
    }
}

