/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.utils;

import java.util.function.Function;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.NoTransactionException;
import org.springframework.transaction.reactive.TransactionSynchronization;
import org.springframework.transaction.reactive.TransactionSynchronizationManager;
import reactor.core.publisher.Mono;

public class TransactionUtils {
    private static final Logger log = LoggerFactory.getLogger(TransactionUtils.class);

    public static Mono<Void> afterCommit(final Mono<Void> task) {
        return TransactionUtils.registerSynchronization(new TransactionSynchronization(){

            @NonNull
            public Mono<Void> afterCommit() {
                return task;
            }
        }, TransactionSynchronization::afterCommit);
    }

    public static Mono<Void> registerSynchronization(TransactionSynchronization synchronization, Function<TransactionSynchronization, Mono<Void>> whenNoTransaction) {
        return TransactionSynchronizationManager.forCurrentTransaction().flatMap(manager -> {
            if (manager.isSynchronizationActive()) {
                try {
                    manager.registerSynchronization(synchronization);
                }
                catch (Throwable err) {
                    log.warn("register TransactionSynchronization [{}] error", (Object)synchronization, (Object)err);
                    return (Mono)whenNoTransaction.apply(synchronization);
                }
                return Mono.empty();
            }
            log.info("transaction is not active,execute TransactionSynchronization [{}] immediately.", (Object)synchronization);
            return (Mono)whenNoTransaction.apply(synchronization);
        }).onErrorResume(NoTransactionException.class, err -> (Mono)whenNoTransaction.apply(synchronization));
    }
}

