/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.query;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.hswebframework.ezorm.core.Conditional;
import org.hswebframework.ezorm.core.MethodReferenceConverter;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.ezorm.rdb.mapping.defaults.record.Record;
import org.hswebframework.ezorm.rdb.operator.dml.query.SortOrder;
import org.hswebframework.web.api.crud.entity.PagerResult;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.crud.query.JoinConditionalSpec;
import org.hswebframework.web.crud.query.QueryAnalyzer;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface QueryHelper {
    public QueryAnalyzer analysis(String var1);

    public <T> NativeQuerySpec<T> select(String var1, Supplier<T> var2, Object ... var3);

    public NativeQuerySpec<Record> select(String var1, Object ... var2);

    public <R> SelectColumnMapperSpec<R> select(Class<R> var1);

    public <R> SelectSpec<R> select(Class<R> var1, Consumer<ColumnMapperSpec<R, ?>> var2);

    public static <T, ID, R> Flux<T> combineOneToMany(Flux<T> source, Getter<T, @NotNull ID> idMapper, ReactiveQuery<R> fetcher, Getter<R, @NotNull ID> mainIdGetter, Setter<T, List<R>> setter) {
        return QueryHelper.combineOneToMany(source, idMapper, (Set<ID> list) -> ((ReactiveQuery)fetcher.in(MethodReferenceConverter.convertToColumn((Object)mainIdGetter), (Collection)list)).fetch(), mainIdGetter, setter);
    }

    public static <T, ID, R> Flux<T> combineOneToMany(Flux<T> source, Getter<T, @NotNull ID> idMapper, Function<Set<ID>, Flux<R>> fetcher, Getter<R, @NotNull ID> mainIdGetter, Setter<T, List<R>> setter) {
        return source.buffer(200).concatMap(buffer -> {
            Map mapping = buffer.stream().collect(Collectors.toMap(idMapper, Function.identity(), (a, b) -> b));
            return ((Flux)fetcher.apply(mapping.keySet())).collect(Collectors.groupingBy(mainIdGetter)).flatMapIterable(Map::entrySet).doOnNext(e -> {
                Object main = mapping.get(e.getKey());
                if (main != null) {
                    setter.accept(main, e.getValue());
                }
            }).thenMany((Publisher)Flux.fromIterable((Iterable)buffer));
        });
    }

    public static <S, T> Mono<PagerResult<T>> transformPageResult(Mono<PagerResult<S>> source, Function<List<S>, Mono<List<T>>> transfer) {
        return source.flatMap(result -> {
            if (result.getTotal() > 0) {
                return ((Mono)transfer.apply(result.getData())).map(newDataList -> {
                    PagerResult pagerResult = PagerResult.of((int)result.getTotal(), (List)newDataList);
                    pagerResult.setPageIndex(result.getPageIndex());
                    pagerResult.setPageSize(result.getPageSize());
                    return pagerResult;
                });
            }
            return Mono.just((Object)result);
        });
    }

    public static <T> Mono<PagerResult<T>> queryPager(QueryParamEntity param, Supplier<ReactiveQuery<T>> query) {
        return QueryHelper.queryPager(param, query, Function.identity());
    }

    public static <T, R> Mono<PagerResult<R>> queryPager(QueryParamEntity param, Supplier<ReactiveQuery<T>> query, Function<T, R> mapper) {
        if (param.getTotal() != null) {
            return ((ReactiveQuery)query.get().setParam(param.rePaging(param.getTotal().intValue()))).fetch().map(mapper).collectList().map(list -> PagerResult.of((int)param.getTotal(), (List)list, (QueryParam)param));
        }
        if (param.isParallelPager()) {
            return Mono.zip((Mono)((ReactiveQuery)query.get().setParam((QueryParam)param.clone())).count(), (Mono)((ReactiveQuery)query.get().setParam((QueryParam)param.clone())).fetch().map(mapper).collectList(), (total, data) -> PagerResult.of((int)total, (List)data, (QueryParam)param));
        }
        return ((ReactiveQuery)query.get().setParam((QueryParam)param.clone())).count().flatMap(total -> {
            if (total == 0) {
                return Mono.just((Object)PagerResult.of((int)0, new ArrayList(), (QueryParam)param));
            }
            QueryParamEntity rePagingQuery = (QueryParamEntity)param.clone().rePaging(total.intValue());
            return ((ReactiveQuery)((ReactiveQuery)query.get()).setParam((QueryParam)rePagingQuery)).fetch().map(mapper).collectList().map(list -> PagerResult.of((int)total, (List)list, (QueryParam)rePagingQuery));
        });
    }

    public static interface Setter<S, V>
    extends BiConsumer<S, V>,
    Serializable {
    }

    public static interface Getter<S, V>
    extends Function<S, V>,
    Serializable {
    }

    public static interface ColumnMapperSpec<R, Self extends ColumnMapperSpec<R, Self>> {
        public Self all(Class<?> var1);

        public <V> Self all(Class<?> var1, Setter<R, V> var2);

        public Self all(String var1);

        public <V> Self all(String var1, Setter<R, V> var2);

        public <S, V> Self as(Getter<S, V> var1, Setter<R, V> var2);

        public <S, V> Self as(Getter<S, V> var1, String var2);

        public <V> Self as(String var1, Setter<R, V> var2);

        public Self as(String var1, String var2);
    }

    public static interface SelectColumnMapperSpec<R>
    extends ColumnMapperSpec<R, SelectColumnMapperSpec<R>>,
    SelectSpec<R> {
    }

    public static interface ExecuteSpec<R> {
        public Mono<Integer> count();

        public Flux<R> fetch();

        public Mono<PagerResult<R>> fetchPaged();

        default public <T> Mono<PagerResult<T>> fetchPaged(Function<List<R>, Mono<List<T>>> transfer) {
            return QueryHelper.transformPageResult(this.fetchPaged(), transfer);
        }

        public Mono<PagerResult<R>> fetchPaged(int var1, int var2);

        default public <T> Mono<PagerResult<T>> fetchPaged(int pageIndex, int pageSize, Function<List<R>, Mono<List<T>>> transfer) {
            return QueryHelper.transformPageResult(this.fetchPaged(pageIndex, pageSize), transfer);
        }
    }

    public static interface JoinSpec<R>
    extends WhereSpec<R>,
    SortSpec<R> {
        public <T> JoinSpec<R> leftJoin(Class<T> var1, Consumer<JoinConditionalSpec<?>> var2);

        public <T> JoinSpec<R> rightJoin(Class<T> var1, Consumer<JoinConditionalSpec<?>> var2);

        public <T> JoinSpec<R> innerJoin(Class<T> var1, Consumer<JoinConditionalSpec<?>> var2);

        public <T> JoinSpec<R> fullJoin(Class<T> var1, Consumer<JoinConditionalSpec<?>> var2);
    }

    public static interface FromSpec<R>
    extends JoinSpec<R>,
    SortSpec<R> {
    }

    public static interface SortSpec<R>
    extends ExecuteSpec<R> {
        default public SortSpec<R> orderByAsc(String column) {
            return this.orderBy(column, SortOrder.Order.asc);
        }

        default public SortSpec<R> orderByDesc(String column) {
            return this.orderBy(column, SortOrder.Order.desc);
        }

        public SortSpec<R> orderBy(String var1, SortOrder.Order var2);

        default public <S> SortSpec<R> orderByAsc(Getter<S, ?> column) {
            return this.orderBy(column, SortOrder.Order.asc);
        }

        default public <S> SortSpec<R> orderByDesc(Getter<S, ?> column) {
            return this.orderBy(column, SortOrder.Order.desc);
        }

        public <S> SortSpec<R> orderBy(Getter<S, ?> var1, SortOrder.Order var2);
    }

    public static interface WhereSpec<R>
    extends ExecuteSpec<R> {
        public SortSpec<R> where(QueryParamEntity var1);

        public SortSpec<R> where(Consumer<Conditional<?>> var1);
    }

    public static interface SelectSpec<R> {
        public <From> FromSpec<R> from(Class<From> var1);
    }

    public static interface NativeQuerySpec<T>
    extends ExecuteSpec<T> {
        public NativeQuerySpec<T> logger(Logger var1);

        default public ExecuteSpec<T> where(Consumer<Query<?, QueryParamEntity>> dsl) {
            Query query = QueryParamEntity.newQuery().noPaging();
            dsl.accept(query);
            return this.where((QueryParamEntity)query.getParam());
        }

        public ExecuteSpec<T> where(QueryParamEntity var1);
    }
}

