/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.events;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.hswebframework.ezorm.rdb.events.EventContext;
import org.hswebframework.ezorm.rdb.events.EventListener;
import org.hswebframework.ezorm.rdb.events.EventType;
import org.hswebframework.ezorm.rdb.mapping.events.MappingContextKeys;
import org.hswebframework.ezorm.rdb.mapping.events.MappingEventTypes;
import org.hswebframework.web.api.crud.entity.RecordCreationEntity;
import org.hswebframework.web.api.crud.entity.RecordModifierEntity;
import org.hswebframework.web.authorization.Authentication;
import org.springframework.core.Ordered;
import org.springframework.util.ObjectUtils;

public class CreatorEventListener
implements EventListener,
Ordered {
    public String getId() {
        return "creator-listener";
    }

    public String getName() {
        return "\u521b\u5efa\u8005\u76d1\u542c\u5668";
    }

    public void onEvent(EventType type, EventContext context) {
        Optional resultHolder = context.get(MappingContextKeys.reactiveResultHolder);
        if (type == MappingEventTypes.insert_before || type == MappingEventTypes.save_before || type == MappingEventTypes.update_before) {
            if (resultHolder.isPresent()) {
                resultHolder.ifPresent(holder -> holder.before(Authentication.currentReactive().doOnNext(auth -> this.doApplyCreator(type, context, (Authentication)auth)).then()));
            } else {
                Authentication.current().ifPresent(auth -> this.doApplyCreator(type, context, (Authentication)auth));
            }
        }
    }

    protected void doApplyCreator(EventType type, EventContext context, Authentication auth) {
        Object instance = context.get(MappingContextKeys.instance).orElse(null);
        if (instance != null) {
            if (instance instanceof Collection) {
                this.applyCreator(auth, context, (Collection<?>)instance, type != MappingEventTypes.update_before);
            } else {
                this.applyCreator(auth, context, (Object)instance, type != MappingEventTypes.update_before);
            }
        }
        context.get(MappingContextKeys.updateColumnInstance).ifPresent(map -> this.applyCreator(auth, context, map, type != MappingEventTypes.update_before));
    }

    public void applyCreator(Authentication auth, EventContext context, Object entity, boolean updateCreator) {
        Map map;
        RecordCreationEntity e;
        long now = System.currentTimeMillis();
        if (updateCreator) {
            if (entity instanceof RecordCreationEntity) {
                e = (RecordCreationEntity)entity;
                if (ObjectUtils.isEmpty((Object)e.getCreatorId())) {
                    e.setCreatorId(auth.getUser().getId());
                    e.setCreatorName(auth.getUser().getName());
                }
                if (e.getCreateTime() == null) {
                    e.setCreateTime(Long.valueOf(now));
                }
            } else if (entity instanceof Map) {
                map = (Map)entity;
                map.putIfAbsent("creator_id", auth.getUser().getId());
                map.putIfAbsent("creator_name", auth.getUser().getName());
                map.putIfAbsent("create_time", now);
            }
        }
        if (entity instanceof RecordModifierEntity) {
            e = (RecordModifierEntity)entity;
            if (ObjectUtils.isEmpty((Object)e.getModifierId())) {
                e.setModifierId(auth.getUser().getId());
                e.setModifierName(auth.getUser().getName());
            }
            if (e.getModifyTime() == null) {
                e.setModifyTime(Long.valueOf(now));
            }
        } else if (entity instanceof Map) {
            map = (Map)entity;
            map.putIfAbsent("modifier_id", auth.getUser().getId());
            map.putIfAbsent("modifier_name", auth.getUser().getName());
            map.putIfAbsent("modify_time", now);
        }
    }

    public void applyCreator(Authentication auth, EventContext context, Collection<?> entities, boolean updateCreator) {
        for (Object entity : entities) {
            this.applyCreator(auth, context, entity, updateCreator);
        }
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

