/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.entity.factory;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.hswebframework.web.api.crud.entity.EntityFactory;
import org.hswebframework.web.bean.BeanFactory;
import org.hswebframework.web.bean.FastBeanCopier;
import org.hswebframework.web.crud.entity.factory.DefaultMapperFactory;
import org.hswebframework.web.crud.entity.factory.DefaultPropertyCopier;
import org.hswebframework.web.crud.entity.factory.PropertyCopier;
import org.hswebframework.web.exception.NotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

public class MapperEntityFactory
implements EntityFactory,
BeanFactory {
    private final Map<Class<?>, Mapper> realTypeMapper = new ConcurrentHashMap();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, PropertyCopier> copierCache = new ConcurrentHashMap<String, PropertyCopier>();
    private static final DefaultMapperFactory DEFAULT_MAPPER_FACTORY = clazz -> {
        String simpleClassName = clazz.getPackage().getName().concat(".Simple").concat(clazz.getSimpleName());
        try {
            return MapperEntityFactory.defaultMapper(ClassUtils.forName((String)simpleClassName, null));
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    };
    private static final DefaultPropertyCopier DEFAULT_PROPERTY_COPIER = (x$0, x$1) -> FastBeanCopier.copy((Object)x$0, (Object)x$1, (String[])new String[0]);
    private DefaultMapperFactory defaultMapperFactory = DEFAULT_MAPPER_FACTORY;
    private DefaultPropertyCopier defaultPropertyCopier = DEFAULT_PROPERTY_COPIER;
    static final Mapper NON_MAPPER = new Mapper(null, null);

    public MapperEntityFactory() {
    }

    public MapperEntityFactory(Map<Class<?>, Mapper<?>> realTypeMapper) {
        this.realTypeMapper.putAll(realTypeMapper);
    }

    public <T> MapperEntityFactory addMapping(Class<T> target, Supplier<? extends T> mapper) {
        this.realTypeMapper.put(target, new Mapper<T>(mapper.get().getClass(), mapper));
        return this;
    }

    public <T> MapperEntityFactory addMappingIfAbsent(Class<T> target, Supplier<? extends T> mapper) {
        this.realTypeMapper.putIfAbsent(target, new Mapper<T>(mapper.get().getClass(), mapper));
        return this;
    }

    public <T> MapperEntityFactory addMapping(Class<T> target, Mapper<? extends T> mapper) {
        this.realTypeMapper.put(target, mapper);
        return this;
    }

    public <T> MapperEntityFactory addMappingIfAbsent(Class<T> target, Mapper<? extends T> mapper) {
        this.realTypeMapper.putIfAbsent(target, mapper);
        return this;
    }

    public <S, T> MapperEntityFactory addCopier(PropertyCopier<S, T> copier) {
        Class source = org.hswebframework.utils.ClassUtils.getGenericType(copier.getClass(), (int)0);
        Class target = org.hswebframework.utils.ClassUtils.getGenericType(copier.getClass(), (int)1);
        if (source == null || source == Object.class) {
            throw new UnsupportedOperationException("generic type " + source + " not support");
        }
        if (target == null || target == Object.class) {
            throw new UnsupportedOperationException("generic type " + target + " not support");
        }
        this.addCopier(source, target, copier);
        return this;
    }

    public <S, T> MapperEntityFactory addCopier(Class<S> source, Class<T> target, PropertyCopier<S, T> copier) {
        this.copierCache.put(this.getCopierCacheKey(source, target), copier);
        return this;
    }

    private String getCopierCacheKey(Class<?> source, Class<?> target) {
        return source.getName().concat("->").concat(target.getName());
    }

    public <S, T> T copyProperties(S source, T target) {
        Objects.requireNonNull(source);
        Objects.requireNonNull(target);
        try {
            PropertyCopier copier = this.copierCache.get(this.getCopierCacheKey(source.getClass(), target.getClass()));
            if (null != copier) {
                return copier.copyProperties(source, target);
            }
            return this.defaultPropertyCopier.copyProperties(source, target);
        }
        catch (Throwable e) {
            this.logger.warn("copy properties error", e);
            return target;
        }
    }

    protected <T> Mapper<T> createMapper(Class<T> beanClass) {
        Mapper mapper = null;
        Class<Object> realType = null;
        ServiceLoader<T> serviceLoader = ServiceLoader.load(beanClass, this.getClass().getClassLoader());
        Iterator<T> iterator = serviceLoader.iterator();
        if (iterator.hasNext()) {
            realType = iterator.next().getClass();
        }
        if (realType == null) {
            if (!Modifier.isInterface(beanClass.getModifiers()) && !Modifier.isAbstract(beanClass.getModifiers())) {
                realType = beanClass;
            } else {
                mapper = (Mapper)this.defaultMapperFactory.apply(beanClass);
            }
        }
        if (mapper == null && realType != null) {
            if (this.logger.isDebugEnabled() && realType != beanClass) {
                this.logger.debug("use instance {} for {}", realType, beanClass);
            }
            mapper = new Mapper(realType, new DefaultInstanceGetter(realType));
        }
        return mapper == null ? NON_MAPPER : mapper;
    }

    public <T> T newInstance(Class<T> beanClass) {
        return this.newInstance(beanClass, (Class)null);
    }

    public <T> T newInstance(Class<T> entityClass, Supplier<? extends T> defaultFactory) {
        if (entityClass == null) {
            return null;
        }
        Mapper mapper = this.realTypeMapper.computeIfAbsent(entityClass, this::createMapper);
        if (mapper != null && mapper != NON_MAPPER) {
            return mapper.getInstanceGetter().get();
        }
        return defaultFactory.get();
    }

    public <T> T newInstance(Class<T> beanClass, Class<? extends T> defaultClass) {
        if (beanClass == null) {
            return null;
        }
        Mapper mapper = this.realTypeMapper.computeIfAbsent(beanClass, this::createMapper);
        if (mapper != null && mapper != NON_MAPPER) {
            return mapper.getInstanceGetter().get();
        }
        if (defaultClass != null) {
            return this.newInstance(defaultClass);
        }
        if (Map.class == beanClass) {
            return (T)new HashMap();
        }
        if (List.class == beanClass) {
            return (T)new ArrayList();
        }
        if (Set.class == beanClass) {
            return (T)new HashSet();
        }
        throw new NotFoundException("error.cant_create_instance", new Object[]{beanClass});
    }

    public <T> Class<T> getInstanceType(Class<T> beanClass, boolean autoRegister) {
        if (beanClass == null || beanClass.isPrimitive() || beanClass.isArray() || beanClass.isEnum()) {
            return null;
        }
        Mapper mapper = this.realTypeMapper.computeIfAbsent(beanClass, clazz -> autoRegister ? this.createMapper((Class)clazz) : null);
        if (null != mapper && mapper != NON_MAPPER) {
            return mapper.getTarget();
        }
        return Modifier.isAbstract(beanClass.getModifiers()) || Modifier.isInterface(beanClass.getModifiers()) ? null : beanClass;
    }

    public void setDefaultMapperFactory(DefaultMapperFactory defaultMapperFactory) {
        Objects.requireNonNull(defaultMapperFactory);
        this.defaultMapperFactory = defaultMapperFactory;
    }

    public void setDefaultPropertyCopier(DefaultPropertyCopier defaultPropertyCopier) {
        this.defaultPropertyCopier = defaultPropertyCopier;
    }

    public static <T> Mapper<T> defaultMapper(Class<T> target) {
        return new Mapper<T>(target, MapperEntityFactory.defaultInstanceGetter(target));
    }

    public static <T> Supplier<T> defaultInstanceGetter(Class<T> clazz) {
        return new DefaultInstanceGetter<T>(clazz);
    }

    static class DefaultInstanceGetter<T>
    implements Supplier<T> {
        final Constructor<T> constructor;

        public DefaultInstanceGetter(Class<T> type) {
            this.constructor = type.getConstructor(new Class[0]);
        }

        @Override
        public T get() {
            return this.constructor.newInstance(new Object[0]);
        }
    }

    public static class Mapper<T> {
        final Class<T> target;
        final Supplier<T> instanceGetter;

        public Mapper(Class<T> target, Supplier<T> instanceGetter) {
            this.target = target;
            this.instanceGetter = instanceGetter;
        }

        public Class<T> getTarget() {
            return this.target;
        }

        public Supplier<T> getInstanceGetter() {
            return this.instanceGetter;
        }
    }
}

