/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.configuration;

import java.util.Arrays;
import java.util.HashSet;
import org.hswebframework.ezorm.rdb.metadata.RDBDatabaseMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBSchemaMetadata;
import org.hswebframework.ezorm.rdb.metadata.dialect.Dialect;
import org.hswebframework.ezorm.rdb.supports.h2.H2SchemaMetadata;
import org.hswebframework.ezorm.rdb.supports.mssql.SqlServerSchemaMetadata;
import org.hswebframework.ezorm.rdb.supports.mysql.MysqlSchemaMetadata;
import org.hswebframework.ezorm.rdb.supports.oracle.OracleSchemaMetadata;
import org.hswebframework.ezorm.rdb.supports.postgres.PostgresqlSchemaMetadata;
import org.hswebframework.web.crud.configuration.DialectProvider;
import org.hswebframework.web.crud.configuration.DialectProviders;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="easyorm")
public class EasyormProperties {
    private String defaultSchema = "PUBLIC";
    private String[] schemas = new String[0];
    private boolean autoDdl = true;
    private boolean allowAlter = false;
    private boolean allowTypeAlter = true;
    private DialectProvider dialect = DialectEnum.h2;
    @Deprecated
    private Class<? extends Dialect> dialectType;
    @Deprecated
    private Class<? extends RDBSchemaMetadata> schemaType;

    public void setDialect(String dialect) {
        this.dialect = DialectProviders.lookup(dialect);
    }

    public RDBDatabaseMetadata createDatabaseMetadata() {
        RDBDatabaseMetadata metadata = new RDBDatabaseMetadata(this.createDialect());
        HashSet<String> schemaSet = new HashSet<String>(Arrays.asList(this.schemas));
        if (this.defaultSchema != null) {
            schemaSet.add(this.defaultSchema);
        }
        schemaSet.stream().map(this::createSchema).forEach(arg_0 -> ((RDBDatabaseMetadata)metadata).addSchema(arg_0));
        metadata.getSchema(this.defaultSchema).ifPresent(arg_0 -> ((RDBDatabaseMetadata)metadata).setCurrentSchema(arg_0));
        return metadata;
    }

    public RDBSchemaMetadata createSchema(String name) {
        return this.dialect.createSchema(name);
    }

    public Dialect createDialect() {
        return this.dialect.getDialect();
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public String[] getSchemas() {
        return this.schemas;
    }

    public boolean isAutoDdl() {
        return this.autoDdl;
    }

    public boolean isAllowAlter() {
        return this.allowAlter;
    }

    public boolean isAllowTypeAlter() {
        return this.allowTypeAlter;
    }

    public DialectProvider getDialect() {
        return this.dialect;
    }

    @Deprecated
    public Class<? extends Dialect> getDialectType() {
        return this.dialectType;
    }

    @Deprecated
    public Class<? extends RDBSchemaMetadata> getSchemaType() {
        return this.schemaType;
    }

    public void setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
    }

    public void setSchemas(String[] schemas) {
        this.schemas = schemas;
    }

    public void setAutoDdl(boolean autoDdl) {
        this.autoDdl = autoDdl;
    }

    public void setAllowAlter(boolean allowAlter) {
        this.allowAlter = allowAlter;
    }

    public void setAllowTypeAlter(boolean allowTypeAlter) {
        this.allowTypeAlter = allowTypeAlter;
    }

    @Deprecated
    public void setDialectType(Class<? extends Dialect> dialectType) {
        this.dialectType = dialectType;
    }

    @Deprecated
    public void setSchemaType(Class<? extends RDBSchemaMetadata> schemaType) {
        this.schemaType = schemaType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EasyormProperties)) {
            return false;
        }
        EasyormProperties other = (EasyormProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAutoDdl() != other.isAutoDdl()) {
            return false;
        }
        if (this.isAllowAlter() != other.isAllowAlter()) {
            return false;
        }
        if (this.isAllowTypeAlter() != other.isAllowTypeAlter()) {
            return false;
        }
        String this$defaultSchema = this.getDefaultSchema();
        String other$defaultSchema = other.getDefaultSchema();
        if (this$defaultSchema == null ? other$defaultSchema != null : !this$defaultSchema.equals(other$defaultSchema)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getSchemas(), other.getSchemas())) {
            return false;
        }
        DialectProvider this$dialect = this.getDialect();
        DialectProvider other$dialect = other.getDialect();
        if (this$dialect == null ? other$dialect != null : !this$dialect.equals(other$dialect)) {
            return false;
        }
        Class<? extends Dialect> this$dialectType = this.getDialectType();
        Class<? extends Dialect> other$dialectType = other.getDialectType();
        if (this$dialectType == null ? other$dialectType != null : !this$dialectType.equals(other$dialectType)) {
            return false;
        }
        Class<? extends RDBSchemaMetadata> this$schemaType = this.getSchemaType();
        Class<? extends RDBSchemaMetadata> other$schemaType = other.getSchemaType();
        return !(this$schemaType == null ? other$schemaType != null : !this$schemaType.equals(other$schemaType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EasyormProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAutoDdl() ? 79 : 97);
        result = result * 59 + (this.isAllowAlter() ? 79 : 97);
        result = result * 59 + (this.isAllowTypeAlter() ? 79 : 97);
        String $defaultSchema = this.getDefaultSchema();
        result = result * 59 + ($defaultSchema == null ? 43 : $defaultSchema.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getSchemas());
        DialectProvider $dialect = this.getDialect();
        result = result * 59 + ($dialect == null ? 43 : $dialect.hashCode());
        Class<? extends Dialect> $dialectType = this.getDialectType();
        result = result * 59 + ($dialectType == null ? 43 : $dialectType.hashCode());
        Class<? extends RDBSchemaMetadata> $schemaType = this.getSchemaType();
        result = result * 59 + ($schemaType == null ? 43 : $schemaType.hashCode());
        return result;
    }

    public String toString() {
        return "EasyormProperties(defaultSchema=" + this.getDefaultSchema() + ", schemas=" + Arrays.deepToString(this.getSchemas()) + ", autoDdl=" + this.isAutoDdl() + ", allowAlter=" + this.isAllowAlter() + ", allowTypeAlter=" + this.isAllowTypeAlter() + ", dialect=" + this.getDialect() + ", dialectType=" + this.getDialectType() + ", schemaType=" + this.getSchemaType() + ")";
    }

    public static enum DialectEnum implements DialectProvider
    {
        mysql(Dialect.MYSQL, "?"){

            @Override
            public RDBSchemaMetadata createSchema(String name) {
                return new MysqlSchemaMetadata(name);
            }
        }
        ,
        mssql(Dialect.MSSQL, "@arg"){

            @Override
            public RDBSchemaMetadata createSchema(String name) {
                return new SqlServerSchemaMetadata(name);
            }
        }
        ,
        oracle(Dialect.ORACLE, "?"){

            @Override
            public RDBSchemaMetadata createSchema(String name) {
                return new OracleSchemaMetadata(name);
            }

            @Override
            public String getValidationSql() {
                return "select 1 from dual";
            }
        }
        ,
        postgres(Dialect.POSTGRES, "$"){

            @Override
            public RDBSchemaMetadata createSchema(String name) {
                return new PostgresqlSchemaMetadata(name);
            }
        }
        ,
        h2(Dialect.H2, "$"){

            @Override
            public RDBSchemaMetadata createSchema(String name) {
                return new H2SchemaMetadata(name);
            }
        };

        private final Dialect dialect;
        private final String bindSymbol;

        @Override
        public abstract RDBSchemaMetadata createSchema(String var1);

        @Override
        public Dialect getDialect() {
            return this.dialect;
        }

        @Override
        public String getBindSymbol() {
            return this.bindSymbol;
        }

        private DialectEnum(Dialect dialect, String bindSymbol) {
            this.dialect = dialect;
            this.bindSymbol = bindSymbol;
        }
    }
}

