/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.service;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.rdb.mapping.ReactiveDelete;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.ezorm.rdb.mapping.defaults.SaveResult;
import org.hswebframework.utils.RandomUtil;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.api.crud.entity.TreeSortSupportEntity;
import org.hswebframework.web.api.crud.entity.TreeSupportEntity;
import org.hswebframework.web.crud.service.ReactiveCrudService;
import org.hswebframework.web.id.IDGenerator;
import org.reactivestreams.Publisher;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ReactiveTreeSortEntityService<E extends TreeSortSupportEntity<K>, K>
extends ReactiveCrudService<E, K> {
    default public Mono<List<E>> queryResultToTree(Mono<? extends QueryParamEntity> paramEntity) {
        return paramEntity.flatMap(this::queryResultToTree);
    }

    default public Mono<List<E>> queryResultToTree(QueryParamEntity paramEntity) {
        return this.query(paramEntity).collectList().map(list -> TreeSupportEntity.list2tree((Collection)list, this::setChildren, this::createRootNodePredicate));
    }

    default public Mono<List<E>> queryIncludeChildrenTree(QueryParamEntity paramEntity) {
        return this.queryIncludeChildren(paramEntity).collectList().map(list -> TreeSupportEntity.list2tree((Collection)list, this::setChildren, this::createRootNodePredicate));
    }

    default public Flux<E> queryIncludeChildren(Collection<K> idList) {
        return this.findById(idList).flatMap(e -> ((ReactiveQuery)((ReactiveQuery)this.createQuery().where()).like$("path", (Object)e.getPath())).fetch());
    }

    default public Flux<E> queryIncludeChildren(QueryParamEntity queryParam) {
        return this.query(queryParam).flatMap(e -> ((ReactiveQuery)((ReactiveQuery)this.createQuery().where()).like$("path", (Object)e.getPath())).fetch());
    }

    @Override
    default public Mono<Integer> insert(Publisher<E> entityPublisher) {
        return this.insertBatch((Publisher<? extends Collection<E>>)Flux.from(entityPublisher).collectList());
    }

    @Override
    default public Mono<Integer> insertBatch(Publisher<? extends Collection<E>> entityPublisher) {
        return this.getRepository().insertBatch((Publisher)Flux.from(entityPublisher).flatMap(Flux::fromIterable).flatMap(this::applyTreeProperty).flatMap(e -> Flux.fromIterable((Iterable)TreeSupportEntity.expandTree2List((TreeSupportEntity)e, this.getIDGenerator()))).collectList());
    }

    default public Mono<E> applyTreeProperty(E ele) {
        if (StringUtils.hasText((String)ele.getPath()) || StringUtils.isEmpty((Object)ele.getParentId())) {
            return Mono.just(ele);
        }
        return this.checkCyclicDependency(ele.getId(), ele).then(this.findById(ele.getParentId()).doOnNext(parent -> ele.setPath(parent.getPath() + "-" + RandomUtil.randomChar((int)4)))).thenReturn(ele);
    }

    default public Mono<E> checkCyclicDependency(K id, E ele) {
        if (StringUtils.isEmpty(id)) {
            return Mono.empty();
        }
        return this.queryIncludeChildren(Collections.singletonList(id)).doOnNext(e -> {
            if (Objects.equals(ele.getParentId(), e.getId())) {
                throw new IllegalArgumentException("\u4e0d\u80fd\u4fee\u6539\u7236\u8282\u70b9\u4e3a\u81ea\u5df1\u6216\u8005\u81ea\u5df1\u7684\u5b50\u8282\u70b9");
            }
        }).then(Mono.just(ele));
    }

    @Override
    default public Mono<SaveResult> save(Publisher<E> entityPublisher) {
        return this.getRepository().save((Publisher)Flux.from(entityPublisher).flatMap(this::applyTreeProperty).flatMap(e -> Flux.fromIterable((Iterable)TreeSupportEntity.expandTree2List((TreeSupportEntity)e, this.getIDGenerator()))));
    }

    @Override
    default public Mono<Integer> updateById(K id, Mono<E> entityPublisher) {
        return this.save((Publisher<E>)entityPublisher.doOnNext(e -> e.setId(id))).map(SaveResult::getTotal);
    }

    @Override
    default public Mono<Integer> deleteById(Publisher<K> idPublisher) {
        return this.findById(Flux.from(idPublisher)).flatMap(e -> ((ReactiveDelete)((ReactiveDelete)this.createDelete().where()).like$(() -> ((TreeSortSupportEntity)e).getPath())).execute()).collect(Collectors.summingInt(Integer::intValue));
    }

    public IDGenerator<K> getIDGenerator();

    public void setChildren(E var1, List<E> var2);

    default public List<E> getChildren(E entity) {
        return entity.getChildren();
    }

    default public Predicate<E> createRootNodePredicate(TreeSupportEntity.TreeHelper<E, K> helper) {
        return node -> {
            if (this.isRootNode(node)) {
                return true;
            }
            if (!StringUtils.isEmpty((Object)node.getParentId())) {
                return helper.getNode(node.getParentId()) == null;
            }
            return false;
        };
    }

    default public boolean isRootNode(E entity) {
        return StringUtils.isEmpty((Object)entity.getParentId()) || "-1".equals(String.valueOf(entity.getParentId()));
    }
}

