/*
 * Decompiled with CFR 0.152.
 */
package org.hibnet.jsourcemap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.hibnet.jsourcemap.Code;
import org.hibnet.jsourcemap.Mapping;
import org.hibnet.jsourcemap.OriginalPosition;
import org.hibnet.jsourcemap.Position;
import org.hibnet.jsourcemap.SourceMapConsumer;
import org.hibnet.jsourcemap.SourceMapGenerator;
import org.hibnet.jsourcemap.Util;

public class SourceNode {
    private static final Pattern REGEX_NEWLINE = Pattern.compile("(\r?\n)");
    private static final int NEWLINE_CODE = 10;
    List<Object> children = new ArrayList<Object>();
    private Map<String, String> sourceContents = new HashMap<String, String>();
    private Integer line;
    private Integer column;
    private String source;
    private String name;

    public SourceNode() {
    }

    public SourceNode(Integer aLine, Integer aColumn, String aSource, Object aChunks) {
        this(aLine, aColumn, aSource, aChunks, null);
    }

    public SourceNode(Integer aLine, Integer aColumn, String aSource, Object aChunks, String aName) {
        this.line = aLine;
        this.column = aColumn;
        this.source = aSource;
        this.name = aName;
        if (aChunks != null) {
            this.add(aChunks);
        }
    }

    private static String shiftNextLine(List<String> remainingLines) {
        String lineContents = remainingLines.remove(0);
        String newLine = remainingLines.isEmpty() ? "" : remainingLines.remove(0);
        return lineContents + newLine;
    }

    private static void addMappingWithCode(SourceNode node, String aRelativePath, Mapping mapping, String code) {
        if (mapping == null || mapping.source == null) {
            node.add(code);
        } else {
            String source = aRelativePath != null ? Util.join(aRelativePath, mapping.source) : mapping.source;
            node.add(new SourceNode(mapping.original.line, mapping.original.column, source, code, mapping.name));
        }
    }

    public static SourceNode fromStringWithSourceMap(String aGeneratedCode, SourceMapConsumer aSourceMapConsumer, String aRelativePath) {
        SourceNode node = new SourceNode();
        ArrayList<String> remainingLines = new ArrayList<String>(Util.split(aGeneratedCode, REGEX_NEWLINE));
        int[] lastGeneratedLine = new int[]{1};
        int[] lastGeneratedColumn = new int[]{0};
        Mapping[] lastMapping = new Mapping[1];
        aSourceMapConsumer.eachMapping().forEach(mapping -> {
            if (lastMapping[0] != null) {
                if (lastGeneratedLine[0] < mapping.generated.line) {
                    SourceNode.addMappingWithCode(node, aRelativePath, lastMapping[0], SourceNode.shiftNextLine(remainingLines));
                    lastGeneratedLine[0] = lastGeneratedLine[0] + 1;
                    lastGeneratedColumn[0] = 0;
                } else {
                    String nextLine = (String)remainingLines.get(0);
                    String code = Util.substr(nextLine, 0, mapping.generated.column - lastGeneratedColumn[0]);
                    remainingLines.set(0, Util.substr(nextLine, mapping.generated.column - lastGeneratedColumn[0]));
                    lastGeneratedColumn[0] = mapping.generated.column;
                    SourceNode.addMappingWithCode(node, aRelativePath, lastMapping[0], code);
                    lastMapping[0] = mapping;
                    return;
                }
            }
            while (lastGeneratedLine[0] < mapping.generated.line) {
                node.add(SourceNode.shiftNextLine(remainingLines));
                lastGeneratedLine[0] = lastGeneratedLine[0] + 1;
            }
            if (lastGeneratedColumn[0] < mapping.generated.column && !remainingLines.isEmpty()) {
                String nextLine = (String)remainingLines.get(0);
                node.add(Util.substr(nextLine, 0, mapping.generated.column));
                remainingLines.set(0, Util.substr(nextLine, mapping.generated.column));
                lastGeneratedColumn[0] = mapping.generated.column;
            }
            lastMapping[0] = mapping;
        });
        if (remainingLines.size() > 0) {
            if (lastMapping[0] != null) {
                SourceNode.addMappingWithCode(node, aRelativePath, lastMapping[0], SourceNode.shiftNextLine(remainingLines));
            }
            node.add(Util.join(remainingLines, ""));
        }
        aSourceMapConsumer.sources().forEach(sourceFile -> {
            String content = aSourceMapConsumer.sourceContentFor((String)sourceFile);
            if (content != null) {
                if (aRelativePath != null) {
                    sourceFile = Util.join(aRelativePath, sourceFile);
                }
                node.setSourceContent((String)sourceFile, content);
            }
        });
        return node;
    }

    public void add(Object ... aChunk) {
        List l;
        List list = aChunk.length == 1 && aChunk[0] instanceof List ? (l = (List)aChunk[0]) : Arrays.asList(aChunk);
        list.forEach(chunk -> {
            if (chunk instanceof String) {
                this.add((String)chunk);
            } else if (chunk instanceof SourceNode) {
                this.add((SourceNode)chunk);
            } else {
                throw new IllegalArgumentException();
            }
        });
    }

    public void add(String aChunk) {
        this.children.add(aChunk);
    }

    public void add(SourceNode aChunk) {
        this.children.add(aChunk);
    }

    public void prepend(Object ... aChunk) {
        for (int i = aChunk.length - 1; i >= 0; --i) {
            if (aChunk[i] instanceof String) {
                this.prepend((String)aChunk[i]);
                continue;
            }
            if (aChunk[i] instanceof SourceNode) {
                this.prepend((SourceNode)aChunk[i]);
                continue;
            }
            throw new IllegalArgumentException();
        }
    }

    public void prepend(SourceNode aChunk) {
        this.children.add(0, aChunk);
    }

    public void prepend(String aChunk) {
        this.children.add(0, aChunk);
    }

    public void walk(ChuckWalker walker) {
        int len = this.children.size();
        for (int i = 0; i < len; ++i) {
            Object chunk = this.children.get(i);
            if (chunk instanceof SourceNode) {
                ((SourceNode)chunk).walk(walker);
                continue;
            }
            if (((String)chunk).length() == 0) continue;
            walker.walk((String)chunk, new OriginalPosition(this.line, this.column, this.source, this.name));
        }
    }

    public void join(String aSep) {
        int len = this.children.size();
        if (len > 0) {
            int i;
            ArrayList<Object> newChildren = new ArrayList<Object>();
            for (i = 0; i < len - 1; ++i) {
                newChildren.add(this.children.get(i));
                newChildren.add(aSep);
            }
            newChildren.add(this.children.get(i));
            this.children = newChildren;
        }
    }

    public void replaceRight(Pattern aPattern, String aReplacement) {
        Object lastChild = this.children.get(this.children.size() - 1);
        if (lastChild instanceof SourceNode) {
            ((SourceNode)lastChild).replaceRight(aPattern, aReplacement);
        } else if (lastChild instanceof String) {
            this.children.set(this.children.size() - 1, aPattern.matcher((String)lastChild).replaceFirst(aReplacement));
        } else {
            this.children.add(aPattern.matcher("").replaceFirst(aReplacement));
        }
    }

    public void setSourceContent(String aSourceFile, String aSourceContent) {
        this.sourceContents.put(aSourceFile, aSourceContent);
    }

    public void walkSourceContents(SourceWalker walker) {
        int len = this.children.size();
        for (int i = 0; i < len; ++i) {
            if (!(this.children.get(i) instanceof SourceNode)) continue;
            ((SourceNode)this.children.get(i)).walkSourceContents(walker);
        }
        for (Map.Entry<String, String> entry : this.sourceContents.entrySet()) {
            walker.walk(entry.getKey(), entry.getValue());
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        this.walk((chunk, pos) -> str.append(chunk));
        return str.toString();
    }

    public Code toStringWithSourceMap(String file, String sourceRoot) {
        StringBuilder generatedCode = new StringBuilder();
        int[] generatedLine = new int[]{1};
        int[] generatedColumn = new int[]{0};
        SourceMapGenerator map = new SourceMapGenerator(file, sourceRoot);
        boolean[] sourceMappingActive = new boolean[]{false};
        String[] lastOriginalSource = new String[1];
        Integer[] lastOriginalLine = new Integer[1];
        Integer[] lastOriginalColumn = new Integer[1];
        String[] lastOriginalName = new String[1];
        this.walk((chunk, original) -> {
            generatedCode.append(chunk);
            if (original.source != null && original.line != null && original.column != null) {
                if (!original.source.equals(lastOriginalSource[0]) || lastOriginalLine[0] != original.line || lastOriginalColumn[0] != original.column || (original.name == null ? lastOriginalName[0] != null : !original.name.equals(lastOriginalName[0]))) {
                    map.addMapping(new Mapping(new Position(generatedLine[0], generatedColumn[0]), new Position(original.line, original.column), original.source, original.name));
                }
                lastOriginalSource[0] = original.source;
                lastOriginalLine[0] = original.line;
                lastOriginalColumn[0] = original.column;
                lastOriginalName[0] = original.name;
                sourceMappingActive[0] = true;
            } else if (sourceMappingActive[0]) {
                map.addMapping(new Mapping(new Position(generatedLine[0], generatedColumn[0])));
                lastOriginalSource[0] = null;
                sourceMappingActive[0] = false;
            }
            int length = chunk.length();
            for (int idx = 0; idx < length; ++idx) {
                if (chunk.charAt(idx) == '\n') {
                    generatedLine[0] = generatedLine[0] + 1;
                    generatedColumn[0] = 0;
                    if (idx + 1 == length) {
                        lastOriginalSource[0] = null;
                        sourceMappingActive[0] = false;
                        continue;
                    }
                    if (!sourceMappingActive[0]) continue;
                    map.addMapping(new Mapping(new Position(generatedLine[0], generatedColumn[0]), new Position(original.line, original.column), original.source, original.name));
                    continue;
                }
                generatedColumn[0] = generatedColumn[0] + 1;
            }
        });
        this.walkSourceContents((sourceFile, sourceContent) -> map.setSourceContent(sourceFile, sourceContent));
        return new Code(generatedCode.toString(), map);
    }

    public static interface SourceWalker {
        public void walk(String var1, String var2);
    }

    public static interface ChuckWalker {
        public void walk(String var1, OriginalPosition var2);
    }
}

