/*
 * Decompiled with CFR 0.152.
 */
package org.hibnet.jsourcemap;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hibnet.jsourcemap.ArraySet;
import org.hibnet.jsourcemap.Base64VLQ;
import org.hibnet.jsourcemap.Mapping;
import org.hibnet.jsourcemap.MappingList;
import org.hibnet.jsourcemap.OriginalPosition;
import org.hibnet.jsourcemap.Position;
import org.hibnet.jsourcemap.SourceMap;
import org.hibnet.jsourcemap.SourceMapConsumer;
import org.hibnet.jsourcemap.Util;

public class SourceMapGenerator {
    String _file;
    String _sourceRoot;
    ArraySet<String> _sources;
    ArraySet<String> _names;
    MappingList _mappings;
    Map<String, String> _sourcesContents;
    private int _version = 3;

    public SourceMapGenerator(String file, String sourceRoot) {
        this._file = file;
        this._sourceRoot = sourceRoot;
        this._sources = new ArraySet();
        this._names = new ArraySet();
        this._mappings = new MappingList();
        this._sourcesContents = null;
    }

    public static SourceMapGenerator fromSourceMap(SourceMapConsumer aSourceMapConsumer) {
        String sourceRoot = aSourceMapConsumer.sourceRoot;
        SourceMapGenerator generator = new SourceMapGenerator(aSourceMapConsumer.file, sourceRoot);
        aSourceMapConsumer.eachMapping().forEach(mapping -> {
            Mapping newMapping = new Mapping(mapping.generated);
            if (mapping.source != null) {
                newMapping.source = mapping.source;
                if (sourceRoot != null) {
                    newMapping.source = Util.relative(sourceRoot, newMapping.source);
                }
                newMapping.original = mapping.original;
                if (mapping.name != null) {
                    newMapping.name = mapping.name;
                }
            }
            generator.addMapping(newMapping);
        });
        aSourceMapConsumer.sources().stream().forEach(sourceFile -> {
            String content = aSourceMapConsumer.sourceContentFor((String)sourceFile, null);
            if (content != null) {
                generator.setSourceContent((String)sourceFile, content);
            }
        });
        return generator;
    }

    public void addMapping(Mapping aArgs) {
        Position generated = aArgs.generated;
        Position original = aArgs.original;
        String source = aArgs.source;
        String name = aArgs.name;
        if (source != null && !this._sources.has(source)) {
            this._sources.add(source, false);
        }
        if (name != null && !this._names.has(name)) {
            this._names.add(name, false);
        }
        this._mappings.add(new Mapping(generated, original, source, name));
    }

    public void setSourceContent(String aSourceFile, String aSourceContent) {
        String source = aSourceFile;
        if (this._sourceRoot != null) {
            source = Util.relative(this._sourceRoot, source);
        }
        if (aSourceContent != null) {
            if (this._sourcesContents == null) {
                this._sourcesContents = new HashMap<String, String>();
            }
            this._sourcesContents.put(source, aSourceContent);
        } else if (this._sourcesContents != null) {
            this._sourcesContents.remove(source);
            if (this._sourcesContents.isEmpty()) {
                this._sourcesContents = null;
            }
        }
    }

    void applySourceMap(SourceMapConsumer aSourceMapConsumer, String aSourceFile, String aSourceMapPath) {
        String sourceRoot;
        String sourceFile = aSourceFile;
        if (aSourceFile == null) {
            if (aSourceMapConsumer.file == null) {
                throw new RuntimeException("SourceMapGenerator.prototype.applySourceMap requires either an explicit source file, or the source map's \"file\" property. Both were omitted.");
            }
            sourceFile = aSourceMapConsumer.file;
        }
        if ((sourceRoot = this._sourceRoot) != null) {
            sourceFile = Util.relative(sourceRoot, sourceFile);
        }
        ArraySet newSources = new ArraySet();
        ArraySet newNames = new ArraySet();
        String f_sourceFile = sourceFile;
        this._mappings.unsortedForEach().forEach(mapping -> {
            String name;
            String source;
            if (mapping.source.equals(f_sourceFile) && mapping.original != null) {
                OriginalPosition original = aSourceMapConsumer.originalPositionFor(mapping.original.line, mapping.original.column, null);
                if (original.source != null) {
                    mapping.source = original.source;
                    if (aSourceMapPath != null) {
                        mapping.source = Util.join(aSourceMapPath, mapping.source);
                    }
                    if (sourceRoot != null) {
                        mapping.source = Util.relative(sourceRoot, mapping.source);
                    }
                    mapping.original.line = original.line;
                    mapping.original.column = original.column;
                    if (original.name != null) {
                        mapping.name = original.name;
                    }
                }
            }
            if ((source = mapping.source) != null && !newSources.has(source)) {
                newSources.add(source, false);
            }
            if ((name = mapping.name) != null && !newNames.has(name)) {
                newNames.add(name, false);
            }
        });
        this._sources = newSources;
        this._names = newNames;
        aSourceMapConsumer.sources().stream().forEach(source -> {
            String content = aSourceMapConsumer.sourceContentFor((String)source, null);
            if (content != null) {
                if (aSourceMapPath != null) {
                    source = Util.join(aSourceMapPath, source);
                }
                if (sourceRoot != null) {
                    source = Util.relative(sourceRoot, source);
                }
                this.setSourceContent((String)source, content);
            }
        });
    }

    private String serializeMappings() {
        int previousGeneratedColumn = 0;
        int previousGeneratedLine = 1;
        int previousOriginalColumn = 0;
        int previousOriginalLine = 0;
        int previousName = 0;
        int previousSource = 0;
        String result = "";
        List<Mapping> mappings = this._mappings.toArray();
        int len = mappings.size();
        for (int i = 0; i < len; ++i) {
            Mapping mapping = mappings.get(i);
            if (mapping.generated.line != previousGeneratedLine) {
                previousGeneratedColumn = 0;
                while (mapping.generated.line != previousGeneratedLine) {
                    result = result + ';';
                    ++previousGeneratedLine;
                }
            } else if (i > 0) {
                if (Util.compareByGeneratedPositionsInflated(mapping, mappings.get(i - 1)) == 0) continue;
                result = result + ',';
            }
            result = result + Base64VLQ.encode(mapping.generated.column - previousGeneratedColumn);
            previousGeneratedColumn = mapping.generated.column;
            if (mapping.source == null) continue;
            int sourceIdx = this._sources.indexOf(mapping.source);
            result = result + Base64VLQ.encode(sourceIdx - previousSource);
            previousSource = sourceIdx;
            result = result + Base64VLQ.encode(mapping.original.line - 1 - previousOriginalLine);
            previousOriginalLine = mapping.original.line - 1;
            result = result + Base64VLQ.encode(mapping.original.column - previousOriginalColumn);
            previousOriginalColumn = mapping.original.column;
            if (mapping.name == null) continue;
            int nameIdx = this._names.indexOf(mapping.name);
            result = result + Base64VLQ.encode(nameIdx - previousName);
            previousName = nameIdx;
        }
        return result;
    }

    List<String> _generateSourcesContent(List<String> aSources, String aSourceRoot) {
        return aSources.stream().map(source -> {
            if (this._sourcesContents == null) {
                return null;
            }
            if (aSourceRoot != null) {
                source = Util.relative(aSourceRoot, source);
            }
            return this._sourcesContents.get(source);
        }).collect(Collectors.toList());
    }

    public SourceMap toJSON() {
        SourceMap map = new SourceMap();
        map.version = this._version;
        map.sources = this._sources.toArray();
        map.names = this._names.toArray();
        map.mappings = this.serializeMappings();
        map.file = this._file;
        map.sourceRoot = this._sourceRoot;
        if (this._sourcesContents != null) {
            map.sourcesContent = this._generateSourcesContent(map.sources, this._sourceRoot);
        }
        return map;
    }
}

