/*
 * Decompiled with CFR 0.152.
 */
package org.hibnet.jsourcemap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.hibnet.jsourcemap.ArraySet;
import org.hibnet.jsourcemap.BasicSourceMapConsumer;
import org.hibnet.jsourcemap.BinarySearch;
import org.hibnet.jsourcemap.GeneratedPosition;
import org.hibnet.jsourcemap.IndexedSourceMapConsumer;
import org.hibnet.jsourcemap.Mapping;
import org.hibnet.jsourcemap.OriginalPosition;
import org.hibnet.jsourcemap.Position;
import org.hibnet.jsourcemap.SourceMap;
import org.hibnet.jsourcemap.SourceMapGenerator;
import org.hibnet.jsourcemap.Util;

public abstract class SourceMapConsumer {
    ArraySet<String> _names;
    ArraySet<String> _sources;
    String sourceRoot;
    List<String> sourcesContent;
    String _mappings;
    String file;
    int _version = 3;
    List<ParsedMapping> __generatedMappings = null;
    List<ParsedMapping> __originalMappings = null;

    public static SourceMapConsumer create(SourceMap sourceMap) {
        return sourceMap.sections != null ? new IndexedSourceMapConsumer(sourceMap) : new BasicSourceMapConsumer(sourceMap);
    }

    public static SourceMapConsumer fromSourceMap(SourceMapGenerator aSourceMap) {
        return BasicSourceMapConsumer.fromSourceMap(aSourceMap);
    }

    List<ParsedMapping> _generatedMappings() {
        if (this.__generatedMappings == null) {
            this._parseMappings(this._mappings, this.sourceRoot);
        }
        return this.__generatedMappings;
    }

    List<ParsedMapping> _originalMappings() {
        if (this.__originalMappings == null) {
            this._parseMappings(this._mappings, this.sourceRoot);
        }
        return this.__originalMappings;
    }

    boolean _charIsMappingSeparator(String aStr, int index) {
        char c = aStr.charAt(index);
        return c == ';' || c == ',';
    }

    abstract void _parseMappings(String var1, String var2);

    public abstract List<String> sources();

    public String sourceContentFor(String aSource) {
        return this.sourceContentFor(aSource, null);
    }

    abstract String sourceContentFor(String var1, Boolean var2);

    public abstract OriginalPosition originalPositionFor(int var1, int var2, BinarySearch.Bias var3);

    public abstract boolean hasContentsOfAllSources();

    public abstract GeneratedPosition generatedPositionFor(String var1, int var2, int var3, BinarySearch.Bias var4);

    public Stream<Mapping> eachMapping() {
        return this.eachMapping(null);
    }

    Stream<Mapping> eachMapping(Order aOrder) {
        List<ParsedMapping> mappings;
        if (aOrder == null) {
            aOrder = Order.generated;
        }
        switch (aOrder) {
            case generated: {
                mappings = this._generatedMappings();
                break;
            }
            case original: {
                mappings = this._originalMappings();
                break;
            }
            default: {
                throw new RuntimeException("Unknown order of iteration.");
            }
        }
        String sourceRoot = this.sourceRoot;
        return mappings.stream().map(mapping -> {
            String source;
            String string2 = source = mapping.source == null ? null : this._sources.at(mapping.source);
            if (source != null && sourceRoot != null) {
                source = Util.join(sourceRoot, source);
            }
            return new Mapping(new Position(mapping.generatedLine, mapping.generatedColumn), new Position(mapping.originalLine, mapping.originalColumn), source, mapping.name == null ? null : this._names.at(mapping.name));
        });
    }

    public List<GeneratedPosition> allGeneratedPositionsFor(int line, Integer column, String source) {
        ArrayList<GeneratedPosition> mappings;
        block8: {
            ParsedMapping needle = new ParsedMapping(null, null, line, column == null ? 0 : column, null, null);
            if (this.sourceRoot != null) {
                source = Util.relative(this.sourceRoot, source);
            }
            if (!this._sources.has(source)) {
                return Collections.emptyList();
            }
            needle.source = this._sources.indexOf(source);
            mappings = new ArrayList<GeneratedPosition>();
            int index = this._findMapping(needle, this._originalMappings(), "originalLine", "originalColumn", (mapping1, mapping2) -> Util.compareByOriginalPositions(mapping1, mapping2, true), BinarySearch.Bias.LEAST_UPPER_BOUND);
            if (index < 0) break block8;
            ParsedMapping mapping = this._originalMappings().get(index);
            if (column == null) {
                int originalLine = mapping.originalLine;
                while (mapping != null && mapping.originalLine == originalLine) {
                    mappings.add(new GeneratedPosition(mapping.generatedLine, mapping.generatedColumn, mapping.lastGeneratedColumn));
                    if (++index >= this._originalMappings().size()) {
                        mapping = null;
                        continue;
                    }
                    mapping = this._originalMappings().get(index);
                }
            } else {
                int originalColumn = mapping.originalColumn;
                while (mapping != null && mapping.originalLine == line && mapping.originalColumn == originalColumn) {
                    mappings.add(new GeneratedPosition(mapping.generatedLine, mapping.generatedColumn, mapping.lastGeneratedColumn));
                    if (++index >= this._originalMappings().size()) {
                        mapping = null;
                        continue;
                    }
                    mapping = this._originalMappings().get(index);
                }
            }
        }
        return mappings;
    }

    <T> int _findMapping(T aNeedle, List<T> aMappings, Object aLineName, Object aColumnName, BinarySearch.Comparator<T> aComparator, BinarySearch.Bias aBias) {
        return BinarySearch.search(aNeedle, aMappings, aComparator, aBias);
    }

    static class ParsedMapping {
        Integer generatedLine;
        Integer generatedColumn;
        Integer originalLine;
        Integer originalColumn;
        Integer source;
        Integer name;
        Integer lastGeneratedColumn;

        ParsedMapping() {
        }

        ParsedMapping(Integer generatedLine, Integer generatedColumn) {
            this.generatedLine = generatedLine;
            this.generatedColumn = generatedColumn;
        }

        ParsedMapping(Integer generatedLine, Integer generatedColumn, Integer originalLine, Integer originalColumn, Integer source) {
            this.generatedLine = generatedLine;
            this.generatedColumn = generatedColumn;
            this.originalLine = originalLine;
            this.originalColumn = originalColumn;
            this.source = source;
        }

        ParsedMapping(Integer generatedLine, Integer generatedColumn, Integer originalLine, Integer originalColumn, Integer source, Integer name) {
            this.generatedLine = generatedLine;
            this.generatedColumn = generatedColumn;
            this.originalLine = originalLine;
            this.originalColumn = originalColumn;
            this.source = source;
            this.name = name;
        }

        ParsedMapping(Integer generatedLine, Integer generatedColumn, Integer lastGeneratedColumn) {
            this.generatedLine = generatedLine;
            this.generatedColumn = generatedColumn;
            this.lastGeneratedColumn = lastGeneratedColumn;
        }
    }

    static enum Order {
        generated,
        original;

    }
}

