/*
 * Decompiled with CFR 0.152.
 */
package org.hibnet.jsourcemap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.hibnet.jsourcemap.Mapping;
import org.hibnet.jsourcemap.Position;
import org.hibnet.jsourcemap.Util;

class MappingList {
    private List<Mapping> _array = new ArrayList<Mapping>();
    private boolean _sorted = true;
    private Mapping _last = new Mapping(new Position(-1, 0));

    private boolean generatedPositionAfter(Mapping mappingA, Mapping mappingB) {
        int lineA = mappingA.generated.line;
        int lineB = mappingB.generated.line;
        int columnA = mappingA.generated.column;
        int columnB = mappingB.generated.column;
        return lineB > lineA || lineB == lineA && columnB >= columnA || Util.compareByGeneratedPositionsInflated(mappingA, mappingB) <= 0;
    }

    MappingList() {
    }

    Stream<Mapping> unsortedForEach() {
        return this._array.stream();
    }

    void add(Mapping aMapping) {
        if (this.generatedPositionAfter(this._last, aMapping)) {
            this._last = aMapping;
            this._array.add(aMapping);
        } else {
            this._sorted = false;
            this._array.add(aMapping);
        }
    }

    List<Mapping> toArray() {
        if (!this._sorted) {
            Collections.sort(this._array, Util::compareByGeneratedPositionsInflated);
            this._sorted = true;
        }
        return this._array;
    }
}

