/*
 * Decompiled with CFR 0.152.
 */
package org.hibnet.jsourcemap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.hibnet.jsourcemap.ArraySet;
import org.hibnet.jsourcemap.BinarySearch;
import org.hibnet.jsourcemap.GeneratedPosition;
import org.hibnet.jsourcemap.OriginalPosition;
import org.hibnet.jsourcemap.Position;
import org.hibnet.jsourcemap.Section;
import org.hibnet.jsourcemap.SourceMap;
import org.hibnet.jsourcemap.SourceMapConsumer;
import org.hibnet.jsourcemap.Util;

class IndexedSourceMapConsumer
extends SourceMapConsumer {
    private List<ParsedSection> _sections;
    int _version = 3;

    IndexedSourceMapConsumer(SourceMap sourceMap) {
        int version = sourceMap.version;
        List<Section> sections = sourceMap.sections;
        if (version != this._version) {
            throw new RuntimeException("Unsupported version: " + version);
        }
        this._sources = new ArraySet();
        this._names = new ArraySet();
        Position[] lastOffset = new Position[]{new Position(-1, 0)};
        this._sections = sections.stream().map(s -> {
            if (s.url != null) {
                throw new RuntimeException("Support for url field in sections not implemented.");
            }
            Position offset = s.offset;
            int offsetLine = offset.line;
            int offsetColumn = offset.column;
            if (offsetLine < positionArray[0].line || offsetLine == positionArray[0].line && offsetColumn < positionArray[0].column) {
                throw new RuntimeException("Section offsets must be ordered and non-overlapping.");
            }
            positionArray[0] = offset;
            return new ParsedSection(new ParsedOffset(offsetLine + 1, offsetColumn + 1), SourceMapConsumer.create(s.map));
        }).collect(Collectors.toList());
    }

    @Override
    public List<String> sources() {
        ArrayList<String> sources = new ArrayList<String>();
        for (int i = 0; i < this._sections.size(); ++i) {
            for (int j = 0; j < this._sections.get((int)i).consumer.sources().size(); ++j) {
                sources.add(this._sections.get((int)i).consumer.sources().get(j));
            }
        }
        return sources;
    }

    @Override
    public OriginalPosition originalPositionFor(int line, int column, BinarySearch.Bias bias) {
        ParsedSection needle = new ParsedSection(new ParsedOffset(line, column), null);
        int sectionIndex = BinarySearch.search(needle, this._sections, (section1, section2) -> {
            int cmp = section1.generatedOffset.generatedLine - section2.generatedOffset.generatedLine;
            if (cmp != 0) {
                return cmp;
            }
            return section1.generatedOffset.generatedColumn - section2.generatedOffset.generatedColumn;
        }, null);
        ParsedSection section = this._sections.get(sectionIndex);
        if (section == null) {
            return new OriginalPosition();
        }
        return section.consumer.originalPositionFor(needle.generatedOffset.generatedLine - (section.generatedOffset.generatedLine - 1), needle.generatedOffset.generatedColumn - (section.generatedOffset.generatedLine == needle.generatedOffset.generatedLine ? section.generatedOffset.generatedColumn - 1 : 0), bias);
    }

    @Override
    public boolean hasContentsOfAllSources() {
        return this._sections.stream().allMatch(s -> s.consumer.hasContentsOfAllSources());
    }

    @Override
    String sourceContentFor(String aSource, Boolean nullOnMissing) {
        for (int i = 0; i < this._sections.size(); ++i) {
            ParsedSection section = this._sections.get(i);
            String content = section.consumer.sourceContentFor(aSource, true);
            if (content == null) continue;
            return content;
        }
        if (nullOnMissing != null && nullOnMissing.booleanValue()) {
            return null;
        }
        throw new RuntimeException("\"" + aSource + "\" is not in the SourceMap.");
    }

    @Override
    public GeneratedPosition generatedPositionFor(String source, int line, int column, BinarySearch.Bias bias) {
        for (int i = 0; i < this._sections.size(); ++i) {
            GeneratedPosition generatedPosition;
            ParsedSection section = this._sections.get(i);
            if (section.consumer.sources().indexOf(source) == -1 || (generatedPosition = section.consumer.generatedPositionFor(source, line, column, bias)) == null) continue;
            GeneratedPosition ret = new GeneratedPosition(generatedPosition.line + (section.generatedOffset.generatedLine - 1), generatedPosition.column + (section.generatedOffset.generatedLine == generatedPosition.line ? section.generatedOffset.generatedColumn - 1 : 0), null);
            return ret;
        }
        return new GeneratedPosition();
    }

    @Override
    void _parseMappings(String aStr, String aSourceRoot) {
        this.__generatedMappings = new ArrayList();
        this.__originalMappings = new ArrayList();
        for (int i = 0; i < this._sections.size(); ++i) {
            ParsedSection section = this._sections.get(i);
            List<SourceMapConsumer.ParsedMapping> sectionMappings = section.consumer._generatedMappings();
            for (int j = 0; j < sectionMappings.size(); ++j) {
                SourceMapConsumer.ParsedMapping mapping = sectionMappings.get(j);
                String source = section.consumer._sources.at(mapping.source);
                if (section.consumer.sourceRoot != null) {
                    source = Util.join(section.consumer.sourceRoot, source);
                }
                this._sources.add(source);
                Integer source_ = this._sources.indexOf(source);
                String name = section.consumer._names.at(mapping.name);
                this._names.add(name);
                Integer name_ = this._names.indexOf(name);
                SourceMapConsumer.ParsedMapping adjustedMapping = new SourceMapConsumer.ParsedMapping(mapping.generatedLine + (section.generatedOffset.generatedLine - 1), mapping.generatedColumn + (section.generatedOffset.generatedLine == mapping.generatedLine ? section.generatedOffset.generatedColumn - 1 : 0), mapping.originalLine, mapping.originalColumn, source_, name_);
                this.__generatedMappings.add(adjustedMapping);
                if (adjustedMapping.originalLine == null) continue;
                this.__originalMappings.add(adjustedMapping);
            }
        }
        Collections.sort(this.__generatedMappings, Util::compareByGeneratedPositionsDeflated);
        Collections.sort(this.__originalMappings, Util::compareByOriginalPositions);
    }

    static class ParsedSection {
        ParsedOffset generatedOffset;
        SourceMapConsumer consumer;

        ParsedSection(ParsedOffset generatedOffset, SourceMapConsumer consumer) {
            this.generatedOffset = generatedOffset;
            this.consumer = consumer;
        }
    }

    static class ParsedOffset {
        int generatedLine;
        int generatedColumn;

        ParsedOffset(int generatedLine, int generatedColumn) {
            this.generatedLine = generatedLine;
            this.generatedColumn = generatedColumn;
        }
    }
}

