/*
 * Decompiled with CFR 0.152.
 */
package org.hibnet.jsourcemap;

import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibnet.jsourcemap.Mapping;
import org.hibnet.jsourcemap.SourceMapConsumer;

class Util {
    private static final Pattern urlRegexp = Pattern.compile("^(?:([\\w+\\-.]+):)?//(?:(\\w+:\\w+)@)?([\\w.]*)(?::(\\d+))?(\\S*)$");
    private static final Pattern dataUrlRegexp = Pattern.compile("^data:.+\\,.+$");

    Util() {
    }

    static final ParsedUrl urlParse(String aUrl) {
        Matcher match = urlRegexp.matcher(aUrl);
        if (!match.matches()) {
            return null;
        }
        ParsedUrl parsed = new ParsedUrl();
        parsed.scheme = match.group(1);
        parsed.auth = match.group(2);
        parsed.host = match.group(3);
        parsed.port = match.group(4);
        parsed.path = match.group(5);
        if (parsed.path.length() == 0) {
            parsed.path = null;
        }
        return parsed;
    }

    static final String urlGenerate(ParsedUrl aParsedUrl) {
        StringBuilder url = new StringBuilder();
        if (aParsedUrl.scheme != null) {
            url.append(aParsedUrl.scheme);
            url.append(':');
        }
        url.append("//");
        if (aParsedUrl.auth != null) {
            url.append(aParsedUrl.auth);
            url.append('@');
        }
        if (aParsedUrl.host != null) {
            url.append(aParsedUrl.host);
        }
        if (aParsedUrl.port != null) {
            url.append(":");
            url.append(aParsedUrl.port);
        }
        if (aParsedUrl.path != null) {
            url.append(aParsedUrl.path);
        }
        return url.toString();
    }

    static final String normalize(String aPath) {
        String path = aPath;
        ParsedUrl url = Util.urlParse(aPath);
        if (url != null) {
            if (url.path == null) {
                return aPath;
            }
            path = url.path;
        }
        boolean isAbsolute = Util.isAbsolute(path);
        String[] parts = path.split("/+");
        if (path.endsWith("/")) {
            String[] p = new String[parts.length + 1];
            System.arraycopy(parts, 0, p, 0, parts.length);
            p[parts.length] = "";
            parts = p;
        }
        int up = 0;
        for (int i = parts.length - 1; i >= 0; --i) {
            String part = parts[i];
            if (part.equals(".")) {
                parts = Util.splice(parts, i, 1);
                continue;
            }
            if (part.equals("..")) {
                ++up;
                continue;
            }
            if (up <= 0) continue;
            if (part.length() == 0) {
                parts = Util.splice(parts, i + 1, up);
                up = 0;
                continue;
            }
            parts = Util.splice(parts, i, 2);
            --up;
        }
        path = Util.join(Arrays.asList(parts), "/");
        if (path.length() == 0) {
            String string = path = isAbsolute ? "/" : ".";
        }
        if (url != null) {
            url.path = path;
            return Util.urlGenerate(url);
        }
        return path;
    }

    static final String join(String aRoot, String aPath) {
        String joined;
        if (aRoot.length() == 0) {
            aRoot = ".";
        }
        if (aPath.length() == 0) {
            aPath = ".";
        }
        ParsedUrl aPathUrl = Util.urlParse(aPath);
        ParsedUrl aRootUrl = Util.urlParse(aRoot);
        if (aRootUrl != null) {
            String string = aRoot = aRootUrl.path == null || aRootUrl.path.isEmpty() ? "/" : aRootUrl.path;
        }
        if (aPathUrl != null && aPathUrl.scheme == null) {
            if (aRootUrl != null) {
                aPathUrl.scheme = aRootUrl.scheme;
            }
            return Util.urlGenerate(aPathUrl);
        }
        if (aPathUrl != null || dataUrlRegexp.matcher(aPath).matches()) {
            return aPath;
        }
        if (aRootUrl != null && (aRootUrl.host == null || aRootUrl.host.isEmpty()) && (aRootUrl.path == null || aRootUrl.path.isEmpty())) {
            aRootUrl.host = aPath;
            return Util.urlGenerate(aRootUrl);
        }
        String string = joined = aPath.charAt(0) == '/' ? aPath : Util.normalize(aRoot.replaceAll("/+$", "") + '/' + aPath);
        if (aRootUrl != null) {
            aRootUrl.path = joined;
            return Util.urlGenerate(aRootUrl);
        }
        return joined;
    }

    static final boolean isAbsolute(String aPath) {
        return aPath.length() > 0 && aPath.charAt(0) == '/' || urlRegexp.matcher(aPath).matches();
    }

    static final String relative(String aRoot, String aPath) {
        if (aRoot.length() == 0) {
            aRoot = ".";
        }
        aRoot = aRoot.replaceAll("/$", "");
        int level = 0;
        while (aPath.indexOf(aRoot + '/') != 0) {
            int index = aRoot.lastIndexOf("/");
            if (index < 0) {
                return aPath;
            }
            if ((aRoot = aRoot.substring(0, index)).matches("^([^/]+:/)?/*$")) {
                return aPath;
            }
            ++level;
        }
        return Util.join(level + 1, "../") + aPath.substring(aRoot.length() + 1);
    }

    static String toSetString(String aStr) {
        return '$' + aStr;
    }

    static String fromSetString(String aStr) {
        return aStr.substring(1);
    }

    private static final int intcmp(Integer i1, Integer i2) {
        if (i1 == null && i2 == null) {
            return 0;
        }
        if (i1 == null) {
            return -i2.intValue();
        }
        if (i2 == null) {
            return i1;
        }
        return i1 - i2;
    }

    static int compareByOriginalPositions(SourceMapConsumer.ParsedMapping mappingA, SourceMapConsumer.ParsedMapping mappingB) {
        return Util.compareByOriginalPositions(mappingA, mappingB, null);
    }

    static int compareByOriginalPositions(SourceMapConsumer.ParsedMapping mappingA, SourceMapConsumer.ParsedMapping mappingB, Boolean onlyCompareOriginal) {
        int cmp = Util.intcmp(mappingA.source, mappingB.source);
        if (cmp != 0) {
            return cmp;
        }
        cmp = Util.intcmp(mappingA.originalLine, mappingB.originalLine);
        if (cmp != 0) {
            return cmp;
        }
        cmp = Util.intcmp(mappingA.originalColumn, mappingB.originalColumn);
        if (cmp != 0 || onlyCompareOriginal != null && onlyCompareOriginal.booleanValue()) {
            return cmp;
        }
        cmp = Util.intcmp(mappingA.generatedColumn, mappingB.generatedColumn);
        if (cmp != 0) {
            return cmp;
        }
        cmp = Util.intcmp(mappingA.generatedLine, mappingB.generatedLine);
        if (cmp != 0) {
            return cmp;
        }
        return Util.intcmp(mappingA.name, mappingB.name);
    }

    static int compareByGeneratedPositionsDeflated(SourceMapConsumer.ParsedMapping mappingA, SourceMapConsumer.ParsedMapping mappingB) {
        return Util.compareByGeneratedPositionsDeflated(mappingA, mappingB, null);
    }

    static int compareByGeneratedPositionsDeflated(SourceMapConsumer.ParsedMapping mappingA, SourceMapConsumer.ParsedMapping mappingB, Boolean onlyCompareGenerated) {
        int cmp = Util.intcmp(mappingA.generatedLine, mappingB.generatedLine);
        if (cmp != 0) {
            return cmp;
        }
        cmp = Util.intcmp(mappingA.generatedColumn, mappingB.generatedColumn);
        if (cmp != 0 || onlyCompareGenerated != null && onlyCompareGenerated.booleanValue()) {
            return cmp;
        }
        cmp = Util.intcmp(mappingA.source, mappingB.source);
        if (cmp != 0) {
            return cmp;
        }
        cmp = Util.intcmp(mappingA.originalLine, mappingB.originalLine);
        if (cmp != 0) {
            return cmp;
        }
        cmp = Util.intcmp(mappingA.originalColumn, mappingB.originalColumn);
        if (cmp != 0) {
            return cmp;
        }
        return Util.intcmp(mappingA.name, mappingB.name);
    }

    private static final int strcmp(String aStr1, String aStr2) {
        if (aStr1 == aStr2 || aStr1 != null && aStr1.equals(aStr2)) {
            return 0;
        }
        if (aStr1 != null && aStr2 != null && aStr1.compareTo(aStr2) > 0) {
            return 1;
        }
        return -1;
    }

    static final int compareByGeneratedPositionsInflated(Mapping mappingA, Mapping mappingB) {
        int cmp = Util.intcmp(mappingA.generated.line, mappingB.generated.line);
        if (cmp != 0) {
            return cmp;
        }
        cmp = Util.intcmp(mappingA.generated.column, mappingB.generated.column);
        if (cmp != 0) {
            return cmp;
        }
        cmp = Util.strcmp(mappingA.source, mappingB.source);
        if (cmp != 0) {
            return cmp;
        }
        cmp = Util.intcmp(mappingA.original == null ? null : mappingA.original.line, mappingB.original == null ? null : mappingB.original.line);
        if (cmp != 0) {
            return cmp;
        }
        cmp = Util.intcmp(mappingA.original == null ? null : mappingA.original.column, mappingB.original == null ? null : mappingB.original.column);
        if (cmp != 0) {
            return cmp;
        }
        return Util.strcmp(mappingA.name, mappingB.name);
    }

    static final String join(Collection<String> list, String join) {
        StringBuilder buffer = new StringBuilder();
        boolean first = true;
        for (String item : list) {
            if (!first) {
                buffer.append(join);
            }
            first = false;
            buffer.append(item);
        }
        return buffer.toString();
    }

    private static final String join(int n, String join) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 1; i < n; ++i) {
            buffer.append(join);
        }
        return buffer.toString();
    }

    private static final String[] splice(String[] array, int start, int nb) {
        String[] newArray = new String[array.length - nb];
        System.arraycopy(array, 0, newArray, 0, start);
        System.arraycopy(array, start + nb, newArray, start, array.length - (start + nb));
        return newArray;
    }

    static final class ParsedUrl {
        String scheme;
        String auth;
        String host;
        String port;
        String path;

        ParsedUrl() {
        }
    }
}

