/*
 * Decompiled with CFR 0.152.
 */
package org.hibnet.jsourcemap;

import java.util.List;

class BinarySearch {
    BinarySearch() {
    }

    private static <T> int recursiveSearch(int aLow, int aHigh, T aNeedle, List<T> aHaystack, Comparator<T> aCompare, Bias aBias) {
        int mid = (int)(Math.floor((aHigh - aLow) / 2) + (double)aLow);
        int cmp = aCompare.compare(aNeedle, aHaystack.get(mid));
        if (cmp == 0) {
            return mid;
        }
        if (cmp > 0) {
            if (aHigh - mid > 1) {
                return BinarySearch.recursiveSearch(mid, aHigh, aNeedle, aHaystack, aCompare, aBias);
            }
            if (aBias == Bias.LEAST_UPPER_BOUND) {
                return aHigh < aHaystack.size() ? aHigh : -1;
            }
            return mid;
        }
        if (mid - aLow > 1) {
            return BinarySearch.recursiveSearch(aLow, mid, aNeedle, aHaystack, aCompare, aBias);
        }
        if (aBias == Bias.LEAST_UPPER_BOUND) {
            return mid;
        }
        return aLow < 0 ? -1 : aLow;
    }

    static <T> int search(T aNeedle, List<T> aHaystack, Comparator<T> aCompare, Bias aBias) {
        int index;
        if (aHaystack.size() == 0) {
            return -1;
        }
        if (aBias == null) {
            aBias = Bias.GREATEST_LOWER_BOUND;
        }
        if ((index = BinarySearch.recursiveSearch(-1, aHaystack.size(), aNeedle, aHaystack, aCompare, aBias)) < 0) {
            return -1;
        }
        while (index - 1 >= 0 && aCompare.compare(aHaystack.get(index), aHaystack.get(index - 1)) == 0) {
            --index;
        }
        return index;
    }

    static interface Comparator<T> {
        public int compare(T var1, T var2);
    }

    static enum Bias {
        GREATEST_LOWER_BOUND,
        LEAST_UPPER_BOUND;

    }
}

