/*
 * Decompiled with CFR 0.152.
 */
package org.hibnet.jsourcemap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.hibnet.jsourcemap.ArraySet;
import org.hibnet.jsourcemap.Base64VLQ;
import org.hibnet.jsourcemap.BinarySearch;
import org.hibnet.jsourcemap.GeneratedPosition;
import org.hibnet.jsourcemap.Mapping;
import org.hibnet.jsourcemap.OriginalPosition;
import org.hibnet.jsourcemap.SourceMap;
import org.hibnet.jsourcemap.SourceMapConsumer;
import org.hibnet.jsourcemap.SourceMapGenerator;
import org.hibnet.jsourcemap.Util;

class BasicSourceMapConsumer
extends SourceMapConsumer {
    int _version = 3;

    BasicSourceMapConsumer(SourceMap sourceMap) {
        int version = sourceMap.version;
        List<String> sources = sourceMap.sources;
        List<Object> names = sourceMap.names == null ? Collections.emptyList() : sourceMap.names;
        String sourceRoot = sourceMap.sourceRoot;
        List<String> sourcesContent = sourceMap.sourcesContent;
        String mappings = sourceMap.mappings;
        String file = sourceMap.file;
        if (version != this._version) {
            throw new RuntimeException("Unsupported version:" + version);
        }
        sources = sources.stream().map(Util::normalize).map(source -> sourceRoot != null && Util.isAbsolute(sourceRoot) && Util.isAbsolute(source) ? Util.relative(sourceRoot, source) : source).collect(Collectors.toList());
        this._names = ArraySet.fromArray(names, true);
        this._sources = ArraySet.fromArray(sources, true);
        this.sourceRoot = sourceRoot;
        this.sourcesContent = sourcesContent;
        this._mappings = mappings;
        this.file = file;
    }

    private BasicSourceMapConsumer() {
    }

    public static BasicSourceMapConsumer fromSourceMap(SourceMapGenerator aSourceMap) {
        BasicSourceMapConsumer smc = new BasicSourceMapConsumer();
        ArraySet<String> names = smc._names = ArraySet.fromArray(aSourceMap._names.toArray(), true);
        ArraySet<String> sources = smc._sources = ArraySet.fromArray(aSourceMap._sources.toArray(), true);
        smc.sourceRoot = aSourceMap._sourceRoot;
        smc.sourcesContent = aSourceMap._generateSourcesContent(smc._sources.toArray(), smc.sourceRoot);
        smc.file = aSourceMap._file;
        ArrayList<Mapping> generatedMappings = new ArrayList<Mapping>(aSourceMap._mappings.toArray());
        ArrayList<SourceMapConsumer.ParsedMapping> destGeneratedMappings = smc.__generatedMappings = new ArrayList<SourceMapConsumer.ParsedMapping>();
        ArrayList<SourceMapConsumer.ParsedMapping> destOriginalMappings = smc.__originalMappings = new ArrayList<SourceMapConsumer.ParsedMapping>();
        int length = generatedMappings.size();
        for (int i = 0; i < length; ++i) {
            Mapping srcMapping = (Mapping)generatedMappings.get(i);
            SourceMapConsumer.ParsedMapping destMapping = new SourceMapConsumer.ParsedMapping();
            destMapping.generatedLine = srcMapping.generated.line;
            destMapping.generatedColumn = srcMapping.generated.column;
            if (srcMapping.source != null) {
                destMapping.source = sources.indexOf(srcMapping.source);
                destMapping.originalLine = srcMapping.original.line;
                destMapping.originalColumn = srcMapping.original.column;
                if (srcMapping.name != null) {
                    destMapping.name = names.indexOf(srcMapping.name);
                }
                destOriginalMappings.add(destMapping);
            }
            destGeneratedMappings.add(destMapping);
        }
        Collections.sort(smc.__originalMappings, Util::compareByOriginalPositions);
        return smc;
    }

    @Override
    public List<String> sources() {
        return this._sources.toArray().stream().map(s -> this.sourceRoot != null ? Util.join(this.sourceRoot, s) : s).collect(Collectors.toList());
    }

    @Override
    protected void _parseMappings(String aStr, String aSourceRoot) {
        int generatedLine = 1;
        int previousGeneratedColumn = 0;
        int previousOriginalLine = 0;
        int previousOriginalColumn = 0;
        int previousSource = 0;
        int previousName = 0;
        int length = aStr.length();
        int index = 0;
        HashMap cachedSegments = new HashMap();
        ArrayList<SourceMapConsumer.ParsedMapping> originalMappings = new ArrayList<SourceMapConsumer.ParsedMapping>();
        ArrayList<SourceMapConsumer.ParsedMapping> generatedMappings = new ArrayList<SourceMapConsumer.ParsedMapping>();
        while (index < length) {
            int end;
            if (aStr.charAt(index) == ';') {
                ++generatedLine;
                ++index;
                previousGeneratedColumn = 0;
                continue;
            }
            if (aStr.charAt(index) == ',') {
                ++index;
                continue;
            }
            SourceMapConsumer.ParsedMapping mapping = new SourceMapConsumer.ParsedMapping();
            mapping.generatedLine = generatedLine;
            for (end = index; end < length && !this._charIsMappingSeparator(aStr, end); ++end) {
            }
            String str = aStr.substring(index, end);
            ArrayList<Integer> segment = (ArrayList<Integer>)cachedSegments.get(str);
            if (segment != null) {
                index += str.length();
            } else {
                segment = new ArrayList<Integer>();
                while (index < end) {
                    Base64VLQ.Base64VLQResult temp = Base64VLQ.decode(aStr, index);
                    int value = temp.value;
                    index = temp.rest;
                    segment.add(value);
                }
                if (segment.size() == 2) {
                    throw new Error("Found a source, but no line and column");
                }
                if (segment.size() == 3) {
                    throw new Error("Found a source and line, but no column");
                }
                cachedSegments.put(str, segment);
            }
            mapping.generatedColumn = previousGeneratedColumn + (Integer)segment.get(0);
            previousGeneratedColumn = mapping.generatedColumn;
            if (segment.size() > 1) {
                mapping.source = previousSource + (Integer)segment.get(1);
                previousSource += ((Integer)segment.get(1)).intValue();
                mapping.originalLine = previousOriginalLine + (Integer)segment.get(2);
                previousOriginalLine = mapping.originalLine;
                SourceMapConsumer.ParsedMapping parsedMapping = mapping;
                Integer.valueOf(parsedMapping.originalLine + 1);
                parsedMapping.originalLine = parsedMapping.originalLine;
                mapping.originalColumn = previousOriginalColumn + (Integer)segment.get(3);
                previousOriginalColumn = mapping.originalColumn;
                if (segment.size() > 4) {
                    mapping.name = previousName + (Integer)segment.get(4);
                    previousName += ((Integer)segment.get(4)).intValue();
                }
            }
            generatedMappings.add(mapping);
            if (mapping.originalLine == null) continue;
            originalMappings.add(mapping);
        }
        Collections.sort(generatedMappings, Util::compareByGeneratedPositionsDeflated);
        this.__generatedMappings = generatedMappings;
        Collections.sort(originalMappings, Util::compareByOriginalPositions);
        this.__originalMappings = originalMappings;
    }

    void computeColumnSpans() {
        for (int index = 0; index < this._generatedMappings().size(); ++index) {
            SourceMapConsumer.ParsedMapping mapping = this._generatedMappings().get(index);
            if (index + 1 < this._generatedMappings().size()) {
                SourceMapConsumer.ParsedMapping nextMapping = this._generatedMappings().get(index + 1);
                if (mapping.generatedLine == nextMapping.generatedLine) {
                    mapping.lastGeneratedColumn = nextMapping.generatedColumn - 1;
                    continue;
                }
            }
            mapping.lastGeneratedColumn = Integer.MAX_VALUE;
        }
    }

    @Override
    public OriginalPosition originalPositionFor(int line, int column, BinarySearch.Bias bias) {
        int index;
        SourceMapConsumer.ParsedMapping needle = new SourceMapConsumer.ParsedMapping(line, column);
        if (bias == null) {
            bias = BinarySearch.Bias.GREATEST_LOWER_BOUND;
        }
        if ((index = this._findMapping(needle, this._generatedMappings(), "generatedLine", "generatedColumn", (mapping1, mapping2) -> Util.compareByGeneratedPositionsDeflated(mapping1, mapping2, true), bias)) >= 0) {
            SourceMapConsumer.ParsedMapping mapping = this._generatedMappings().get(index);
            if (mapping.generatedLine == needle.generatedLine) {
                Integer source = mapping.source;
                String source_ = null;
                if (source != null) {
                    source_ = (String)this._sources.at(source);
                    if (this.sourceRoot != null) {
                        source_ = Util.join(this.sourceRoot, source_);
                    }
                }
                Integer name = mapping.name;
                String name_ = null;
                if (name != null) {
                    name_ = (String)this._names.at(name);
                }
                return new OriginalPosition(mapping.originalLine, mapping.originalColumn, source_, name_);
            }
        }
        return new OriginalPosition();
    }

    @Override
    public boolean hasContentsOfAllSources() {
        if (this.sourcesContent == null) {
            return false;
        }
        return this.sourcesContent.size() >= this._sources.size() && !this.sourcesContent.stream().anyMatch(sc -> sc == null);
    }

    @Override
    String sourceContentFor(String aSource, Boolean nullOnMissing) {
        Util.ParsedUrl url;
        if (this.sourcesContent == null) {
            return null;
        }
        if (this.sourceRoot != null) {
            aSource = Util.relative(this.sourceRoot, aSource);
        }
        if (this._sources.has(aSource)) {
            return (String)this.sourcesContent.get(this._sources.indexOf(aSource));
        }
        if (this.sourceRoot != null && (url = Util.urlParse(this.sourceRoot)) != null) {
            String fileUriAbsPath = aSource.replaceAll("^file://", "");
            if (url.scheme.equals("file") && this._sources.has(fileUriAbsPath)) {
                return (String)this.sourcesContent.get(this._sources.indexOf(fileUriAbsPath));
            }
            if ((url.path == null || url.path.equals("/")) && this._sources.has("/" + aSource)) {
                return (String)this.sourcesContent.get(this._sources.indexOf("/" + aSource));
            }
        }
        if (nullOnMissing != null && nullOnMissing.booleanValue()) {
            return null;
        }
        throw new RuntimeException("\"" + aSource + "\" is not in the SourceMap.");
    }

    @Override
    public GeneratedPosition generatedPositionFor(String source, int line, int column, BinarySearch.Bias bias) {
        int index;
        if (this.sourceRoot != null) {
            source = Util.relative(this.sourceRoot, source);
        }
        if (!this._sources.has(source)) {
            return new GeneratedPosition();
        }
        int source_ = this._sources.indexOf(source);
        SourceMapConsumer.ParsedMapping needle = new SourceMapConsumer.ParsedMapping(null, null, line, column, source_, null);
        if (bias == null) {
            bias = BinarySearch.Bias.GREATEST_LOWER_BOUND;
        }
        if ((index = this._findMapping(needle, this._originalMappings(), "originalLine", "originalColumn", (mapping1, mapping2) -> Util.compareByOriginalPositions(mapping1, mapping2, true), bias)) >= 0) {
            SourceMapConsumer.ParsedMapping mapping = this._originalMappings().get(index);
            if (mapping.source == needle.source) {
                return new GeneratedPosition(mapping.generatedLine != null ? mapping.generatedLine : null, mapping.generatedColumn != null ? mapping.generatedColumn : null, mapping.lastGeneratedColumn != null ? mapping.lastGeneratedColumn : null);
            }
        }
        return new GeneratedPosition();
    }
}

