/*
 * Decompiled with CFR 0.152.
 */
package org.hibnet.jsourcemap;

import org.hibnet.jsourcemap.Base64;

class Base64VLQ {
    private static final int VLQ_BASE_SHIFT = 5;
    private static final int VLQ_BASE = 32;
    private static final int VLQ_BASE_MASK = 31;
    private static final int VLQ_CONTINUATION_BIT = 32;

    Base64VLQ() {
    }

    private static int toVLQSigned(int aValue) {
        return aValue < 0 ? (-aValue << 1) + 1 : (aValue << 1) + 0;
    }

    private static int fromVLQSigned(int aValue) {
        boolean isNegative = (aValue & 1) == 1;
        int shifted = aValue >> 1;
        return isNegative ? -shifted : shifted;
    }

    static final String encode(int aValue) {
        String encoded = "";
        int vlq = Base64VLQ.toVLQSigned(aValue);
        do {
            int digit = vlq & 0x1F;
            if ((vlq >>>= 5) > 0) {
                digit |= 0x20;
            }
            encoded = encoded + Base64.encode(digit);
        } while (vlq > 0);
        return encoded;
    }

    static Base64VLQResult decode(String aStr, int aIndex) {
        boolean continuation;
        int strLen = aStr.length();
        int result = 0;
        int shift = 0;
        do {
            int digit;
            if (aIndex >= strLen) {
                throw new Error("Expected more digits in base 64 VLQ value.");
            }
            if ((digit = Base64.decode(aStr.charAt(aIndex++))) == -1) {
                throw new Error("Invalid base64 digit: " + aStr.charAt(aIndex - 1));
            }
            continuation = (digit & 0x20) != 0;
            result += (digit &= 0x1F) << shift;
            shift += 5;
        } while (continuation);
        return new Base64VLQResult(Base64VLQ.fromVLQSigned(result), aIndex);
    }

    static final class Base64VLQResult {
        int value;
        int rest;

        Base64VLQResult(int value, int rest) {
            this.value = value;
            this.rest = rest;
        }
    }
}

