/*
 * Decompiled with CFR 0.152.
 */
package org.hibnet.jsourcemap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ArraySet<T> {
    private Map<T, Integer> _set = new HashMap<T, Integer>();
    private List<T> _array = new ArrayList<T>();

    ArraySet() {
    }

    static <T> ArraySet<T> fromArray(List<T> aArray, Boolean aAllowDuplicates) {
        ArraySet<T> set = new ArraySet<T>();
        int len = aArray.size();
        for (int i = 0; i < len; ++i) {
            set.add(aArray.get(i), aAllowDuplicates);
        }
        return set;
    }

    int size() {
        return this._array.size();
    }

    void add(T t) {
        this.add(t, null);
    }

    void add(T t, Boolean aAllowDuplicates) {
        if (t == null) {
            return;
        }
        boolean isDuplicate = this.has(t);
        int idx = this._array.size();
        if (!isDuplicate || aAllowDuplicates != null && aAllowDuplicates.booleanValue()) {
            this._array.add(t);
        }
        if (!isDuplicate) {
            this._set.put(t, idx);
        }
    }

    boolean has(T t) {
        if (t == null) {
            return false;
        }
        return this._set.containsKey(t);
    }

    Integer indexOf(T t) {
        if (t == null) {
            return null;
        }
        Integer i = this._set.get(t);
        if (i == null) {
            return -1;
        }
        return i;
    }

    T at(Integer i) {
        if (i == null) {
            return null;
        }
        return this._array.get(i);
    }

    List<T> toArray() {
        return new ArrayList<T>(this._array);
    }
}

