/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.LanguageAccessor;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.nodes.Node;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.function.Supplier;

public final class TruffleContext
implements AutoCloseable {
    static final TruffleContext EMPTY = new TruffleContext();
    private static final ThreadLocal<List<Object>> CONTEXT_ASSERT_STACK;
    final Object polyglotContext;
    final boolean closeable;

    TruffleContext(Object polyglotContext, boolean closeable) {
        this.polyglotContext = polyglotContext;
        this.closeable = closeable;
    }

    private TruffleContext() {
        this.polyglotContext = null;
        this.closeable = false;
    }

    @CompilerDirectives.TruffleBoundary
    public boolean equals(Object obj) {
        if (!(obj instanceof TruffleContext)) {
            return false;
        }
        TruffleContext c = (TruffleContext)obj;
        return this.polyglotContext.equals(c.polyglotContext);
    }

    public int hashCode() {
        return this.polyglotContext.hashCode();
    }

    @CompilerDirectives.TruffleBoundary
    public TruffleContext getParent() {
        try {
            return LanguageAccessor.engineAccess().getParentContext(this.polyglotContext);
        }
        catch (Throwable t) {
            throw TruffleLanguage.Env.engineToLanguageException(t);
        }
    }

    @Deprecated
    public Object enter() {
        return this.enter(null);
    }

    public Object enter(Node node) {
        try {
            CompilerAsserts.partialEvaluationConstant(node);
            Object prev = LanguageAccessor.engineAccess().enterInternalContext(node, this.polyglotContext);
            if (CONTEXT_ASSERT_STACK != null) {
                TruffleContext.verifyEnter(prev);
            }
            return prev;
        }
        catch (Throwable t) {
            throw TruffleLanguage.Env.engineToLanguageException(t);
        }
    }

    public boolean isEntered() {
        try {
            return LanguageAccessor.engineAccess().isContextEntered(this.polyglotContext);
        }
        catch (Throwable t) {
            throw TruffleLanguage.Env.engineToLanguageException(t);
        }
    }

    public boolean isActive() {
        try {
            return LanguageAccessor.engineAccess().isContextActive(this.polyglotContext);
        }
        catch (Throwable t) {
            throw TruffleLanguage.Env.engineToLanguageException(t);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public boolean isClosed() {
        try {
            return LanguageAccessor.engineAccess().isContextClosed(this.polyglotContext);
        }
        catch (Throwable t) {
            throw TruffleLanguage.Env.engineToLanguageException(t);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public boolean isCancelling() {
        try {
            return LanguageAccessor.engineAccess().isContextCancelling(this.polyglotContext);
        }
        catch (Throwable t) {
            throw TruffleLanguage.Env.engineToLanguageException(t);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public Future<Void> pause() {
        try {
            return LanguageAccessor.engineAccess().pause(this.polyglotContext);
        }
        catch (Throwable t) {
            throw TruffleLanguage.Env.engineToLanguageException(t);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void resume(Future<Void> pauseFuture) {
        try {
            LanguageAccessor.engineAccess().resume(this.polyglotContext, pauseFuture);
        }
        catch (Throwable t) {
            throw TruffleLanguage.Env.engineToLanguageException(t);
        }
    }

    @Deprecated
    public void leave(Object prev) {
        this.leave(null, prev);
    }

    public void leave(Node node, Object prev) {
        try {
            if (CONTEXT_ASSERT_STACK != null) {
                TruffleContext.verifyLeave(prev);
            }
            LanguageAccessor.engineAccess().leaveInternalContext(node, this.polyglotContext, prev);
        }
        catch (Throwable t) {
            throw TruffleLanguage.Env.engineToLanguageException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T leaveAndEnter(Node node, Supplier<T> runWhileOutsideContext) {
        CompilerAsserts.partialEvaluationConstant(node);
        try {
            LanguageAccessor.engineAccess().leaveInternalContext(node, this.polyglotContext, null);
            try {
                T t = TruffleContext.callSupplier(runWhileOutsideContext);
                return t;
            }
            finally {
                LanguageAccessor.engineAccess().enterInternalContext(node, this.polyglotContext);
            }
        }
        catch (Throwable t2) {
            throw TruffleLanguage.Env.engineToLanguageException(t2);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static <T> T callSupplier(Supplier<T> supplier) {
        return supplier.get();
    }

    @CompilerDirectives.TruffleBoundary
    private static void verifyEnter(Object prev) {
        assert (CONTEXT_ASSERT_STACK != null);
        CONTEXT_ASSERT_STACK.get().add(prev);
    }

    @CompilerDirectives.TruffleBoundary
    private static void verifyLeave(Object prev) {
        assert (CONTEXT_ASSERT_STACK != null);
        List<Object> list = CONTEXT_ASSERT_STACK.get();
        assert (!list.isEmpty()) : "Assert stack is empty.";
        Object expectedPrev = list.get(list.size() - 1);
        assert (prev == expectedPrev) : "Invalid prev argument provided in TruffleContext.leave(Object).";
        list.remove(list.size() - 1);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void close() {
        if (!this.closeable) {
            throw new UnsupportedOperationException("This context instance has no permission to close. Only the original creator of the truffle context or instruments can close.");
        }
        try {
            LanguageAccessor.engineAccess().closeContext(this.polyglotContext, false, null, false, null);
        }
        catch (Throwable t) {
            throw TruffleLanguage.Env.engineToLanguageException(t);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void closeCancelled(Node closeLocation, String message) {
        if (!this.closeable) {
            throw new UnsupportedOperationException("This context instance has no permission to close. Only the original creator of the truffle context or instruments can close.");
        }
        try {
            LanguageAccessor.engineAccess().closeContext(this.polyglotContext, true, closeLocation, false, message);
        }
        catch (Throwable t) {
            throw TruffleLanguage.Env.engineToLanguageException(t);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void closeResourceExhausted(Node location, String message) {
        if (!this.closeable) {
            throw new UnsupportedOperationException("This context instance has no permission to cancel. Only the original creator of the truffle context or instruments can close.");
        }
        try {
            LanguageAccessor.engineAccess().closeContext(this.polyglotContext, true, location, true, message);
        }
        catch (Throwable t) {
            throw TruffleLanguage.Env.engineToLanguageException(t);
        }
    }

    static {
        boolean assertions = false;
        if (!$assertionsDisabled) {
            assertions = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        CONTEXT_ASSERT_STACK = assertions ? new ThreadLocal<List<Object>>(){

            @Override
            protected List<Object> initialValue() {
                return new ArrayList<Object>();
            }
        } : null;
    }

    public final class Builder {
        private final TruffleLanguage.Env sourceEnvironment;
        private Map<String, Object> config;

        Builder(TruffleLanguage.Env env) {
            this.sourceEnvironment = env;
        }

        @CompilerDirectives.TruffleBoundary
        public Builder config(String key, Object value) {
            if (this.config == null) {
                this.config = new HashMap<String, Object>();
            }
            this.config.put(key, value);
            return this;
        }

        @CompilerDirectives.TruffleBoundary
        public TruffleContext build() {
            try {
                return LanguageAccessor.engineAccess().createInternalContext(this.sourceEnvironment.getPolyglotLanguageContext(), this.config);
            }
            catch (Throwable t) {
                throw TruffleLanguage.Env.engineToLanguageException(t);
            }
        }
    }
}

