/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import org.geotools.data.DataUtilities;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.feature.SchemaException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

class DelayedSchemaFeatureCollection
extends ListFeatureCollection {
    static final SimpleFeatureType PLACEHOLDER;

    public DelayedSchemaFeatureCollection() {
        super((SimpleFeatureType)null);
    }

    public SimpleFeatureType getSchema() {
        if (this.schema == null) {
            if (this.isEmpty()) {
                return PLACEHOLDER;
            }
            this.schema = ((SimpleFeature)this.list.get(0)).getFeatureType();
        }
        return this.schema;
    }

    public boolean add(SimpleFeature f) {
        this.bounds = null;
        return this.list.add(f);
    }

    protected ReferencedEnvelope calculateBounds() {
        if (this.list.isEmpty()) {
            return new ReferencedEnvelope();
        }
        return super.calculateBounds();
    }

    static {
        SimpleFeatureType placeholder = null;
        try {
            placeholder = DataUtilities.createType((String)"PLACEHOLDER", (String)"");
        }
        catch (SchemaException e) {
            throw new RuntimeException(e);
        }
        PLACEHOLDER = placeholder;
    }
}

