/**
 *
 * $Id$
 */
package net.opengis.ows10.validation;

import net.opengis.ows10.BoundingBoxType;
import net.opengis.ows10.CodeType;
import net.opengis.ows10.ContactType;
import net.opengis.ows10.DCPType;
import net.opengis.ows10.ExceptionReportType;
import net.opengis.ows10.ExceptionType;
import net.opengis.ows10.GetCapabilitiesType;
import net.opengis.ows10.HTTPType;
import net.opengis.ows10.KeywordsType;
import net.opengis.ows10.MetadataType;
import net.opengis.ows10.OperationType;
import net.opengis.ows10.OperationsMetadataType;
import net.opengis.ows10.ResponsiblePartyType;
import net.opengis.ows10.ServiceIdentificationType;
import net.opengis.ows10.ServiceProviderType;
import net.opengis.ows10.WGS84BoundingBoxType;

import org.eclipse.emf.common.util.EMap;

import org.eclipse.emf.ecore.EObject;

import org.eclipse.emf.ecore.util.FeatureMap;

/**
 * A sample validator interface for {@link net.opengis.ows10.DocumentRoot}.
 * This doesn't really do anything, and it's not a real EMF artifact.
 * It was generated by the org.eclipse.emf.examples.generator.validator plug-in to illustrate how EMF's code generator can be extended.
 * This can be disabled with -vmargs -Dorg.eclipse.emf.examples.generator.validator=false.
 */
public interface DocumentRootValidator {
  boolean validate();

  boolean validateMixed(FeatureMap value);
  boolean validateXMLNSPrefixMap(EMap value);
  boolean validateXSISchemaLocation(EMap value);
  boolean validateAbstract(String value);
  boolean validateContactInfo(ContactType value);
  boolean validateIndividualName(String value);
  boolean validateKeywords(KeywordsType value);
  boolean validateOrganisationName(String value);
  boolean validatePointOfContact(ResponsiblePartyType value);
  boolean validatePositionName(String value);
  boolean validateRole(CodeType value);
  boolean validateTitle(String value);
  boolean validateAbstractMetaData(EObject value);
  boolean validateAccessConstraints(String value);
  boolean validateAvailableCRS(String value);
  boolean validateBoundingBox(BoundingBoxType value);
  boolean validateDcp(DCPType value);
  boolean validateException(ExceptionType value);
  boolean validateExceptionReport(ExceptionReportType value);
  boolean validateExtendedCapabilities(EObject value);
  boolean validateFees(String value);
  boolean validateGetCapabilities(GetCapabilitiesType value);
  boolean validateHttp(HTTPType value);
  boolean validateIdentifier(CodeType value);
  boolean validateLanguage(String value);
  boolean validateMetadata(MetadataType value);
  boolean validateOperation(OperationType value);
  boolean validateOperationsMetadata(OperationsMetadataType value);
  boolean validateOutputFormat(String value);
  boolean validateServiceIdentification(ServiceIdentificationType value);
  boolean validateServiceProvider(ServiceProviderType value);
  boolean validateSupportedCRS(String value);
  boolean validateWgS84BoundingBox(WGS84BoundingBoxType value);
}
