/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.maven.xmlcodegen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.AttributeType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.feature.type.PropertyDescriptor;
import org.geotools.feature.NameImpl;
import org.geotools.feature.type.AbstractLazyAttributeTypeImpl;
import org.geotools.feature.type.AbstractLazyComplexTypeImpl;
import org.geotools.maven.xmlcodegen.SchemaGenerator;
import org.geotools.util.Utilities;
import org.geotools.xsd.Schemas;

public class CycleSchemaGenerator
extends SchemaGenerator {
    private static final int DUMMY_DEPTH = Integer.MAX_VALUE;

    public CycleSchemaGenerator(XSDSchema schema) {
        super(schema);
    }

    @Override
    protected AttributeType createType(final XSDSimpleTypeDefinition xsdType, int depth) {
        if (this.types.containsKey(xsdType)) {
            return (AttributeType)this.types.get(xsdType);
        }
        if (!xsdType.getTargetNamespace().equals(this.schema.getTargetNamespace())) {
            return this.findType((XSDTypeDefinition)xsdType);
        }
        System.err.println("Creating simple type " + String.valueOf(this.name((XSDNamedComponent)xsdType)));
        AbstractLazyAttributeTypeImpl gtType = new AbstractLazyAttributeTypeImpl(this.name((XSDNamedComponent)xsdType), Object.class, false, false, null, null){

            public AttributeType buildSuper() {
                XSDTypeDefinition baseType = xsdType.getBaseType();
                if (baseType != null && baseType.getName() != null && !baseType.equals(xsdType)) {
                    return CycleSchemaGenerator.this.createType(baseType, Integer.MAX_VALUE);
                }
                return null;
            }
        };
        this.types.put(xsdType, gtType);
        return gtType;
    }

    @Override
    protected AttributeType createType(final XSDComplexTypeDefinition xsdType, int depth) {
        if (this.types.containsKey(xsdType)) {
            return (AttributeType)this.types.get(xsdType);
        }
        if (!xsdType.getTargetNamespace().equals(this.schema.getTargetNamespace())) {
            return this.findType((XSDTypeDefinition)xsdType);
        }
        System.err.println("Creating complex type " + String.valueOf(this.name((XSDNamedComponent)xsdType)));
        AbstractLazyComplexTypeImpl gtType = new AbstractLazyComplexTypeImpl(this.name((XSDNamedComponent)xsdType), false, xsdType.isAbstract(), null, null){

            public AttributeType buildSuper() {
                XSDTypeDefinition baseType = xsdType.getBaseType();
                if (baseType != null && baseType.getName() != null && !baseType.equals(xsdType)) {
                    return CycleSchemaGenerator.this.createType(baseType, Integer.MAX_VALUE);
                }
                return null;
            }

            public Collection<PropertyDescriptor> buildDescriptors() {
                if (!CycleSchemaGenerator.this.followComplexTypes) {
                    return null;
                }
                ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
                for (XSDParticle particle : Schemas.getChildElementParticles((XSDTypeDefinition)xsdType, (boolean)false)) {
                    Object childType;
                    XSDElementDeclaration element = (XSDElementDeclaration)particle.getContent();
                    if (element.isElementDeclarationReference()) {
                        element = element.getResolvedElementDeclaration();
                    }
                    if ((childType = element.getTypeDefinition()) == null) {
                        childType = CycleSchemaGenerator.this.findGlobalElementXSDType(element);
                    }
                    AttributeType gtType = null;
                    gtType = childType != null ? CycleSchemaGenerator.this.createType((XSDTypeDefinition)childType, Integer.MAX_VALUE) : CycleSchemaGenerator.this.xsAnyType();
                    if (gtType == null) {
                        throw new RuntimeException();
                    }
                    int minOccurs = particle.getMinOccurs();
                    int maxOccurs = particle.getMaxOccurs();
                    if (maxOccurs == -1) {
                        maxOccurs = Integer.MAX_VALUE;
                    }
                    boolean isNillable = element.isNillable();
                    AttributeDescriptor ad = CycleSchemaGenerator.this.factory.createAttributeDescriptor(gtType, (Name)new NameImpl(element.getTargetNamespace(), element.getName()), minOccurs, maxOccurs, isNillable, null);
                    properties.add((PropertyDescriptor)ad);
                }
                for (XSDAttributeDeclaration attribute : Schemas.getAttributeDeclarations((XSDTypeDefinition)xsdType, (boolean)false)) {
                    XSDAttributeDeclaration ad2;
                    XSDSimpleTypeDefinition type;
                    if (attribute.isAttributeDeclarationReference()) {
                        attribute = attribute.getResolvedAttributeDeclaration();
                    }
                    if ((type = attribute.getTypeDefinition()) == null) {
                        for (XSDAttributeDeclaration ad2 : CycleSchemaGenerator.this.schema.getAttributeDeclarations()) {
                            if (!Utilities.equals((Object)ad2.getTargetNamespace(), (Object)attribute.getTargetNamespace()) || !Utilities.equals((Object)ad2.getName(), (Object)attribute.getName())) continue;
                            type = ad2.getTypeDefinition();
                            break;
                        }
                    }
                    if (type == null) {
                        throw new RuntimeException("Could not locate type definition for attribute " + String.valueOf(CycleSchemaGenerator.this.name((XSDNamedComponent)attribute)) + " of " + String.valueOf(this.getName()));
                    }
                    if (type.getName() == null) continue;
                    AttributeType gtType = CycleSchemaGenerator.this.createType(type, Integer.MAX_VALUE);
                    ad2 = CycleSchemaGenerator.this.factory.createAttributeDescriptor(gtType, CycleSchemaGenerator.this.name((XSDNamedComponent)attribute), 0, 1, true, null);
                    properties.add((PropertyDescriptor)ad2);
                }
                return properties;
            }
        };
        this.types.put(xsdType, gtType);
        return gtType;
    }

    @Override
    protected String getSchemaClassTemplateName() {
        return "CycleSchemaClassTemplate";
    }

    @Override
    public List<AttributeType> sort() {
        ArrayList<AttributeType> sorted = new ArrayList<AttributeType>(this.types.values());
        Collections.sort(sorted, new Comparator<AttributeType>(){

            @Override
            public int compare(AttributeType at1, AttributeType at2) {
                return ((NameImpl)at1.getName()).compareTo((NameImpl)at2.getName());
            }
        });
        return sorted;
    }
}

