/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.maven.xmlcodegen.templates;

import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.xsd.XSDTypeDefinition;
import org.geotools.maven.xmlcodegen.SchemaGenerator;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.feature.type.PropertyType;
import org.opengis.feature.type.Schema;

public class CycleSchemaClassTemplate {
    protected static String nl;
    public final String NL = nl == null ? System.getProperties().getProperty("line.separator") : nl;
    protected final String TEXT_1 = "";
    protected final String TEXT_2 = this.NL + this.NL + "import java.util.ArrayList;" + this.NL + "import java.util.Collection;" + this.NL + "import java.util.List;" + this.NL + "import java.util.TreeMap;" + this.NL + "" + this.NL + "import org.geotools.feature.NameImpl;" + this.NL + "import org.geotools.feature.type.AbstractLazyAttributeTypeImpl;" + this.NL + "import org.geotools.feature.type.AbstractLazyComplexTypeImpl;" + this.NL + "import org.geotools.feature.type.AttributeDescriptorImpl;" + this.NL + "import org.geotools.feature.type.SchemaImpl;" + this.NL + "import org.opengis.feature.type.AttributeType;" + this.NL + "import org.opengis.feature.type.ComplexType;" + this.NL + "import org.opengis.feature.type.Name;" + this.NL + "import org.opengis.feature.type.PropertyDescriptor;" + this.NL + "import org.opengis.feature.type.Schema;";
    protected final String TEXT_3 = this.NL + "import ";
    protected final String TEXT_4 = ";";
    protected final String TEXT_5 = this.NL + this.NL + "public class ";
    protected final String TEXT_6 = "Schema extends SchemaImpl {" + this.NL;
    protected final String TEXT_7 = this.NL + "    /**" + this.NL + "     * <p>" + this.NL + "     *  <pre>" + this.NL + "     *   <code>";
    protected final String TEXT_8 = this.NL + "     *  ";
    protected final String TEXT_9 = this.NL + "     *" + this.NL + "     *    </code>" + this.NL + "     *   </pre>" + this.NL + "     * </p>" + this.NL + "     *" + this.NL + "     * @generated" + this.NL + "     */";
    protected final String TEXT_10 = this.NL + "    public static final ComplexType ";
    protected final String TEXT_11 = "_TYPE = build_";
    protected final String TEXT_12 = "_TYPE();" + this.NL + "    " + this.NL + "    private static ComplexType build_";
    protected final String TEXT_13 = "_TYPE() {" + this.NL + "        ComplexType builtType = new AbstractLazyComplexTypeImpl(" + this.NL + "                new NameImpl(\"";
    protected final String TEXT_14 = "\",\"";
    protected final String TEXT_15 = "\"),";
    protected final String TEXT_16 = this.NL + "                ";
    protected final String TEXT_17 = ", ";
    protected final String TEXT_18 = ", ";
    protected final String TEXT_19 = ", ";
    protected final String TEXT_20 = ") {";
    protected final String TEXT_21 = this.NL + "    public static final AttributeType ";
    protected final String TEXT_22 = "_TYPE = build_";
    protected final String TEXT_23 = "_TYPE();" + this.NL + "     " + this.NL + "    private static AttributeType build_";
    protected final String TEXT_24 = "_TYPE() {" + this.NL + "        AttributeType builtType = new AbstractLazyAttributeTypeImpl(" + this.NL + "                new NameImpl(\"";
    protected final String TEXT_25 = "\",\"";
    protected final String TEXT_26 = "\"),";
    protected final String TEXT_27 = this.NL + "                ";
    protected final String TEXT_28 = ", ";
    protected final String TEXT_29 = ", ";
    protected final String TEXT_30 = ", ";
    protected final String TEXT_31 = ", ";
    protected final String TEXT_32 = ") {";
    protected final String TEXT_33 = this.NL + "            @Override" + this.NL + "            public AttributeType buildSuper() {" + this.NL + "                return ";
    protected final String TEXT_34 = ";" + this.NL + "            }";
    protected final String TEXT_35 = this.NL + "            @Override" + this.NL + "            public Collection<PropertyDescriptor> buildDescriptors() {";
    protected final String TEXT_36 = this.NL + "                return null;";
    protected final String TEXT_37 = this.NL + "                List<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();";
    protected final String TEXT_38 = this.NL + "                descriptors.add(" + this.NL + "                    new AttributeDescriptorImpl(";
    protected final String TEXT_39 = this.NL + "                        ";
    protected final String TEXT_40 = ",";
    protected final String TEXT_41 = this.NL + "                        ";
    protected final String TEXT_42 = ",";
    protected final String TEXT_43 = this.NL + "                        ";
    protected final String TEXT_44 = ", ";
    protected final String TEXT_45 = ", ";
    protected final String TEXT_46 = ", null));";
    protected final String TEXT_47 = this.NL + "                return descriptors;";
    protected final String TEXT_48 = this.NL + "            }";
    protected final String TEXT_49 = this.NL + "        };";
    protected final String TEXT_50 = this.NL + "           builtType.put(";
    protected final String TEXT_51 = ",";
    protected final String TEXT_52 = ");";
    protected final String TEXT_53 = this.NL + "        return builtType;" + this.NL + "    }" + this.NL;
    protected final String TEXT_54 = this.NL + this.NL + "    public ";
    protected final String TEXT_55 = "Schema() {" + this.NL + "        super(\"";
    protected final String TEXT_56 = "\");";
    protected final String TEXT_57 = this.NL + "        put(";
    protected final String TEXT_58 = "_TYPE);";
    protected final String TEXT_59 = this.NL + "    }" + this.NL + "" + this.NL + "    /**" + this.NL + "     * Complete the definition of a type and store it in the schema." + this.NL + "     * " + this.NL + "     * <p>" + this.NL + "     * " + this.NL + "     * This method calls {@link AttributeType#getSuper()} (and {@link ComplexType#getDescriptors()}" + this.NL + "     * where applicable) to ensure the construction of the type (a concrete" + this.NL + "     * {@link AbstractLazyAttributeTypeImpl} or {@link AbstractLazyComplexTypeImpl} sublass) is" + this.NL + "     * complete. This should be sufficient to avoid any nasty thread-safety surprises in code using" + this.NL + "     * this schema." + this.NL + "     * " + this.NL + "     * @param type" + this.NL + "     *            the type to complete and store" + this.NL + "     */" + this.NL + "    private void put(AttributeType type) {" + this.NL + "        type.getSuper();" + this.NL + "        if (type instanceof ComplexType) {" + this.NL + "            ((ComplexType) type).getDescriptors();" + this.NL + "        }" + this.NL + "        put(type.getName(), type);" + this.NL + "    }" + this.NL + "" + this.NL + "    /**" + this.NL + "     * Test that this class can be loaded." + this.NL + "     */" + this.NL + "    public static void main(String[] args) {" + this.NL + "        Schema schema = new ";
    protected final String TEXT_60 = "Schema();" + this.NL + "        for (Entry<Name, AttributeType> entry : new TreeMap<Name, AttributeType>(schema).entrySet()) {" + this.NL + "            System.out.println(\"Type: \" + entry.getValue().getName());" + this.NL + "            System.out.println(\"    Super type: \" + entry.getValue().getSuper().getName());" + this.NL + "            if (entry.getValue() instanceof ComplexType) {" + this.NL + "                for (PropertyDescriptor descriptor : ((ComplexType) entry.getValue())" + this.NL + "                        .getDescriptors()) {" + this.NL + "                    System.out.println(\"    Property descriptor: \" + descriptor.getName());" + this.NL + "                    System.out.println(\"        Property type: \" + descriptor.getType().getName());" + this.NL + "                }" + this.NL + "            }" + this.NL + "        }" + this.NL + "    }" + this.NL + "" + this.NL + "}";

    public static synchronized CycleSchemaClassTemplate create(String lineSeparator) {
        nl = lineSeparator;
        CycleSchemaClassTemplate result = new CycleSchemaClassTemplate();
        nl = null;
        return result;
    }

    public String generate(Object argument) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("");
        Object[] arguments = (Object[])argument;
        Schema schema = (Schema)arguments[0];
        String prefix = (String)arguments[1];
        prefix = prefix.toUpperCase();
        SchemaGenerator sg = (SchemaGenerator)arguments[2];
        List<AttributeType> types = sg.sort();
        stringBuffer.append(this.TEXT_2);
        HashMap<String, String> ns2import = new HashMap<String, String>();
        for (Schema imported : sg.getImports()) {
            String fullClassName = imported.getClass().getName();
            String className = fullClassName.substring(fullClassName.lastIndexOf(".") + 1);
            ns2import.put(imported.getURI(), className);
            stringBuffer.append(this.TEXT_3);
            stringBuffer.append(fullClassName);
            stringBuffer.append(";");
        }
        stringBuffer.append(this.TEXT_5);
        stringBuffer.append(prefix);
        stringBuffer.append(this.TEXT_6);
        Map<Name, String> typeBindings = sg.getTypeBindings();
        for (AttributeType type : types) {
            String[] lines;
            TransformerHandler xmls;
            Name name = type.getName();
            stringBuffer.append(this.TEXT_7);
            XSDTypeDefinition xsdType = sg.getXSDType(type);
            StringWriter writer = new StringWriter();
            SAXTransformerFactory txFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
            try {
                xmls = txFactory.newTransformerHandler();
            }
            catch (TransformerConfigurationException e) {
                throw new RuntimeException(e);
            }
            xmls.getTransformer().setOutputProperty("method", "XML");
            xmls.getTransformer().setOutputProperty("omit-xml-declaration", "true");
            xmls.getTransformer().setOutputProperty("indent", "true");
            try {
                xmls.getTransformer().transform(new DOMSource(xsdType.getElement()), new StreamResult(writer));
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            for (String line : lines = writer.getBuffer().toString().split("\n")) {
                stringBuffer.append(this.TEXT_8);
                stringBuffer.append(line.replaceAll("<", "&lt;").replaceAll(">", "&gt;"));
            }
            stringBuffer.append(this.TEXT_9);
            String uri = name.getNamespaceURI();
            String local = name.getLocalPart();
            String binding = typeBindings.containsKey(name) ? typeBindings.get(name) + ".class" : type.getBinding().getName() + ".class";
            String isIdentified = type.isIdentified() ? "true" : "false";
            String isAbstract = type.isAbstract() ? "true" : "false";
            String restrictions = "null";
            String superType = "null";
            if (type.getSuper() != null) {
                superType = type.getSuper().getName().getLocalPart().toUpperCase() + "_TYPE";
                String superURI = type.getSuper().getName().getNamespaceURI();
                if (!uri.equals(superURI)) {
                    superType = (String)ns2import.get(superURI) + "." + superType;
                }
            }
            String description = "null";
            if (type instanceof ComplexType && !typeBindings.containsKey(name)) {
                stringBuffer.append(this.TEXT_10);
                stringBuffer.append(name.getLocalPart().toUpperCase());
                stringBuffer.append("_TYPE = build_");
                stringBuffer.append(name.getLocalPart().toUpperCase());
                stringBuffer.append(this.TEXT_12);
                stringBuffer.append(name.getLocalPart().toUpperCase());
                stringBuffer.append(this.TEXT_13);
                stringBuffer.append(uri);
                stringBuffer.append("\",\"");
                stringBuffer.append(local);
                stringBuffer.append("\"),");
                stringBuffer.append(this.TEXT_16);
                stringBuffer.append(isIdentified);
                stringBuffer.append(", ");
                stringBuffer.append(isAbstract);
                stringBuffer.append(", ");
                stringBuffer.append(restrictions);
                stringBuffer.append(", ");
                stringBuffer.append(description);
                stringBuffer.append(") {");
            } else {
                stringBuffer.append(this.TEXT_21);
                stringBuffer.append(name.getLocalPart().toUpperCase());
                stringBuffer.append("_TYPE = build_");
                stringBuffer.append(name.getLocalPart().toUpperCase());
                stringBuffer.append(this.TEXT_23);
                stringBuffer.append(name.getLocalPart().toUpperCase());
                stringBuffer.append(this.TEXT_24);
                stringBuffer.append(uri);
                stringBuffer.append("\",\"");
                stringBuffer.append(local);
                stringBuffer.append("\"),");
                stringBuffer.append(this.TEXT_27);
                stringBuffer.append(binding);
                stringBuffer.append(", ");
                stringBuffer.append(isIdentified);
                stringBuffer.append(", ");
                stringBuffer.append(isAbstract);
                stringBuffer.append(", ");
                stringBuffer.append(restrictions);
                stringBuffer.append(", ");
                stringBuffer.append(description);
                stringBuffer.append(") {");
            }
            stringBuffer.append(this.TEXT_33);
            stringBuffer.append(superType);
            stringBuffer.append(this.TEXT_34);
            if (type instanceof ComplexType && !typeBindings.containsKey(name)) {
                ComplexType cType = (ComplexType)type;
                stringBuffer.append(this.TEXT_35);
                if (cType.getDescriptors().isEmpty()) {
                    stringBuffer.append(this.TEXT_36);
                } else {
                    stringBuffer.append(this.TEXT_37);
                    for (PropertyDescriptor pd : cType.getDescriptors()) {
                        if (!(pd instanceof AttributeDescriptor)) continue;
                        AttributeDescriptor ad = (AttributeDescriptor)pd;
                        AttributeType adType = ad.getType();
                        String adTypeName = adType.getName().getLocalPart().toUpperCase() + "_TYPE";
                        String adTypeURI = adType.getName().getNamespaceURI();
                        if (!uri.equals(adTypeURI)) {
                            adTypeName = (String)ns2import.get(adTypeURI) + "." + adTypeName;
                        }
                        String adName = ad.getName().getNamespaceURI() == null ? "new NameImpl(\"" + ad.getName().getLocalPart() + "\")" : "new NameImpl(\"" + ad.getName().getNamespaceURI() + "\",\"" + ad.getName().getLocalPart() + "\")";
                        String min = ad.getMinOccurs() + "";
                        String max = ad.getMaxOccurs() + "";
                        String isNillable = ad.isNillable() ? "true" : "false";
                        stringBuffer.append(this.TEXT_38);
                        stringBuffer.append(this.TEXT_39);
                        stringBuffer.append(adTypeName);
                        stringBuffer.append(",");
                        stringBuffer.append(this.TEXT_41);
                        stringBuffer.append(adName);
                        stringBuffer.append(",");
                        stringBuffer.append(this.TEXT_43);
                        stringBuffer.append(min);
                        stringBuffer.append(", ");
                        stringBuffer.append(max);
                        stringBuffer.append(", ");
                        stringBuffer.append(isNillable);
                        stringBuffer.append(", null));");
                    }
                    stringBuffer.append(this.TEXT_47);
                }
                stringBuffer.append(this.TEXT_48);
            }
            stringBuffer.append(this.TEXT_49);
            if (!type.getUserData().isEmpty()) {
                for (Map.Entry entry : type.getUserData().entrySet()) {
                    PropertyDescriptor pd;
                    pd = (PropertyDescriptor)entry.getValue();
                    PropertyType pdType = pd.getType();
                    String pdTypeName = pdType.getName().getLocalPart().toUpperCase() + "_TYPE";
                    if (ns2import.containsKey(pdType.getName().getNamespaceURI())) {
                        String importClassName = (String)ns2import.get(pdType.getName().getNamespaceURI());
                        pdTypeName = importClassName + "." + pdTypeName;
                    }
                    String pdName = "new NameImpl(\"" + pd.getName().getNamespaceURI() + "\",\"" + pd.getName().getLocalPart() + "\")";
                    stringBuffer.append(this.TEXT_50);
                    stringBuffer.append(pdName);
                    stringBuffer.append(",");
                    stringBuffer.append(pdTypeName);
                    stringBuffer.append(");");
                }
            }
            stringBuffer.append(this.TEXT_53);
        }
        stringBuffer.append(this.TEXT_54);
        stringBuffer.append(prefix);
        stringBuffer.append(this.TEXT_55);
        stringBuffer.append(schema.getURI());
        stringBuffer.append("\");");
        for (AttributeType type : types) {
            stringBuffer.append(this.TEXT_57);
            stringBuffer.append(type.getName().getLocalPart().toUpperCase());
            stringBuffer.append("_TYPE);");
        }
        stringBuffer.append(this.TEXT_59);
        stringBuffer.append(prefix);
        stringBuffer.append(this.TEXT_60);
        return stringBuffer.toString();
    }
}

