/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.dialog;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractListModel;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CRSListModel
extends AbstractListModel<String> {
    private List<Item> allItems = new ArrayList<Item>();
    private List<Item> filterItems = new ArrayList<Item>();

    public CRSListModel(String authority) {
        try {
            CRSAuthorityFactory fac = ReferencingFactoryFinder.getCRSAuthorityFactory((String)authority, null);
            Set codes = fac.getAuthorityCodes(CoordinateReferenceSystem.class);
            if (authority == null || authority.trim().length() == 0) {
                authority = "EPSG";
            }
            for (String code : codes) {
                code = code.trim();
                String desc = fac.getDescriptionText(authority + ":" + code).toString();
                this.allItems.add(new Item(code, desc));
            }
            this.filterItems.addAll(this.allItems);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public int getSize() {
        return this.filterItems.size();
    }

    @Override
    public String getElementAt(int i) {
        return this.filterItems.get(i).toString();
    }

    public void setFilter(String subStr) {
        this.filterItems.clear();
        if (subStr == null || subStr.trim().length() == 0) {
            this.filterItems.addAll(this.allItems);
        } else {
            String lo = subStr.toLowerCase();
            for (Item item : this.allItems) {
                if (!item.code.toLowerCase().contains(lo) && !item.desc.toLowerCase().contains(lo)) continue;
                this.filterItems.add(item);
            }
        }
        this.fireContentsChanged(this, 0, this.getSize());
    }

    public String getCodeAt(int i) {
        return this.filterItems.get((int)i).code;
    }

    public int findCode(String code) {
        String searchCode;
        String string = searchCode = code == null ? null : code.trim();
        if (searchCode != null && searchCode.length() > 0) {
            for (int i = 0; i < this.filterItems.size(); ++i) {
                if (!this.filterItems.get((int)i).code.equalsIgnoreCase(code)) continue;
                return i;
            }
        }
        return -1;
    }

    private static class Item {
        String code;
        String desc;

        Item(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public String toString() {
            return this.code + ": " + this.desc;
        }
    }
}

