/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style;

import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.LiteShape;
import org.geotools.geometry.jts.LiteShape2;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.algorithm.Angle;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.util.AffineTransformation;

public class MarkAlongLine
implements Stroke {
    public static final String VENDOR_OPTION_NAME = "markAlongLine";
    public static final String VENDOR_OPTION_SCALE_LIMIT = "markAlongLineScaleLimit";
    public static final String VENDOR_OPTION_SIMPLICATION_FACTOR = "markAlongLineSimplify";
    private static final Logger LOGGER = Logging.getLogger((String)MarkAlongLine.class.getName());
    private static final int LINEAR_ANGLE_TOLERANCE = 35;
    Stroke delegate;
    private float scaleImit = 0.9f;
    private float simplicationFactor = 0.5f;
    MarkAlongLiteShape wktShape;
    AffineTransform at;
    double size = 20.0;
    static GeometryFactory gf = new GeometryFactory();

    public MarkAlongLine(Stroke delegate) {
        this.delegate = delegate;
    }

    public MarkAlongLine(Stroke delegate, double size, Geometry wkt) {
        this.delegate = delegate;
        this.size = size / JTS.toRectangle2D((Envelope)wkt.getEnvelopeInternal()).getHeight();
        AffineTransformation at = new AffineTransformation();
        at.setToScale(this.size, this.size);
        this.wktShape = new MarkAlongLiteShape(at.transform(wkt), null, false);
    }

    public float getScaleImit() {
        return this.scaleImit;
    }

    public void setScaleImit(float scaleImit) {
        if (scaleImit < 0.0f || scaleImit > 1.0f || Float.isInfinite(scaleImit) || Float.isNaN(scaleImit)) {
            LOGGER.severe("Invalid Scale limit " + scaleImit + ", should be between 0 and 1");
        }
        this.scaleImit = scaleImit;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Scale Limit set to " + this.scaleImit);
        }
    }

    public float getSimplicationFactor() {
        return this.simplicationFactor;
    }

    public void setSimplicationFactor(float simplicationFactor) {
        if (simplicationFactor < 0.0f || simplicationFactor > 1.0f || Float.isInfinite(simplicationFactor) || Float.isNaN(simplicationFactor)) {
            LOGGER.severe("Invalid Simplification Factor " + simplicationFactor + ", should be between 0 and 1");
        }
        this.simplicationFactor = simplicationFactor;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Simplication factor set to " + this.simplicationFactor);
        }
    }

    @Override
    public Shape createStrokedShape(Shape shape) {
        List<LiteShape2> unpackedList;
        GeneralPath newshape = new GeneralPath();
        float[] coords = new float[6];
        float[] prevcoords = new float[6];
        boolean connectPrevious = false;
        Coordinate lastShapeEndedAtCoordinate = null;
        LineSegment nextLineSegment = null;
        LineSegment previousLineSegment = null;
        MarkAlongLiteShape drapeMe = null;
        MarkAlongLiteShape previousDrapeMe = null;
        double time = new Date().getTime();
        boolean segmentsTouch = false;
        int segments = 0;
        int type = 0;
        float projFactor = 0.0f;
        boolean insideTurn = false;
        boolean isLinear = false;
        try {
            unpackedList = this.unPackMultiPolygon(shape);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error unpacking Multi Polygon", e);
            unpackedList = Arrays.asList((LiteShape2)shape);
        }
        for (LiteShape2 innerShape : unpackedList) {
            PathIterator i = innerShape.getPathIterator(null);
            while (!i.isDone()) {
                type = i.currentSegment(coords);
                ++segments;
                switch (type) {
                    case 0: {
                        newshape.moveTo(coords[0], coords[1]);
                        break;
                    }
                    case 1: {
                        if (LOGGER.isLoggable(Level.FINER)) {
                            LOGGER.finer("------------------------------------");
                        }
                        nextLineSegment = new LineSegment(new Coordinate((double)prevcoords[0], (double)prevcoords[1]), new Coordinate((double)coords[0], (double)coords[1]));
                        if (previousLineSegment != null && LOGGER.isLoggable(Level.FINER)) {
                            LOGGER.finer("Segments " + previousLineSegment.toString() + " --> " + nextLineSegment.toString());
                        }
                        segmentsTouch = previousLineSegment == null ? false : this.segmentsTouch(nextLineSegment, previousLineSegment);
                        if (previousDrapeMe != null && segmentsTouch && previousDrapeMe.getLeftOver() != null && previousDrapeMe.isClipped()) {
                            connectPrevious = true;
                            projFactor = (float)nextLineSegment.projectionFactor(lastShapeEndedAtCoordinate);
                            Coordinate pointOnLine = nextLineSegment.project(lastShapeEndedAtCoordinate);
                            float turnAngle = this.angleBetweenSegments(previousLineSegment, nextLineSegment);
                            insideTurn = this.isInsideTurn(previousLineSegment, nextLineSegment, lastShapeEndedAtCoordinate);
                            boolean bl = isLinear = Math.abs(turnAngle - 180.0f) < 35.0f;
                            if (LOGGER.isLoggable(Level.FINER)) {
                                LOGGER.finer("projection factor " + projFactor + " winding rule:" + i.getWindingRule());
                                LOGGER.finer("segments turning to " + turnAngle);
                                LOGGER.finer("is inside the turn " + insideTurn);
                                LOGGER.finer("is linear " + isLinear);
                            }
                            if (projFactor < 1.0f || insideTurn && !isLinear) {
                                if (LOGGER.isLoggable(Level.FINER)) {
                                    LOGGER.finer("shapes will overlap");
                                    newshape.lineTo(pointOnLine.x, pointOnLine.y);
                                    Coordinate c = new Coordinate((double)prevcoords[0], (double)prevcoords[1]);
                                    LOGGER.finer("Draw line " + new LineSegment(c, pointOnLine));
                                }
                                prevcoords[0] = (float)pointOnLine.x;
                                prevcoords[1] = (float)pointOnLine.y;
                                nextLineSegment = new LineSegment(new Coordinate((double)prevcoords[0], (double)prevcoords[1]), new Coordinate((double)coords[0], (double)coords[1]));
                            }
                        }
                        if ((drapeMe = this.getShapeForSegment(nextLineSegment, previousDrapeMe)) == null) {
                            connectPrevious = false;
                            previousDrapeMe = null;
                            lastShapeEndedAtCoordinate = null;
                            previousLineSegment = null;
                            break;
                        }
                        if (((Boolean)drapeMe.getHints().getOrDefault("skip_me", false)).booleanValue()) break;
                        if (previousLineSegment != null && !connectPrevious) {
                            LOGGER.finer("connect previous " + connectPrevious + ": segments touch:" + segmentsTouch);
                        }
                        previousDrapeMe = this.drape(newshape, drapeMe, nextLineSegment.p0, nextLineSegment.angle(), lastShapeEndedAtCoordinate, connectPrevious);
                        lastShapeEndedAtCoordinate = new Coordinate((double)previousDrapeMe.getEndofShapeCoords()[0], (double)previousDrapeMe.getEndofShapeCoords()[1]);
                        connectPrevious = false;
                        break;
                    }
                    case 2: {
                        newshape.quadTo(coords[0], coords[1], coords[2], coords[3]);
                        break;
                    }
                    case 3: {
                        newshape.curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                        break;
                    }
                    case 4: {
                        newshape.closePath();
                    }
                }
                prevcoords = (float[])coords.clone();
                previousLineSegment = nextLineSegment;
                i.next();
            }
            if (!(innerShape.getGeometry() instanceof Polygon) || innerShape.getGeometry().getCoordinates().length <= 2) continue;
            newshape.moveTo(lastShapeEndedAtCoordinate.x, lastShapeEndedAtCoordinate.y);
            newshape.lineTo(innerShape.getGeometry().getCoordinates()[0].x, innerShape.getGeometry().getCoordinates()[0].y);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Created " + segments + " in " + ((double)new Date().getTime() - time) + " milliseconds");
        }
        return this.delegate.createStrokedShape(newshape);
    }

    private List<LiteShape2> unPackMultiPolygon(Shape shape) throws Exception {
        LiteShape2 liteShape = (LiteShape2)shape;
        if (MultiPolygon.class.isAssignableFrom(liteShape.getGeometry().getClass())) {
            MultiPolygon multiPolygon = (MultiPolygon)liteShape.getGeometry();
            ArrayList<LiteShape2> polygons = new ArrayList<LiteShape2>();
            for (int i = 0; i < multiPolygon.getNumGeometries(); ++i) {
                polygons.add(new LiteShape2(multiPolygon.getGeometryN(i), liteShape.getMathTransform(), null, false));
            }
            return polygons;
        }
        return Arrays.asList((LiteShape2)shape);
    }

    private boolean segmentsTouch(LineSegment seg1, LineSegment seg2) {
        if (seg1.p0.equals2D(seg2.p0) || seg1.p0.equals2D(seg2.p1)) {
            return true;
        }
        return seg1.p1.equals2D(seg2.p0) || seg1.p1.equals2D(seg2.p1);
    }

    private float angleBetweenSegments(LineSegment seg1, LineSegment seg2) {
        Coordinate tail = seg1.p0.equals2D(seg2.p0) ? seg1.p0 : seg1.p1;
        Coordinate tip1 = seg1.p0.equals2D(tail) ? seg1.p1 : seg1.p0;
        Coordinate tip2 = seg2.p0.equals2D(tail) ? seg2.p1 : seg2.p0;
        float angle = (float)Math.toDegrees(Angle.angleBetween((Coordinate)tip1, (Coordinate)tail, (Coordinate)tip2));
        return Float.isFinite(angle) ? angle : 0.0f;
    }

    private boolean isInsideTurn(LineSegment seg1, LineSegment seg2, Coordinate pt) {
        Coordinate tail = seg1.p0.equals2D(seg2.p0) ? seg1.p0 : seg1.p1;
        Coordinate tip1 = seg1.p0.equals2D(tail) ? seg1.p1 : seg1.p0;
        Coordinate tip2 = seg2.p0.equals2D(tail) ? seg2.p1 : seg2.p0;
        return gf.createPolygon(gf.createLinearRing(new Coordinate[]{tail, tip1, tip2, tail})).intersects((Geometry)gf.createPoint(pt));
    }

    private MarkAlongLiteShape getClone(AffineTransform at) {
        MarkAlongLiteShape clone = new MarkAlongLiteShape(this.wktShape.getGeometry(), at, false);
        clone.getHints().putAll(this.wktShape.getHints());
        return clone;
    }

    private MarkAlongLiteShape getShapeForSegment(LineSegment segmentToDrapOver, MarkAlongLiteShape previousDrapeMe) {
        double length = segmentToDrapOver.getLength();
        return this.getExtendedTransformedShape(length, previousDrapeMe);
    }

    private MarkAlongLiteShape getExtendedTransformedShape(double length, MarkAlongLiteShape previousDrapeMe) {
        float repetition = (float)(length / this.wktShape.getBounds2D().getWidth());
        MarkAlongLiteShape repeatedShape = this.getClone(null);
        if (previousDrapeMe != null && previousDrapeMe.getLeftOver() != null && previousDrapeMe.isClipped()) {
            repeatedShape.preAppend(previousDrapeMe.getLeftOver());
        }
        repeatedShape.setSegmentLength(length);
        AffineTransformation at = new AffineTransformation();
        double translateX = 0.0;
        int i = 1;
        while ((float)i < repetition) {
            translateX = i == 1 ? repeatedShape.getBounds().getWidth() : translateX + this.wktShape.getBounds2D().getWidth();
            at.setToTranslation(translateX, 0.0);
            Geometry geom = repeatedShape.getGeometry();
            Geometry cloneGeom = this.getClone(null).getGeometry();
            Geometry translatedGeom = at.transform(cloneGeom);
            repeatedShape.setGeometry(geom.union(translatedGeom));
            ++i;
        }
        if ((double)repeatedShape.getBounds().width != length) {
            repeatedShape = MarkAlongLine.FitOnLength(repeatedShape, length, this.scaleImit);
        }
        return repeatedShape;
    }

    public static synchronized MarkAlongLiteShape FitOnLength(MarkAlongLiteShape markAlongLiteShape, double length, double minScaleLimit) {
        double scaleX = length / (double)markAlongLiteShape.getBounds().width;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Final Shape needs " + scaleX + " Scale X for Width Correction");
        }
        if (Double.isInfinite(scaleX)) {
            return null;
        }
        AffineTransformation at = new AffineTransformation();
        at.setToScale(scaleX, 1.0);
        if (scaleX >= minScaleLimit) {
            markAlongLiteShape.setGeometry(at.transform(markAlongLiteShape.getGeometry()));
        } else {
            Geometry env = markAlongLiteShape.getGeometry().getEnvelope();
            Geometry transformedEnv = at.transform(env);
            Geometry clipped = markAlongLiteShape.getGeometry().intersection(transformedEnv);
            if (clipped == null || clipped.isEmpty()) {
                markAlongLiteShape.getHints().put("skip_me", true);
                return markAlongLiteShape;
            }
            Geometry remainingGeom = markAlongLiteShape.getGeometry().difference(transformedEnv);
            markAlongLiteShape.setGeometry(clipped);
            markAlongLiteShape.setLeftOver(remainingGeom);
            markAlongLiteShape.getHints().put("clipped", true);
        }
        return markAlongLiteShape;
    }

    private MarkAlongLiteShape drape(GeneralPath newshape, MarkAlongLiteShape wktShape, Coordinate drapeFromCoordinate, double rotationRadians, Coordinate previousShapeEndCoordinate, boolean joinWithLastSegment) {
        AffineTransformation at = new AffineTransformation();
        at.rotate(rotationRadians);
        at.translate(drapeFromCoordinate.x, drapeFromCoordinate.y);
        wktShape.setGeometry(at.transform(wktShape.getGeometry()));
        float[] coords = new float[6];
        boolean skipSegment = joinWithLastSegment;
        PathIterator i = wktShape.getPathIterator(null);
        while (!i.isDone()) {
            int type = i.currentSegment(coords);
            switch (type) {
                case 0: {
                    if (skipSegment) {
                        newshape.moveTo(previousShapeEndCoordinate.x, previousShapeEndCoordinate.y);
                        newshape.quadTo(previousShapeEndCoordinate.x, previousShapeEndCoordinate.y, (double)coords[0], (double)coords[1]);
                        skipSegment = false;
                        break;
                    }
                    newshape.moveTo(coords[0], coords[1]);
                    break;
                }
                case 1: {
                    newshape.lineTo(coords[0], coords[1]);
                    break;
                }
                case 2: {
                    newshape.quadTo(coords[0], coords[1], coords[2], coords[3]);
                    break;
                }
                case 3: {
                    newshape.curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    break;
                }
                case 4: {
                    newshape.closePath();
                }
            }
            i.next();
        }
        wktShape.getHints().put("final_coords", coords);
        return wktShape;
    }

    public double getSimplificatorFactor() {
        return this.wktShape.getBounds2D().getHeight() * (double)this.simplicationFactor;
    }

    class MarkAlongLiteShape
    extends LiteShape {
        private static final String CLIPPED = "clipped";
        private static final String FINAL_COORDS = "final_coords";
        private static final String SKIP_ME = "skip_me";
        private Map<String, Object> hints;
        private double segmentLength;
        LineSegment projectedSegment;
        Geometry leftOver;

        public MarkAlongLiteShape(Geometry geom, AffineTransform at, boolean generalize) {
            super(geom, at, generalize);
            this.hints = new HashMap<String, Object>();
            this.segmentLength = -1.0;
            this.projectedSegment = null;
            this.leftOver = null;
        }

        public Map<String, Object> getHints() {
            return this.hints;
        }

        public double getSegmentLength() {
            return this.segmentLength;
        }

        public void setSegmentLength(double segmentLength) {
            this.segmentLength = segmentLength;
        }

        public void preAppend(Geometry geometry) {
            AffineTransformation at = new AffineTransformation();
            ReferencedEnvelope env = JTS.toEnvelope((Geometry)geometry);
            at.setToTranslation(env.getWidth(), 0.0);
            Geometry tranformedTarget = at.transform(this.getGeometry());
            this.setGeometry(geometry.union(tranformedTarget));
        }

        public Geometry getLeftOver() {
            return this.leftOver;
        }

        public void setLeftOver(Geometry leftOver) {
            if (leftOver == null) {
                this.leftOver = null;
                return;
            }
            AffineTransformation at = new AffineTransformation();
            at.setToScale(1.0, 1.0);
            ReferencedEnvelope env = JTS.toEnvelope((Geometry)leftOver);
            at.setToTranslation(env.getMinX() * -1.0, 0.0);
            this.leftOver = at.transform(leftOver);
        }

        public float[] getEndofShapeCoords() {
            return (float[])this.hints.getOrDefault(FINAL_COORDS, new float[6]);
        }

        public boolean isClipped() {
            return (Boolean)this.hints.getOrDefault(CLIPPED, false);
        }

        public LineSegment getProjectedSegment() {
            return this.projectedSegment;
        }

        public void setProjectedSegment(LineSegment projectedSegment) {
            this.projectedSegment = projectedSegment;
        }
    }
}

