/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.label;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.geometry.jts.GeometryClipper;
import org.geotools.geometry.jts.LiteShape2;
import org.geotools.geometry.jts.OffsetCurveBuilder;
import org.geotools.renderer.RenderListener;
import org.geotools.renderer.VendorOptionParser;
import org.geotools.renderer.label.GlyphProcessor;
import org.geotools.renderer.label.GlyphVectorProcessor;
import org.geotools.renderer.label.LabelCacheItem;
import org.geotools.renderer.label.LabelIndex;
import org.geotools.renderer.label.LabelPainter;
import org.geotools.renderer.label.LineStringCursor;
import org.geotools.renderer.label.TextStyle2DExt;
import org.geotools.renderer.lite.LabelCache;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.renderer.style.SLDStyleFactory;
import org.geotools.renderer.style.TextStyle2D;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.util.NumberRange;
import org.geotools.util.Range;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.prep.PreparedGeometry;
import org.locationtech.jts.geom.prep.PreparedGeometryFactory;
import org.locationtech.jts.operation.linemerge.LineMerger;
import org.opengis.feature.Feature;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;

public class LabelCacheImpl
implements LabelCache {
    static final boolean DEBUG_CACHE_BOUNDS = Boolean.getBoolean("org.geotools.labelcache.showbounds");
    public static boolean DISABLE_LETTER_LEVEL_CONFLICT = Boolean.getBoolean("org.geotools.labelcache.disableLetterLevelConflict");
    static final Logger LOGGER = Logging.getLogger(LabelCacheImpl.class);
    public double DEFAULT_PRIORITY = 1000.0;
    public static final int[] DEFAULT_DISPLACEMENT_ANGLES = new int[]{0, 45, 90, 135, 180, 225, 270, 315};
    public static double MIN_CURVED_DELTA = 0.05235987755982988;
    protected Map<LabelCacheItem, LabelCacheItem> groupedLabelsLookup = new HashMap<LabelCacheItem, LabelCacheItem>();
    protected ArrayList<LabelCacheItem> labelCache = new ArrayList();
    private List<Rectangle2D> reserved = new ArrayList<Rectangle2D>();
    static final double[] RIGHT_ANCHOR_CANDIDATES = new double[]{0.0, 0.5, 0.0, 0.0, 0.0, 1.0};
    static final double[] MID_ANCHOR_CANDIDATES = new double[]{0.5, 0.5, 0.0, 0.5, 1.0, 0.5};
    static final double[] LEFT_ANCHOR_CANDIDATES = new double[]{1.0, 0.5, 1.0, 0.0, 1.0, 1.0};
    static final double[] RIGHT_UP_ANCHOR_CANDIDATES = new double[]{0.0, 0.0, 0.0, 0.5};
    static final double[] RIGHT_DOWN_ANCHOR_CANDIDATES = new double[]{0.0, 1.0, 0.0, 0.5};
    static final double[] VERTICAL_UP_ANCHOR_CANDIDATES = new double[]{0.5, 0.5, 0.5, 0.0};
    static final double[] VERTICAL_DOWN_ANCHOR_CANDIDATES = new double[]{0.5, 0.5, 0.5, 1.0};
    static final double[] HORIZONTAL_LEFT_ANCHOR_CANDIDATES = new double[]{0.5, 0.5, 1.0, 0.5};
    static final double[] HORIZONTAL_RIGHT_ANCHOR_CANDIDATES = new double[]{0.5, 0.5, 0.0, 0.5};
    static final double[] LEFT_UP_ANCHOR_CANDIDATES = new double[]{1.0, 0.0, 1.0, 0.5};
    static final double[] LEFT_DOWN_ANCHOR_CANDIDATES = new double[]{1.0, 1.0, 1.0, 0.5};
    protected LabelRenderingMode labelRenderingMode = LabelRenderingMode.STRING;
    protected SLDStyleFactory styleFactory = new SLDStyleFactory();
    boolean stop = false;
    Set<String> enabledLayers = new HashSet<String>();
    Set<String> activeLayers = new HashSet<String>();
    LineLengthComparator lineLengthComparator = new LineLengthComparator();
    GeometryFactory gf = new GeometryFactory();
    GeometryClipper clipper;
    private boolean needsOrdering = false;
    private VendorOptionParser voParser = new VendorOptionParser();
    private List<RenderListener> renderListeners = new CopyOnWriteArrayList<RenderListener>();
    private BiFunction<Graphics2D, LabelRenderingMode, LabelPainter> constructPainter = LabelPainter::new;

    @Override
    public void enableLayer(String layerId) {
        this.needsOrdering = true;
        this.enabledLayers.add(layerId);
    }

    public LabelRenderingMode getLabelRenderingMode() {
        return this.labelRenderingMode;
    }

    public void setLabelRenderingMode(LabelRenderingMode mode) {
        this.labelRenderingMode = mode;
    }

    public void setConstructPainter(BiFunction<Graphics2D, LabelRenderingMode, LabelPainter> constructPainter) {
        this.constructPainter = constructPainter;
    }

    @Override
    public void stop() {
        this.stop = true;
        this.activeLayers.clear();
    }

    @Override
    public void start() {
        this.stop = false;
    }

    @Override
    public void clear() {
        if (!this.activeLayers.isEmpty()) {
            throw new IllegalStateException(this.activeLayers + " are layers that started rendering but have not completed, stop() or endLayer() must be called before clear is called");
        }
        this.needsOrdering = true;
        this.labelCache.clear();
        this.groupedLabelsLookup.clear();
        this.enabledLayers.clear();
    }

    @Override
    public void clear(String layerId) {
        if (this.activeLayers.contains(layerId)) {
            throw new IllegalStateException(layerId + " is still rendering, end the layer before calling clear.");
        }
        this.needsOrdering = true;
        Iterator<LabelCacheItem> iter = this.labelCache.iterator();
        while (iter.hasNext()) {
            LabelCacheItem item = iter.next();
            if (!item.getLayerIds().contains(layerId)) continue;
            iter.remove();
            this.groupedLabelsLookup.remove(item);
        }
        this.enabledLayers.remove(layerId);
    }

    @Override
    public void disableLayer(String layerId) {
        this.needsOrdering = true;
        this.enabledLayers.remove(layerId);
    }

    @Override
    public void startLayer(String layerId) {
        this.enabledLayers.add(layerId);
        this.activeLayers.add(layerId);
    }

    public double getPriority(TextSymbolizer symbolizer, Feature feature) {
        if (symbolizer.getPriority() == null) {
            return this.DEFAULT_PRIORITY;
        }
        try {
            Double number = (Double)symbolizer.getPriority().evaluate((Object)feature, Double.class);
            return number;
        }
        catch (Exception e) {
            return this.DEFAULT_PRIORITY;
        }
    }

    public void put(String layerId, TextSymbolizer symbolizer, Feature feature, LiteShape2 shape, NumberRange scaleRange) {
        this.needsOrdering = true;
        try {
            if (symbolizer.getLabel() == null) {
                return;
            }
            String label = (String)symbolizer.getLabel().evaluate((Object)feature, String.class);
            if (label == null) {
                return;
            }
            if (label.length() == 0) {
                return;
            }
            double priorityValue = this.getPriority(symbolizer, feature);
            boolean group = this.voParser.getBooleanOption((Symbolizer)symbolizer, "group", false);
            LabelCacheItem item = this.buildLabelCacheItem(layerId, symbolizer, feature, shape, scaleRange, label, priorityValue);
            if (!group) {
                this.labelCache.add(item);
            } else {
                LabelCacheItem groupItem = this.groupedLabelsLookup.get(item);
                if (groupItem == null) {
                    this.labelCache.add(item);
                    this.groupedLabelsLookup.put(item, item);
                } else {
                    Expression priority = symbolizer.getPriority();
                    if (priority != null && !(priority instanceof Literal)) {
                        groupItem.setPriority(groupItem.getPriority() + priorityValue);
                    }
                    groupItem.getGeoms().add(shape.getGeometry());
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error adding label to the label cache", e);
        }
    }

    @Override
    public void put(Rectangle2D area) {
        this.reserved.add(area);
    }

    private LabelCacheItem buildLabelCacheItem(String layerId, TextSymbolizer symbolizer, Feature feature, LiteShape2 shape, NumberRange scaleRange, String label, double priorityValue) {
        TextStyle2D textStyle = (TextStyle2D)this.styleFactory.createStyle(feature, (Symbolizer)symbolizer, (Range)scaleRange);
        LabelCacheItem item = new LabelCacheItem(layerId, textStyle, shape, label, symbolizer);
        item.setPriority(priorityValue);
        item.setSpaceAround(this.voParser.getIntOption((Symbolizer)symbolizer, "spaceAround", 0));
        item.setMaxDisplacement(this.voParser.getIntOption((Symbolizer)symbolizer, "maxDisplacement", 0));
        item.setMinGroupDistance(this.voParser.getIntOption((Symbolizer)symbolizer, "minGroupDistance", -1));
        item.setRepeat(this.voParser.getIntOption((Symbolizer)symbolizer, "repeat", 0));
        item.setLabelAllGroup(this.voParser.getBooleanOption((Symbolizer)symbolizer, "labelAllGroup", false));
        item.setRemoveGroupOverlaps(this.voParser.getBooleanOption((Symbolizer)symbolizer, "removeOverlaps", false));
        item.setAllowOverruns(this.voParser.getBooleanOption((Symbolizer)symbolizer, "allowOverruns", true));
        item.setFollowLineEnabled(this.voParser.getBooleanOption((Symbolizer)symbolizer, "followLine", false));
        double maxAngleDelta = this.voParser.getDoubleOption((Symbolizer)symbolizer, "maxAngleDelta", 22.5);
        item.setMaxAngleDelta(Math.toRadians(maxAngleDelta));
        if (!item.isFollowLineEnabled()) {
            item.setAutoWrap(this.voParser.getIntOption((Symbolizer)symbolizer, "autoWrap", 0));
        } else {
            LOGGER.log(Level.FINE, "Disabling auto-wrap, it's not supported along with followLine yet");
            item.setAutoWrap(0);
        }
        item.setForceLeftToRightEnabled(this.voParser.getBooleanOption((Symbolizer)symbolizer, "forceLeftToRight", true));
        item.setConflictResolutionEnabled(this.voParser.getBooleanOption((Symbolizer)symbolizer, "conflictResolution", true));
        item.setGoodnessOfFit(this.voParser.getDoubleOption((Symbolizer)symbolizer, "goodnessOfFit", 0.5));
        item.setPolygonAlign((TextSymbolizer.PolygonAlignOptions)this.voParser.getEnumOption((Symbolizer)symbolizer, "polygonAlign", TextSymbolizer.DEFAULT_POLYGONALIGN));
        item.setGraphicsResize((LabelCacheItem.GraphicResize)this.voParser.getEnumOption((Symbolizer)symbolizer, "graphic-resize", LabelCacheItem.GraphicResize.NONE));
        item.setGraphicMargin(this.voParser.getGraphicMargin((Symbolizer)symbolizer, "graphic-margin"));
        item.setPartialsEnabled(this.voParser.getBooleanOption((Symbolizer)symbolizer, "partials", false));
        item.setTextUnderlined(this.voParser.getBooleanOption((Symbolizer)symbolizer, "underlineText", false));
        item.setTextStrikethrough(this.voParser.getBooleanOption((Symbolizer)symbolizer, "strikethroughText", false));
        item.setWordSpacing(this.voParser.getDoubleOption((Symbolizer)symbolizer, "wordSpacing", 0.0));
        item.setDisplacementAngles(this.voParser.getDisplacementAngles((Symbolizer)symbolizer, "displacementMode"));
        item.setFontShrinkSizeMin(this.voParser.getIntOption((Symbolizer)symbolizer, "fontShrinkSizeMin", 0));
        item.setGraphicPlacement((TextSymbolizer.GraphicPlacement)this.voParser.getEnumOption((Symbolizer)symbolizer, "graphicPlacement", TextSymbolizer.GraphicPlacement.LABEL));
        return item;
    }

    @Override
    public void endLayer(String layerId, Graphics2D graphics, Rectangle displayArea) {
        this.activeLayers.remove(layerId);
    }

    @Override
    public List<LabelCacheItem> orderedLabels() {
        List<LabelCacheItem> al = this.getActiveLabels();
        Collections.sort(al);
        Collections.reverse(al);
        return al;
    }

    public List<LabelCacheItem> getActiveLabels() {
        ArrayList<LabelCacheItem> al = new ArrayList<LabelCacheItem>();
        for (LabelCacheItem item : this.labelCache) {
            if (!this.isActive(item.getLayerIds())) continue;
            al.add(item);
        }
        return al;
    }

    private boolean isActive(Set<String> layerIds) {
        for (String layerName : layerIds) {
            if (!this.enabledLayers.contains(layerName)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(Graphics2D graphics, Rectangle displayArea) {
        Object antialiasing = graphics.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Object textAntialiasing = graphics.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
        try {
            if (this.labelRenderingMode != LabelRenderingMode.STRING && antialiasing == RenderingHints.VALUE_ANTIALIAS_OFF && textAntialiasing == RenderingHints.VALUE_TEXT_ANTIALIAS_ON) {
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            this.paintLabels(graphics, displayArea);
        }
        finally {
            if (antialiasing != null) {
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antialiasing);
            }
        }
    }

    void paintLabels(Graphics2D graphics, Rectangle displayArea) {
        if (!this.activeLayers.isEmpty()) {
            throw new IllegalStateException(this.activeLayers + " are layers that started rendering but have not completed, stop() or endLayer() must be called before end() is called");
        }
        LabelIndex glyphs = new LabelIndex();
        glyphs.reserveArea(this.reserved);
        int paintedLineLabels = 0;
        displayArea = new Rectangle(displayArea);
        --displayArea.width;
        --displayArea.height;
        this.clipper = new GeometryClipper(new Envelope(displayArea.getMinX(), displayArea.getMaxX(), displayArea.getMinY(), displayArea.getMaxY()));
        List<LabelCacheItem> items = this.needsOrdering ? this.orderedLabels() : this.getActiveLabels();
        LabelPainter painter = this.constructPainter.apply(graphics, this.labelRenderingMode);
        for (LabelCacheItem labelItem : items) {
            if (this.stop) {
                return;
            }
            paintedLineLabels = this.paintLabel(graphics, displayArea, glyphs, paintedLineLabels, painter, labelItem);
        }
        LOGGER.log(Level.FINE, "TOTAL LINE LABELS : {0}", items.size());
        LOGGER.log(Level.FINE, "PAINTED LINE LABELS : {0}", paintedLineLabels);
        LOGGER.log(Level.FINE, "REMAINING LINE LABELS : {0}", items.size() - paintedLineLabels);
    }

    int paintLabel(Graphics2D graphics, Rectangle displayArea, LabelIndex glyphs, int paintedLineLabels, LabelPainter painter, LabelCacheItem labelItem) {
        block9: {
            try {
                painter.setLabel(labelItem);
                AffineTransform tempTransform = new AffineTransform();
                Geometry geom = labelItem.getGeometry();
                if (geom instanceof Point || geom instanceof MultiPoint) {
                    this.paintPointLabel(painter, tempTransform, displayArea, glyphs);
                    break block9;
                }
                if (geom instanceof LineString && !(geom instanceof LinearRing) || geom instanceof MultiLineString) {
                    boolean painted = !DISABLE_LETTER_LEVEL_CONFLICT ? this.paintLineLabelsWithLetterConflict(painter, tempTransform, displayArea, glyphs) : this.paintLineLabels(painter, tempTransform, displayArea, glyphs);
                    if (painted) {
                        ++paintedLineLabels;
                    }
                    break block9;
                }
                if (!(geom instanceof Polygon) && !(geom instanceof MultiPolygon) && !(geom instanceof LinearRing)) break block9;
                if (labelItem.getTextStyle().isPointPlacement() && !labelItem.isFollowLineEnabled()) {
                    this.paintPolygonLabel(painter, tempTransform, displayArea, glyphs);
                } else {
                    this.paintPolygonBorder(painter, tempTransform, displayArea, glyphs);
                }
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Failure while painting labels", e);
                }
                for (RenderListener listener : this.renderListeners) {
                    listener.errorOccurred(e);
                }
            }
        }
        return paintedLineLabels;
    }

    private Envelope toEnvelope(Rectangle2D bounds) {
        return new Envelope(bounds.getMinX(), bounds.getMaxX(), bounds.getMinY(), bounds.getMaxY());
    }

    private double goodnessOfFit(LabelPainter painter, AffineTransform transform, PreparedGeometry representativeGeom) {
        if (representativeGeom.getGeometry() instanceof Point) {
            return 1.0;
        }
        if (representativeGeom.getGeometry() instanceof LineString) {
            return 1.0;
        }
        if (representativeGeom.getGeometry() instanceof Polygon) {
            Rectangle2D glyphBounds = painter.getFullLabelBounds();
            try {
                int count = 0;
                int n = 10;
                Coordinate c = new Coordinate();
                Point pp = this.gf.createPoint(c);
                double[] gp = new double[2];
                double[] tp = new double[2];
                for (int i = 1; i < painter.getLineCount() + 1; ++i) {
                    gp[1] = glyphBounds.getY() + glyphBounds.getHeight() * ((double)i / (double)(painter.getLineCount() + 1));
                    for (int j = 1; j < n + 1; ++j) {
                        gp[0] = glyphBounds.getX() + glyphBounds.getWidth() * ((double)j / (double)(n + 1));
                        transform.transform(gp, 0, tp, 0, 1);
                        c.x = tp[0];
                        c.y = tp[1];
                        pp.geometryChanged();
                        if (!representativeGeom.contains((Geometry)pp)) continue;
                        ++count;
                    }
                }
                return (double)count / (double)(n * painter.getLineCount());
            }
            catch (Exception e) {
                Geometry g = representativeGeom.getGeometry();
                g.geometryChanged();
                Envelope ePoly = g.getEnvelopeInternal();
                Envelope eglyph = this.toEnvelope(transform.createTransformedShape(glyphBounds).getBounds2D());
                Envelope inter = this.intersection(ePoly, eglyph);
                if (inter != null) {
                    return inter.getWidth() * inter.getHeight() / (eglyph.getWidth() * eglyph.getHeight());
                }
                return 0.0;
            }
        }
        return 0.0;
    }

    private boolean paintLineLabelsWithLetterConflict(LabelPainter painter, AffineTransform originalTransform, Rectangle displayArea, LabelIndex paintedBounds) throws Exception {
        LabelCacheItem labelItem = painter.getLabel();
        List<LineString> lines = this.getLineSetRepresentativeLocation(labelItem.getGeoms(), displayArea, labelItem.removeGroupOverlaps(), labelItem.isPartialsEnabled());
        if (lines == null || lines.isEmpty()) {
            return false;
        }
        if (!labelItem.labelAllGroup() && lines.size() > 1) {
            lines = Collections.singletonList(lines.get(0));
        }
        Rectangle2D textBounds = painter.getFullLabelBounds();
        double step = painter.getLineHeight() > 8.0 ? painter.getLineHeight() : 8.0;
        int labelDistance = labelItem.getRepeat();
        if (labelDistance > 0 && labelItem.isFollowLineEnabled()) {
            labelDistance = (int)((double)labelDistance + textBounds.getWidth());
        }
        LabelIndex groupLabels = new LabelIndex();
        double labelOffset = labelItem.getMaxDisplacement();
        boolean allowOverruns = labelItem.allowOverruns();
        double maxAngleDelta = labelItem.getMaxAngleDelta();
        int perpendicularOffset = painter.getLabel().getTextStyle().getPerpendicularOffset();
        OffsetCurveBuilder offsetBuilder = null;
        if (perpendicularOffset != 0) {
            offsetBuilder = new OffsetCurveBuilder((double)perpendicularOffset, 2);
        }
        int labelCount = 0;
        for (LineString line : lines) {
            if (labelItem.isFollowLineEnabled()) {
                line = this.decimateLineString(line, step);
                if (offsetBuilder != null) {
                    line = (LineString)offsetBuilder.offset((Geometry)line);
                }
            }
            double lineStringLength = line.getLength();
            if ((!allowOverruns || labelItem.isFollowLineEnabled()) && line.getLength() < textBounds.getWidth()) {
                return labelCount > 0;
            }
            double[] labelPositions = this.buildLabelPositions(labelDistance, lineStringLength);
            LineStringCursor cursor = new LineStringCursor(line);
            AffineTransform tx = new AffineTransform();
            boolean mightSkipLastLabel = line.isClosed() && lineStringLength - (double)((labelPositions.length - 1) * labelDistance) < (double)labelDistance;
            for (int i = 0; i < labelPositions.length; ++i) {
                cursor.moveTo(labelPositions[i]);
                Coordinate centroid = cursor.getCurrentPosition();
                double currOffset = 0.0;
                boolean painted = false;
                while (Math.abs(currOffset) <= labelOffset * 2.0 && !painted) {
                    tx.setToIdentity();
                    double maxAngleChange = 0.0;
                    boolean curved = false;
                    double startOrdinate = cursor.getCurrentOrdinate() - textBounds.getWidth() / 2.0;
                    double endOrdinate = cursor.getCurrentOrdinate() + textBounds.getWidth() / 2.0;
                    if (labelItem.followLineEnabled) {
                        maxAngleChange = cursor.getMaxAngleChange(startOrdinate, endOrdinate);
                        this.setupLineTransform(painter, cursor, centroid, tx, true);
                        curved = maxAngleChange >= MIN_CURVED_DELTA;
                    } else {
                        this.setupLineTransform(painter, cursor, centroid, tx, false);
                    }
                    GlyphVectorProcessor glyphVectorProcessor = null;
                    if (curved) {
                        LineStringCursor oldCursor = new LineStringCursor(cursor);
                        glyphVectorProcessor = new GlyphVectorProcessor.Curved(painter, oldCursor);
                    } else {
                        glyphVectorProcessor = new GlyphVectorProcessor.Straight(painter, tx);
                    }
                    boolean collision = glyphVectorProcessor.process(new GlyphProcessor.ConflictDetector(painter, displayArea, paintedBounds, groupLabels), true);
                    if (!collision) {
                        if (labelItem.isFollowLineEnabled()) {
                            if (startOrdinate > 0.0 && endOrdinate <= cursor.getLineStringLength() && maxAngleChange <= maxAngleDelta) {
                                double maxDistance = Math.min(painter.getLineHeight() / 2.0, 7.0);
                                if (maxAngleChange == 0.0 || cursor.getMaxDistanceFromStraightLine(startOrdinate, endOrdinate) < maxDistance) {
                                    painter.paintStraightLabel(tx);
                                } else {
                                    painter.paintCurvedLabel(cursor);
                                }
                                painted = true;
                            }
                        } else if (allowOverruns || startOrdinate > 0.0 && endOrdinate <= cursor.getLineStringLength()) {
                            painter.paintStraightLabel(tx);
                            painted = true;
                        }
                    }
                    if (painted) {
                        ++labelCount;
                        if (labelItem.isConflictResolutionEnabled()) {
                            if (DEBUG_CACHE_BOUNDS) {
                                painter.graphics.setStroke(new BasicStroke());
                                painter.graphics.setColor(Color.RED);
                                glyphVectorProcessor.process(new GlyphProcessor.BoundsPainter(painter));
                            }
                            glyphVectorProcessor.process(new GlyphProcessor.IndexAdder(painter, paintedBounds));
                        }
                        if (i != labelPositions.length - 2 || !painted || !mightSkipLastLabel) continue;
                        ++i;
                        continue;
                    }
                    currOffset = this.nextOffset(currOffset, step);
                    cursor.moveRelative(currOffset);
                    cursor.getCurrentPosition(centroid);
                }
            }
        }
        return labelCount > 0;
    }

    private double nextOffset(double currOffset, double step) {
        double signum = Math.signum(currOffset);
        if (signum == 0.0) {
            return step;
        }
        return -1.0 * signum * (Math.abs(currOffset) + step);
    }

    private boolean paintLineLabels(LabelPainter painter, AffineTransform originalTransform, Rectangle displayArea, LabelIndex paintedBounds) throws Exception {
        LabelCacheItem labelItem = painter.getLabel();
        List<LineString> lines = this.getLineSetRepresentativeLocation(labelItem.getGeoms(), displayArea, labelItem.removeGroupOverlaps(), labelItem.isPartialsEnabled());
        if (lines == null || lines.isEmpty()) {
            return false;
        }
        if (!labelItem.labelAllGroup() && lines.size() > 1) {
            lines = Collections.singletonList(lines.get(0));
        }
        Rectangle2D textBounds = painter.getFullLabelBounds();
        double step = painter.getAscent() > 2.0 ? painter.getAscent() : 2.0;
        int space = labelItem.getSpaceAround();
        int haloRadius = Math.round(labelItem.getTextStyle().getHaloFill() != null ? labelItem.getTextStyle().getHaloRadius() : 0.0f);
        int extraSpace = space + haloRadius;
        int labelDistance = labelItem.getRepeat();
        int minDistance = labelItem.getMinGroupDistance();
        LabelIndex groupLabels = new LabelIndex();
        double labelOffset = labelItem.getMaxDisplacement();
        boolean allowOverruns = labelItem.allowOverruns();
        double maxAngleDelta = labelItem.getMaxAngleDelta();
        int labelCount = 0;
        int perpendicularOffset = painter.getLabel().getTextStyle().getPerpendicularOffset();
        OffsetCurveBuilder offsetBuilder = null;
        if (perpendicularOffset != 0) {
            offsetBuilder = new OffsetCurveBuilder((double)perpendicularOffset, 2);
        }
        for (LineString line : lines) {
            if (labelItem.isFollowLineEnabled()) {
                line = this.decimateLineString(line, step);
                if (offsetBuilder != null) {
                    line = (LineString)offsetBuilder.offset((Geometry)line);
                }
            }
            double lineStringLength = line.getLength();
            if ((!allowOverruns || labelItem.isFollowLineEnabled()) && line.getLength() < textBounds.getWidth()) {
                return labelCount > 0;
            }
            double[] labelPositions = this.buildLabelPositions(labelDistance, lineStringLength);
            LineStringCursor cursor = new LineStringCursor(line);
            AffineTransform tx = new AffineTransform();
            boolean mightSkipLastLabel = line.isClosed() && lineStringLength - (double)((labelPositions.length - 1) * labelDistance) < (double)labelDistance;
            for (int i = 0; i < labelPositions.length; ++i) {
                cursor.moveTo(labelPositions[i]);
                Coordinate centroid = cursor.getCurrentPosition();
                double currOffset = 0.0;
                boolean painted = false;
                while (Math.abs(currOffset) <= labelOffset * 2.0 && !painted) {
                    Rectangle2D labelEnvelope;
                    tx.setToIdentity();
                    double maxAngleChange = 0.0;
                    double startOrdinate = cursor.getCurrentOrdinate() - textBounds.getWidth() / 2.0;
                    double endOrdinate = cursor.getCurrentOrdinate() + textBounds.getWidth() / 2.0;
                    if (labelItem.followLineEnabled) {
                        maxAngleChange = cursor.getMaxAngleChange(startOrdinate, endOrdinate);
                        if (maxAngleChange < MIN_CURVED_DELTA) {
                            this.setupLineTransform(painter, cursor, centroid, tx, true);
                            labelEnvelope = tx.createTransformedShape(textBounds).getBounds2D();
                        } else {
                            labelEnvelope = this.getCurvedLabelBounds(cursor, startOrdinate, endOrdinate, textBounds.getHeight() / 2.0);
                        }
                    } else {
                        this.setupLineTransform(painter, cursor, centroid, tx, false);
                        labelEnvelope = tx.createTransformedShape(textBounds).getBounds2D();
                    }
                    if (!(!displayArea.contains(labelEnvelope) && !labelItem.isPartialsEnabled() || labelItem.isConflictResolutionEnabled() && paintedBounds.labelsWithinDistance(labelEnvelope, extraSpace) || groupLabels.labelsWithinDistance(labelEnvelope, minDistance))) {
                        if (labelItem.isFollowLineEnabled()) {
                            if (startOrdinate > 0.0 && endOrdinate <= cursor.getLineStringLength() && maxAngleChange < maxAngleDelta) {
                                if (maxAngleChange == 0.0 || cursor.getMaxDistanceFromStraightLine(startOrdinate, endOrdinate) < painter.getLineHeight() / 2.0) {
                                    painter.paintStraightLabel(tx);
                                } else {
                                    painter.paintCurvedLabel(cursor);
                                }
                                painted = true;
                            }
                        } else if (allowOverruns || startOrdinate > 0.0 && endOrdinate <= cursor.getLineStringLength()) {
                            painter.paintStraightLabel(tx);
                            painted = true;
                        }
                    }
                    if (painted) {
                        ++labelCount;
                        groupLabels.addLabel(labelItem, labelEnvelope);
                        if (labelItem.isConflictResolutionEnabled()) {
                            if (DEBUG_CACHE_BOUNDS) {
                                painter.graphics.setStroke(new BasicStroke());
                                painter.graphics.setColor(Color.RED);
                                painter.graphics.draw(labelEnvelope);
                            }
                            paintedBounds.addLabel(labelItem, labelEnvelope);
                        }
                        if (i != labelPositions.length - 2 || !painted || !mightSkipLastLabel) continue;
                        ++i;
                        continue;
                    }
                    double signum = Math.signum(currOffset);
                    currOffset = signum == 0.0 ? step : -1.0 * signum * (Math.abs(currOffset) + step);
                    cursor.moveRelative(currOffset);
                    cursor.getCurrentPosition(centroid);
                }
            }
        }
        return labelCount > 0;
    }

    private double[] buildLabelPositions(int labelDistance, double lineStringLength) {
        double[] labelPositions;
        if (labelDistance > 0 && (double)labelDistance < lineStringLength / 2.0) {
            int positionCount = (int)(lineStringLength / 2.0 / (double)labelDistance) * 2 + 1;
            labelPositions = new double[positionCount];
            labelPositions[0] = lineStringLength / 2.0;
            double offset = labelDistance;
            for (int i = 1; i < labelPositions.length; ++i) {
                labelPositions[i] = labelPositions[i - 1] + offset;
                offset = this.nextOffset(offset, labelDistance);
            }
        } else {
            labelPositions = new double[]{lineStringLength / 2.0};
        }
        return labelPositions;
    }

    private Rectangle2D getCurvedLabelBounds(LineStringCursor cursor, double startOrdinate, double endOrdinate, double bufferSize) {
        LineString cut = cursor.getSubLineString(startOrdinate, endOrdinate);
        Envelope e = cut.getEnvelopeInternal();
        e.expandBy(bufferSize);
        return new Rectangle2D.Double(e.getMinX(), e.getMinY(), e.getWidth(), e.getHeight());
    }

    private LineString decimateLineString(LineString line, double step) {
        Coordinate[] inputCoordinates = line.getCoordinates();
        ArrayList<Coordinate> simplified = new ArrayList<Coordinate>();
        Coordinate prev = inputCoordinates[0];
        simplified.add(prev);
        for (int i = 1; i < inputCoordinates.length - 1; ++i) {
            Coordinate curr = inputCoordinates[i];
            if (!(Math.abs(curr.x - prev.x) > step) && !(Math.abs(curr.y - prev.y) > step)) continue;
            simplified.add(curr);
            prev = curr;
        }
        if (line instanceof LinearRing) {
            while (simplified.size() < 3) {
                simplified.add(prev);
            }
        }
        simplified.add(inputCoordinates[inputCoordinates.length - 1]);
        Coordinate[] newCoords = simplified.toArray(new Coordinate[simplified.size()]);
        if (line instanceof LinearRing) {
            return line.getFactory().createLinearRing(newCoords);
        }
        return line.getFactory().createLineString(newCoords);
    }

    private void setupPointTransform(AffineTransform tempTransform, Point centroid, TextStyle2D textStyle, LabelPainter painter) {
        tempTransform.translate(centroid.getX(), centroid.getY());
        double rotation = textStyle.getRotation();
        if (Double.isNaN(rotation) || Double.isInfinite(rotation)) {
            rotation = 0.0;
        }
        tempTransform.rotate(rotation);
        Rectangle2D textBounds = painter.getLabelBounds();
        double displacementX = textStyle.getAnchorX() * -textBounds.getWidth() + textStyle.getDisplacementX();
        double displacementY = textStyle.getAnchorY() * textBounds.getHeight() - textStyle.getDisplacementY() - textBounds.getHeight() + (painter.lines.size() == 1 ? painter.getLineHeight() : painter.getLineHeightForAnchorY(textStyle.getAnchorY()));
        tempTransform.translate(displacementX, displacementY);
    }

    private void setupLineTransform(LabelPainter painter, LineStringCursor cursor, Coordinate centroid, AffineTransform tempTransform, boolean followLine) {
        double rotation;
        tempTransform.translate(centroid.x, centroid.y);
        TextStyle2D textStyle = painter.getLabel().getTextStyle();
        double anchorX = textStyle.getAnchorX();
        double anchorY = textStyle.getAnchorY();
        double displacementY = 0.0;
        Rectangle2D textBounds = painter.getLabelBounds();
        if (textStyle.isPointPlacement() && !followLine) {
            rotation = textStyle.getRotation();
        } else {
            rotation = painter.getLabel().isForceLeftToRightEnabled() ? cursor.getLabelOrientation() : cursor.getCurrentAngle();
            int perpendicularOffset = followLine ? 0 : textStyle.getPerpendicularOffset();
            displacementY -= (double)perpendicularOffset + (double)(painter.getLineCount() - 1) * (textBounds.getHeight() / (double)painter.getLineCount());
            anchorX = 0.5;
            anchorY = painter.getLinePlacementYAnchor();
        }
        double displacementX = anchorX * -textBounds.getWidth() + textStyle.getDisplacementX();
        displacementY += anchorY * textBounds.getHeight() - textStyle.getDisplacementY();
        if (Double.isNaN(rotation) || Double.isInfinite(rotation)) {
            rotation = 0.0;
        }
        tempTransform.rotate(rotation);
        tempTransform.translate(displacementX, displacementY);
    }

    private boolean paintPointLabel(LabelPainter painter, AffineTransform tempTransform, Rectangle displayArea, LabelIndex glyphs) throws Exception {
        int startAngle;
        LabelCacheItem labelItem = painter.getLabel();
        Point point = this.getPointSetRepresentativeLocation(labelItem.getGeoms(), displayArea, labelItem.isPartialsEnabled());
        if (point == null) {
            return false;
        }
        AffineTransform tx = new AffineTransform(tempTransform);
        TextStyle2D ts = labelItem.getTextStyle();
        if (this.paintPointLabelInternal(painter, tx, displayArea, glyphs, labelItem, point, ts)) {
            return true;
        }
        if (labelItem.maxDisplacement <= 0) {
            return false;
        }
        int[] displacementAngles = labelItem.getDisplacementAngles();
        double step = painter.getAscent() > 2.0 ? painter.getAscent() : 2.0;
        TextStyle2D cloned = new TextStyle2D(ts);
        int angle = startAngle = this.getClosestStandardAngle(ts.getDisplacementX(), ts.getDisplacementY());
        for (double radius = Math.sqrt(ts.getDisplacementX() * ts.getDisplacementX() + ts.getDisplacementY() * ts.getDisplacementY()); radius <= (double)labelItem.maxDisplacement; radius += step) {
            if (displacementAngles == null) {
                for (int offset = 45; offset <= 360; offset += 45) {
                    double dx = radius * Math.cos(Math.toRadians(angle));
                    double dy = radius * Math.sin(Math.toRadians(angle));
                    int normAngle = angle % 360;
                    if (normAngle < 0) {
                        normAngle = 360 + normAngle;
                    }
                    double[] anchorPointCandidates = normAngle < 90 || normAngle > 270 ? RIGHT_ANCHOR_CANDIDATES : (normAngle > 90 && normAngle < 270 ? LEFT_ANCHOR_CANDIDATES : MID_ANCHOR_CANDIDATES);
                    for (int i = 0; i < anchorPointCandidates.length; i += 2) {
                        double ax = anchorPointCandidates[i];
                        double ay = anchorPointCandidates[i + 1];
                        cloned.setAnchorX(ax);
                        cloned.setAnchorY(ay);
                        cloned.setDisplacementX(dx);
                        cloned.setDisplacementY(dy);
                        tx = new AffineTransform(tempTransform);
                        if (!this.paintPointLabelInternal(painter, tx, displayArea, glyphs, labelItem, point, cloned)) continue;
                        return true;
                    }
                    if (angle <= startAngle) {
                        angle += offset;
                        continue;
                    }
                    angle -= offset;
                }
                continue;
            }
            int[] nArray = displacementAngles;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int offset;
                angle = offset = nArray[i];
                double dx = radius * Math.cos(Math.toRadians(angle));
                double dy = radius * Math.sin(Math.toRadians(angle));
                double[] anchorPointCandidates = new double[]{0.5, 0.5};
                if (angle == TextSymbolizer.DisplacementMode.NE.getAngle()) {
                    anchorPointCandidates = RIGHT_UP_ANCHOR_CANDIDATES;
                } else if (angle == TextSymbolizer.DisplacementMode.SE.getAngle()) {
                    anchorPointCandidates = RIGHT_DOWN_ANCHOR_CANDIDATES;
                } else if (angle == TextSymbolizer.DisplacementMode.N.getAngle()) {
                    anchorPointCandidates = VERTICAL_UP_ANCHOR_CANDIDATES;
                } else if (angle == TextSymbolizer.DisplacementMode.S.getAngle()) {
                    anchorPointCandidates = VERTICAL_DOWN_ANCHOR_CANDIDATES;
                } else if (angle == TextSymbolizer.DisplacementMode.NW.getAngle()) {
                    anchorPointCandidates = LEFT_UP_ANCHOR_CANDIDATES;
                } else if (angle == TextSymbolizer.DisplacementMode.SW.getAngle()) {
                    anchorPointCandidates = LEFT_DOWN_ANCHOR_CANDIDATES;
                } else if (angle == TextSymbolizer.DisplacementMode.E.getAngle()) {
                    anchorPointCandidates = HORIZONTAL_LEFT_ANCHOR_CANDIDATES;
                } else if (angle == TextSymbolizer.DisplacementMode.W.getAngle()) {
                    anchorPointCandidates = HORIZONTAL_RIGHT_ANCHOR_CANDIDATES;
                }
                for (int i2 = 0; i2 < anchorPointCandidates.length; i2 += 2) {
                    double ax = anchorPointCandidates[i2];
                    double ay = anchorPointCandidates[i2 + 1];
                    cloned.setAnchorX(ax);
                    cloned.setAnchorY(ay);
                    cloned.setDisplacementX(dx);
                    cloned.setDisplacementY(dy);
                    tx = new AffineTransform(tempTransform);
                    if (!this.paintPointLabelInternal(painter, tx, displayArea, glyphs, labelItem, point, cloned)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    int getClosestStandardAngle(double x, double y) {
        double angle = Math.toDegrees(Math.atan2(y, x));
        return (int)Math.round(angle / 45.0) * 45;
    }

    private boolean paintPointLabelInternal(LabelPainter painter, AffineTransform tempTransform, Rectangle displayArea, LabelIndex glyphs, LabelCacheItem labelItem, Point point, TextStyle2D textStyle) throws Exception {
        this.setupPointTransform(tempTransform, point, textStyle, painter);
        Rectangle2D transformed = tempTransform.createTransformedShape(painter.getFullLabelBounds()).getBounds2D();
        if (!displayArea.contains(transformed) && !labelItem.isPartialsEnabled() || labelItem.isConflictResolutionEnabled() && glyphs.labelsWithinDistance(transformed, labelItem.getSpaceAround())) {
            return false;
        }
        painter.paintStraightLabel(tempTransform, point.getCoordinate());
        if (DEBUG_CACHE_BOUNDS) {
            painter.graphics.setStroke(new BasicStroke());
            painter.graphics.setColor(Color.RED);
            painter.graphics.draw(transformed);
        }
        if (labelItem.isConflictResolutionEnabled()) {
            glyphs.addLabel(labelItem, transformed);
        }
        return true;
    }

    private boolean paintPolygonBorder(LabelPainter painter, AffineTransform tempTransform, Rectangle displayArea, LabelIndex glyphs) throws Exception {
        Geometry geometry = painter.getLabel().getGeometry();
        if (painter.getLabel().getTextStyle().getPerpendicularOffset() != 0) {
            geometry.normalize();
        }
        ArrayList lines = new ArrayList();
        geometry.apply(g -> {
            if (g instanceof LineString) {
                lines.add((LineString)g);
            }
        });
        boolean painted = false;
        LabelCacheItem item = painter.getLabel();
        LabelCacheItem itemCopy = new LabelCacheItem(item);
        for (LineString ls : lines) {
            itemCopy.geoms.clear();
            itemCopy.geoms.add((Geometry)ls);
            painter.setLabel(itemCopy);
            if (!DISABLE_LETTER_LEVEL_CONFLICT) {
                painted |= this.paintLineLabelsWithLetterConflict(painter, tempTransform, displayArea, glyphs);
                continue;
            }
            painted |= this.paintLineLabels(painter, tempTransform, displayArea, glyphs);
        }
        return painted;
    }

    private boolean paintPolygonLabel(LabelPainter painter, AffineTransform tempTransform, Rectangle displayArea, LabelIndex glyphs) throws Exception {
        double step;
        LabelCacheItem labelItem = painter.getLabel();
        Polygon geom = this.getPolySetRepresentativeLocation(labelItem.getGeoms(), displayArea, labelItem.isPartialsEnabled());
        if (geom == null) {
            return false;
        }
        Point centroid = RendererUtilities.getPolygonCentroid(geom);
        if (centroid == null) {
            return false;
        }
        PreparedGeometry pg = PreparedGeometryFactory.prepare((Geometry)geom);
        if (!pg.contains((Geometry)centroid)) {
            Point central = RendererUtilities.sampleForInternalPoint(geom, centroid, pg, this.gf, 5.0, -1);
            if (central != null) {
                centroid = central;
            } else {
                return false;
            }
        }
        TextStyle2DExt textStyle = new TextStyle2DExt(labelItem);
        if (labelItem.getMaxDisplacement() > 0) {
            textStyle.setDisplacementX(0.0);
            textStyle.setDisplacementY(0.0);
            textStyle.setAnchorX(0.5);
            textStyle.setAnchorY(0.5);
        }
        AffineTransform tx = null;
        boolean allowShrinking = labelItem.getFontShrinkSizeMin() > 0 && labelItem.getFontShrinkSizeMin() < textStyle.getFont().getSize();
        int shrinkSize = allowShrinking ? labelItem.getFontShrinkSizeMin() : textStyle.getFont().getSize();
        for (int textSize = textStyle.getFont().getSize(); textSize >= shrinkSize; --textSize) {
            tx = new AffineTransform(tempTransform);
            LabelCacheItem labelItem2 = painter.getLabel();
            TextStyle2DExt textStyle2 = new TextStyle2DExt(labelItem2);
            if (labelItem2.getMaxDisplacement() > 0) {
                textStyle2.setDisplacementX(0.0);
                textStyle2.setDisplacementY(0.0);
                textStyle2.setAnchorX(0.5);
                textStyle2.setAnchorY(0.5);
            }
            labelItem2.setTextStyle(textStyle2);
            painter.setLabel(labelItem2);
            if (!this.paintPolygonLabelInternal(painter, tx, displayArea, glyphs, labelItem2, pg, centroid, textStyle2)) continue;
            return true;
        }
        int[] displacementAngles = labelItem.getDisplacementAngles();
        if (displacementAngles == null) {
            displacementAngles = DEFAULT_DISPLACEMENT_ANGLES;
        }
        painter.setLabel(labelItem);
        Coordinate c = new Coordinate(centroid.getCoordinate());
        Coordinate cc = centroid.getCoordinate();
        Point testPoint = centroid.getFactory().createPoint(c);
        for (double radius = step = painter.getAscent() > 2.0 ? painter.getAscent() : 2.0; radius < (double)labelItem.getMaxDisplacement(); radius += step) {
            for (int angle : displacementAngles) {
                double dx = Math.cos(Math.toRadians(angle)) * radius;
                double dy = Math.sin(Math.toRadians(angle)) * radius;
                c.x = cc.x + dx;
                c.y = cc.y + dy;
                testPoint.geometryChanged();
                if (!pg.contains((Geometry)testPoint)) continue;
                textStyle.setDisplacementX(dx);
                textStyle.setDisplacementY(dy);
                tx = new AffineTransform(tempTransform);
                if (!this.paintPolygonLabelInternal(painter, tx, displayArea, glyphs, labelItem, pg, centroid, textStyle)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean paintPolygonLabelInternal(LabelPainter painter, AffineTransform tempTransform, Rectangle displayArea, LabelIndex glyphs, LabelCacheItem labelItem, PreparedGeometry pg, Point centroid, TextStyle2DExt textStyle) throws Exception {
        AffineTransform original = new AffineTransform(tempTransform);
        this.setupPointTransform(tempTransform, centroid, textStyle, painter);
        Rectangle2D transformed = tempTransform.createTransformedShape(painter.getFullLabelBounds()).getBounds2D();
        if (!displayArea.contains(transformed) && !labelItem.isPartialsEnabled() || labelItem.isConflictResolutionEnabled() && glyphs.labelsWithinDistance(transformed, labelItem.getSpaceAround()) || this.goodnessOfFit(painter, tempTransform, pg) < painter.getLabel().getGoodnessOfFit()) {
            if (textStyle.flipRotation(pg.getGeometry())) {
                tempTransform.setTransform(original);
                this.setupPointTransform(tempTransform, centroid, textStyle, painter);
                transformed = tempTransform.createTransformedShape(painter.getFullLabelBounds()).getBounds2D();
                if (!displayArea.contains(transformed) && !labelItem.isPartialsEnabled() || labelItem.isConflictResolutionEnabled() && glyphs.labelsWithinDistance(transformed, labelItem.getSpaceAround()) || this.goodnessOfFit(painter, tempTransform, pg) < painter.getLabel().getGoodnessOfFit()) {
                    textStyle.flipRotation(pg.getGeometry());
                    return false;
                }
            } else {
                return false;
            }
        }
        if (DEBUG_CACHE_BOUNDS) {
            painter.graphics.setStroke(new BasicStroke());
            painter.graphics.setColor(Color.RED);
            painter.graphics.draw(transformed);
        }
        painter.paintStraightLabel(tempTransform);
        if (labelItem.isConflictResolutionEnabled()) {
            glyphs.addLabel(labelItem, transformed);
        }
        return true;
    }

    Geometry widestGeometry(Geometry geometry) {
        if (!(geometry instanceof GeometryCollection)) {
            return geometry;
        }
        return this.widestGeometry((GeometryCollection)geometry);
    }

    Geometry widestGeometry(GeometryCollection gc) {
        if (gc.isEmpty()) {
            return gc;
        }
        Geometry widest = gc.getGeometryN(0);
        for (int i = 1; i < gc.getNumGeometries(); ++i) {
            Geometry curr = gc.getGeometryN(i);
            if (!(curr.getEnvelopeInternal().getWidth() > widest.getEnvelopeInternal().getWidth())) continue;
            widest = curr;
        }
        return widest;
    }

    Point getPointSetRepresentativeLocation(List<Geometry> geoms, Rectangle displayArea, boolean partialsEnabled) {
        ArrayList<Point> pts = new ArrayList<Point>();
        for (Geometry g : geoms) {
            if (!(g instanceof Point) && !(g instanceof MultiPoint)) {
                g = g.getCentroid();
            }
            if (g instanceof Point) {
                Point point = (Point)g;
                if (!displayArea.contains(point.getX(), point.getY()) && !partialsEnabled) continue;
                pts.add(point);
                continue;
            }
            if (!(g instanceof MultiPoint)) continue;
            for (int t = 0; t < g.getNumGeometries(); ++t) {
                Point gg = (Point)g.getGeometryN(t);
                if (!displayArea.contains(gg.getX(), gg.getY()) && !partialsEnabled) continue;
                pts.add(gg);
            }
        }
        if (pts.isEmpty()) {
            return null;
        }
        return (Point)pts.get(0);
    }

    List<LineString> getLineSetRepresentativeLocation(List<Geometry> geoms, Rectangle displayArea, boolean removeOverlaps, boolean partialsEnabled) {
        ArrayList<LineString> lines = new ArrayList<LineString>();
        for (Geometry geometry : geoms) {
            this.accumulateLineStrings(geometry, lines);
        }
        if (lines.isEmpty()) {
            return null;
        }
        ArrayList<Object> clippedLines = new ArrayList<LineString>();
        for (LineString ls : lines) {
            if (!partialsEnabled) {
                MultiLineString ll = this.clipLineString(ls);
                if (ll == null || ll.isEmpty()) continue;
                for (int t = 0; t < ll.getNumGeometries(); ++t) {
                    clippedLines.add((LineString)ll.getGeometryN(t));
                }
                continue;
            }
            clippedLines.add(ls);
        }
        if (removeOverlaps) {
            ArrayList<LineString> arrayList = new ArrayList<LineString>();
            ArrayList<Geometry> bufferCache = new ArrayList<Geometry>();
            Iterator iterator = clippedLines.iterator();
            while (iterator.hasNext()) {
                LineString ls;
                LineString g = ls = (LineString)iterator.next();
                for (int i = 0; i < arrayList.size(); ++i) {
                    LineString cleaned = (LineString)arrayList.get(i);
                    if (!g.getEnvelopeInternal().intersects(cleaned.getEnvelopeInternal())) continue;
                    Geometry buffer = (Geometry)bufferCache.get(i);
                    if (buffer == null) {
                        buffer = cleaned.buffer(2.0);
                        bufferCache.set(i, buffer);
                    }
                    g = g.difference(buffer);
                }
                int added = this.accumulateLineStrings((Geometry)g, arrayList);
                for (int i = 0; i < added; ++i) {
                    bufferCache.add(null);
                }
            }
            clippedLines = arrayList;
        }
        if (clippedLines == null || clippedLines.isEmpty()) {
            return null;
        }
        List<LineString> list = this.mergeLines(clippedLines);
        if (list.isEmpty()) {
            return null;
        }
        Collections.sort(list, new LineLengthComparator());
        return list;
    }

    private int accumulateLineStrings(Geometry g, List<LineString> lines) {
        if (!(g instanceof LineString || g instanceof MultiLineString || g instanceof Polygon || g instanceof MultiPolygon)) {
            return 0;
        }
        if ((g instanceof Polygon || g instanceof MultiPolygon) && !((g = g.getBoundary()) instanceof LineString) && !(g instanceof MultiLineString)) {
            return 0;
        }
        if (g instanceof LineString) {
            if (g.getLength() != 0.0) {
                lines.add((LineString)g);
                return 1;
            }
            return 0;
        }
        if (g instanceof MultiLineString) {
            for (int t = 0; t < g.getNumGeometries(); ++t) {
                LineString gg = (LineString)g.getGeometryN(t);
                lines.add(gg);
            }
            return g.getNumGeometries();
        }
        int count = 0;
        for (int t = 0; t < g.getNumGeometries(); ++t) {
            count += this.accumulateLineStrings(g.getGeometryN(t), lines);
        }
        return count;
    }

    public MultiLineString clipLineString(LineString line) {
        LineString clip = line;
        line.geometryChanged();
        if (this.clipper.getBounds().contains(line.getEnvelopeInternal())) {
            LineString[] lns = new LineString[]{clip};
            return line.getFactory().createMultiLineString(lns);
        }
        try {
            Geometry g = this.clipper.clip((Geometry)line, false);
            if (g == null) {
                return null;
            }
            if (g instanceof LineString) {
                return line.getFactory().createMultiLineString(new LineString[]{(LineString)g});
            }
            return (MultiLineString)g;
        }
        catch (Exception e) {
            return line.getFactory().createMultiLineString(new LineString[]{line});
        }
    }

    Polygon getPolySetRepresentativeLocation(List<Geometry> geoms, Rectangle displayArea, boolean partialsEnabled) {
        ArrayList<Polygon> polys = new ArrayList<Polygon>();
        Geometry displayGeometry = this.gf.toGeometry(this.toEnvelope(displayArea));
        for (Geometry g : geoms) {
            if (!(g instanceof Polygon) && !(g instanceof MultiPolygon)) continue;
            if (g instanceof Polygon) {
                polys.add((Polygon)g);
                continue;
            }
            for (int t = 0; t < g.getNumGeometries(); ++t) {
                Polygon gg = (Polygon)g.getGeometryN(t);
                polys.add(gg);
            }
        }
        if (polys.isEmpty()) {
            return null;
        }
        ArrayList<Polygon> clippedPolys = new ArrayList<Polygon>();
        Envelope displayGeomEnv = displayGeometry.getEnvelopeInternal();
        for (Polygon p : polys) {
            if (!partialsEnabled) {
                MultiPolygon pp = this.clipPolygon(p, (Polygon)displayGeometry, displayGeomEnv);
                if (pp == null || pp.isEmpty()) continue;
                for (int t = 0; t < pp.getNumGeometries(); ++t) {
                    clippedPolys.add((Polygon)pp.getGeometryN(t));
                }
                continue;
            }
            clippedPolys.add(p);
        }
        if (clippedPolys.isEmpty()) {
            return null;
        }
        double maxSize = -1.0;
        Polygon maxPoly = null;
        for (Polygon clippedPoly : clippedPolys) {
            Polygon cpoly = clippedPoly;
            double area = cpoly.getArea();
            if (!(area > maxSize)) continue;
            maxPoly = cpoly;
            maxSize = area;
        }
        if (maxSize > 0.0) {
            return maxPoly;
        }
        return null;
    }

    public MultiPolygon clipPolygon(Polygon poly, Polygon bbox, Envelope displayGeomEnv) {
        Polygon clip = poly;
        poly.geometryChanged();
        if (displayGeomEnv.contains(poly.getEnvelopeInternal())) {
            Polygon[] polys = new Polygon[]{clip};
            return poly.getFactory().createMultiPolygon(polys);
        }
        try {
            clip = this.clipper.clip((Geometry)poly, false);
        }
        catch (Exception e) {
            clip = poly;
        }
        if (clip instanceof MultiPolygon) {
            return (MultiPolygon)clip;
        }
        if (clip instanceof Polygon) {
            Polygon[] polys = new Polygon[]{clip};
            return poly.getFactory().createMultiPolygon(polys);
        }
        if (clip instanceof Point) {
            return null;
        }
        if (clip instanceof MultiPoint) {
            return null;
        }
        if (clip instanceof LineString) {
            return null;
        }
        if (clip instanceof MultiLineString) {
            return null;
        }
        if (clip == null) {
            return null;
        }
        GeometryCollection gc = (GeometryCollection)clip;
        ArrayList<Polygon> polys = new ArrayList<Polygon>();
        for (int t = 0; t < gc.getNumGeometries(); ++t) {
            Geometry g = gc.getGeometryN(t);
            if (!(g instanceof Polygon)) continue;
            polys.add((Polygon)g);
        }
        if (polys.isEmpty()) {
            return null;
        }
        return poly.getFactory().createMultiPolygon(polys.toArray(new Polygon[1]));
    }

    private List<LineString> mergeLines(Collection<LineString> lines) {
        if (lines.size() <= 1) {
            return new ArrayList<LineString>(lines);
        }
        LineMerger lm = new LineMerger();
        lm.add(lines);
        ArrayList<LineString> merged = new ArrayList<LineString>(lm.getMergedLineStrings());
        if (merged.isEmpty()) {
            return null;
        }
        if (merged.size() == 1) {
            return merged;
        }
        HashMap<Coordinate, List<LineString>> nodes = new HashMap<Coordinate, List<LineString>>(merged.size() * 2);
        for (LineString ls : merged) {
            this.putInNodeHash(ls.getCoordinateN(0), ls, nodes);
            this.putInNodeHash(ls.getCoordinateN(ls.getNumPoints() - 1), ls, nodes);
        }
        ArrayList<LineString> merged_list = new ArrayList<LineString>(merged);
        Collections.sort(merged_list, this.lineLengthComparator);
        return this.processNodes(merged_list, nodes);
    }

    public List<LineString> processNodes(List<LineString> edges, Map<Coordinate, List<LineString>> nodes) {
        ArrayList<LineString> result = new ArrayList<LineString>();
        int index = 0;
        while (index < edges.size()) {
            LineString ls2;
            LineString ls = edges.get(index);
            Coordinate key = ls.getCoordinateN(0);
            List<LineString> nodeList = nodes.get(key);
            if (nodeList == null) {
                ++index;
                continue;
            }
            if (!nodeList.contains(ls)) {
                ++index;
                continue;
            }
            this.removeFromHash(nodes, ls);
            Coordinate key2 = ls.getCoordinateN(ls.getNumPoints() - 1);
            List<LineString> nodeList2 = nodes.get(key2);
            if (nodeList.isEmpty() && nodeList2.isEmpty()) {
                result.add(ls);
                ++index;
                continue;
            }
            if (!nodeList.isEmpty()) {
                ls2 = this.getLongest(nodeList);
                ls = this.merge(ls, ls2);
                this.removeFromHash(nodes, ls2);
            }
            if (!nodeList2.isEmpty()) {
                ls2 = this.getLongest(nodeList2);
                ls = this.merge(ls, ls2);
                this.removeFromHash(nodes, ls2);
            }
            edges.set(index, ls);
            this.putInNodeHash(ls.getCoordinateN(0), ls, nodes);
            this.putInNodeHash(ls.getCoordinateN(ls.getNumPoints() - 1), ls, nodes);
        }
        return result;
    }

    public void removeFromHash(Map<Coordinate, List<LineString>> nodes, LineString ls) {
        Coordinate key = ls.getCoordinateN(0);
        List<LineString> nodeList = nodes.get(key);
        if (nodeList != null) {
            nodeList.remove(ls);
        }
        if ((nodeList = nodes.get(key = ls.getCoordinateN(ls.getNumPoints() - 1))) != null) {
            nodeList.remove(ls);
        }
    }

    private LineString getLongest(List<LineString> al) {
        if (al.size() == 1) {
            return al.get(0);
        }
        double maxLength = -1.0;
        LineString result = null;
        for (LineString l : al) {
            if (!(l.getLength() > maxLength)) continue;
            result = l;
            maxLength = l.getLength();
        }
        return result;
    }

    private void putInNodeHash(Coordinate node, LineString ls, Map<Coordinate, List<LineString>> nodes) {
        List<LineString> nodeList = nodes.get(node);
        if (nodeList == null) {
            nodeList = new ArrayList<LineString>();
            nodeList.add(ls);
            nodes.put(node, nodeList);
        } else {
            nodeList.add(ls);
        }
    }

    private LineString reverse(LineString l) {
        List<Coordinate> clist = Arrays.asList(l.getCoordinates());
        Collections.reverse(clist);
        return l.getFactory().createLineString(clist.toArray(new Coordinate[1]));
    }

    private LineString merge(LineString major, LineString minor) {
        Coordinate major_s = major.getCoordinateN(0);
        Coordinate major_e = major.getCoordinateN(major.getNumPoints() - 1);
        Coordinate minor_s = minor.getCoordinateN(0);
        Coordinate minor_e = minor.getCoordinateN(minor.getNumPoints() - 1);
        if (major_s.equals2D(minor_s)) {
            return this.mergeSimple(this.reverse(minor), major);
        }
        if (major_s.equals2D(minor_e)) {
            return this.mergeSimple(minor, major);
        }
        if (major_e.equals2D(minor_s)) {
            return this.mergeSimple(major, minor);
        }
        if (major_e.equals2D(minor_e)) {
            return this.mergeSimple(major, this.reverse(minor));
        }
        return null;
    }

    private LineString mergeSimple(LineString l1, LineString l2) {
        ArrayList<Coordinate> clist = new ArrayList<Coordinate>(Arrays.asList(l1.getCoordinates()));
        clist.addAll(Arrays.asList(l2.getCoordinates()));
        return l1.getFactory().createLineString(clist.toArray(new Coordinate[1]));
    }

    private Envelope intersection(Envelope e1, Envelope e2) {
        Envelope r = e1.intersection(e2);
        if (r.getWidth() < 0.0) {
            return null;
        }
        if (r.getHeight() < 0.0) {
            return null;
        }
        return r;
    }

    public void addRenderListener(RenderListener listener) {
        this.renderListeners.add(listener);
    }

    private final class LineLengthComparator
    implements Comparator<LineString> {
        private LineLengthComparator() {
        }

        @Override
        public int compare(LineString o1, LineString o2) {
            return Double.compare(o2.getLength(), o1.getLength());
        }
    }

    public static enum LabelRenderingMode {
        STRING,
        OUTLINE,
        ADAPTIVE;

    }
}

