/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.spatial;

import java.util.Collection;
import java.util.List;
import org.geotools.metadata.iso.spatial.GridSpatialRepresentationImpl;
import org.opengis.geometry.primitive.Point;
import org.opengis.metadata.spatial.CellGeometry;
import org.opengis.metadata.spatial.Dimension;
import org.opengis.metadata.spatial.Georectified;
import org.opengis.metadata.spatial.GridSpatialRepresentation;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.util.InternationalString;

public class GeorectifiedImpl
extends GridSpatialRepresentationImpl
implements Georectified {
    private static final long serialVersionUID = 5875851898471237138L;
    private boolean checkPointAvailable;
    private InternationalString checkPointDescription;
    private List<Point> cornerPoints;
    private Point centerPoint;
    private PixelOrientation pointInPixel;
    private InternationalString transformationDimensionDescription;
    private Collection<InternationalString> transformationDimensionMapping;

    public GeorectifiedImpl() {
    }

    public GeorectifiedImpl(Georectified source) {
        super((GridSpatialRepresentation)source);
    }

    public GeorectifiedImpl(int numberOfDimensions, List<? extends Dimension> axisDimensionsProperties, CellGeometry cellGeometry, boolean transformationParameterAvailable, boolean checkPointAvailable, List<? extends Point> cornerPoints, PixelOrientation pointInPixel) {
        super(numberOfDimensions, axisDimensionsProperties, cellGeometry, transformationParameterAvailable);
        this.setCheckPointAvailable(checkPointAvailable);
        this.setCornerPoints(cornerPoints);
        this.setPointInPixel(pointInPixel);
    }

    public boolean isCheckPointAvailable() {
        return this.checkPointAvailable;
    }

    public void setCheckPointAvailable(boolean newValue) {
        this.checkWritePermission();
        this.checkPointAvailable = newValue;
    }

    public InternationalString getCheckPointDescription() {
        return this.checkPointDescription;
    }

    public void setCheckPointDescription(InternationalString newValue) {
        this.checkWritePermission();
        this.checkPointDescription = newValue;
    }

    public List<Point> getCornerPoints() {
        this.cornerPoints = this.nonNullList(this.cornerPoints, Point.class);
        return this.cornerPoints;
    }

    public void setCornerPoints(List<? extends Point> newValues) {
        this.cornerPoints = this.copyList(newValues, this.cornerPoints, Point.class);
    }

    public Point getCenterPoint() {
        return this.centerPoint;
    }

    public void setCenterPoint(Point newValue) {
        this.checkWritePermission();
        this.centerPoint = newValue;
    }

    public PixelOrientation getPointInPixel() {
        return this.pointInPixel;
    }

    public void setPointInPixel(PixelOrientation newValue) {
        this.checkWritePermission();
        this.pointInPixel = newValue;
    }

    public InternationalString getTransformationDimensionDescription() {
        return this.transformationDimensionDescription;
    }

    public void setTransformationDimensionDescription(InternationalString newValue) {
        this.checkWritePermission();
        this.transformationDimensionDescription = newValue;
    }

    public Collection<InternationalString> getTransformationDimensionMapping() {
        this.transformationDimensionMapping = this.nonNullCollection(this.transformationDimensionMapping, InternationalString.class);
        return this.transformationDimensionMapping;
    }

    public void setTransformationDimensionMapping(Collection<? extends InternationalString> newValues) {
        this.transformationDimensionMapping = this.copyCollection(newValues, this.transformationDimensionMapping, InternationalString.class);
    }
}

