/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.util.ArrayList;
import org.geotools.util.Classes;
import org.geotools.util.LocalName;
import org.geotools.util.ScopedName;
import org.opengis.metadata.Identifier;
import org.opengis.util.GenericName;

public final class NameFactory {
    private NameFactory() {
    }

    public static GenericName create(String name) {
        return NameFactory.create(name, ':');
    }

    public static GenericName create(String name, char separator) {
        int upper;
        ArrayList<String> names = new ArrayList<String>();
        int lower = 0;
        while ((upper = name.indexOf(separator, lower)) >= 0) {
            names.add(name.substring(lower, upper));
            lower = upper + 1;
        }
        names.add(name.substring(lower));
        return NameFactory.create((CharSequence[])names.toArray(new String[names.size()]), separator);
    }

    public static GenericName create(CharSequence ... names) {
        return NameFactory.create(names, ':');
    }

    public static GenericName create(CharSequence[] names, char separator) {
        return NameFactory.create(names, names.length, separator);
    }

    private static GenericName create(CharSequence[] names, int length, char separator) {
        if (length <= 0) {
            throw new IllegalArgumentException(String.valueOf(length));
        }
        if (length == 1) {
            return new LocalName(names[0]);
        }
        return new ScopedName(NameFactory.create(names, length - 1, separator), separator, names[length - 1]);
    }

    public static GenericName[] toArray(Object value) throws ClassCastException {
        if (value instanceof GenericName[]) {
            return (GenericName[])value;
        }
        if (value instanceof GenericName) {
            return new GenericName[]{(GenericName)value};
        }
        if (value instanceof CharSequence) {
            return new GenericName[]{NameFactory.create(value.toString())};
        }
        if (value instanceof CharSequence[]) {
            CharSequence[] values = (CharSequence[])value;
            GenericName[] names = new GenericName[values.length];
            for (int i = 0; i < values.length; ++i) {
                CharSequence v = values[i];
                names[i] = v instanceof GenericName ? (GenericName)v : NameFactory.create(v.toString());
            }
            return names;
        }
        if (value instanceof Identifier[]) {
            Identifier[] values = (Identifier[])value;
            GenericName[] names = new GenericName[values.length];
            for (int i = 0; i < values.length; ++i) {
                Identifier v = values[i];
                names[i] = v instanceof GenericName ? (GenericName)v : NameFactory.create(v.getCode());
            }
            return names;
        }
        throw new ClassCastException("Cannot convert " + Classes.getShortClassName(value) + " to GenericName[]");
    }
}

