/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.rmi.server.UID;
import org.geotools.filter.identity.FeatureIdImpl;
import org.geotools.util.Converters;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureFactory;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.PropertyDescriptor;

public abstract class FeatureBuilder<FT extends FeatureType, F extends Feature> {
    protected FT featureType;
    protected FeatureFactory factory;

    public abstract F buildFeature(String var1);

    protected FeatureBuilder(FT featureType, FeatureFactory factory) {
        this.featureType = featureType;
        this.factory = factory;
    }

    public FT getFeatureType() {
        return this.featureType;
    }

    protected Object convert(Object value, PropertyDescriptor descriptor) {
        Class target;
        Object converted;
        if (value != null && (converted = Converters.convert((Object)value, (Class)(target = descriptor.getType().getBinding()))) != null) {
            value = converted;
        }
        return value;
    }

    public static String createDefaultFeatureId() {
        return "fid-" + new UID().toString().replace(':', '_');
    }

    public static FeatureIdImpl createDefaultFeatureIdentifier(String suggestedId) {
        if (suggestedId != null) {
            return new FeatureIdImpl(suggestedId);
        }
        return new FeatureIdImpl(FeatureBuilder.createDefaultFeatureId());
    }
}

