/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.memory;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.collection.AbstractFeatureCollection;
import org.geotools.feature.collection.RandomFeatureAccess;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class MemoryFeatureCollection
extends AbstractFeatureCollection
implements RandomFeatureAccess,
Collection<SimpleFeature> {
    TreeMap<String, SimpleFeature> contents = new TreeMap();

    public MemoryFeatureCollection(SimpleFeatureType schema) {
        super(schema);
    }

    @Override
    public boolean add(SimpleFeature o) {
        SimpleFeature feature = o;
        this.contents.put(feature.getID(), feature);
        return true;
    }

    @Override
    public int size() {
        return this.contents.size();
    }

    public MemoryIterator openIterator() {
        return new MemoryIterator(this.contents.values().iterator());
    }

    public SimpleFeature getFeatureMember(String id) throws NoSuchElementException {
        if (this.contents.containsKey(id)) {
            return this.contents.get(id);
        }
        throw new NoSuchElementException(id);
    }

    public SimpleFeature removeFeatureMember(String id) {
        if (this.contents.containsKey(id)) {
            SimpleFeature old = this.contents.get(id);
            this.contents.remove(id);
            return old;
        }
        return null;
    }

    @Override
    public ReferencedEnvelope getBounds() {
        return DataUtilities.bounds(this.features());
    }

    @Override
    public boolean remove(Object o) {
        return this.contents.values().remove(o);
    }

    @Override
    public boolean addAll(Collection<? extends SimpleFeature> c) {
        boolean changed = false;
        for (SimpleFeature simpleFeature : c) {
            boolean added = this.add(simpleFeature);
            if (changed || !added) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.contents.values().removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.contents.values().retainAll(c);
    }

    @Override
    public void clear() {
        this.contents.clear();
    }

    class MemoryIterator
    implements Iterator<SimpleFeature>,
    SimpleFeatureIterator {
        Iterator<SimpleFeature> it;

        MemoryIterator(Iterator<SimpleFeature> iterator) {
            this.it = iterator;
        }

        public void close() {
            this.it = null;
        }

        @Override
        public boolean hasNext() {
            if (this.it == null) {
                throw new IllegalStateException();
            }
            return this.it.hasNext();
        }

        @Override
        public SimpleFeature next() {
            if (this.it == null) {
                throw new IllegalStateException();
            }
            return this.it.next();
        }

        @Override
        public void remove() {
            this.it.remove();
        }
    }
}

